/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml2.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.saml.attribute.mapping.AttributesMapContainer;
import net.shibboleth.idp.saml.metadata.impl.AttributeMappingNodeProcessor;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.messaging.context.AttributeConsumingServiceContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRequestedAttributesInAttributeConsumingService
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(MapRequestedAttributesInAttributeConsumingService.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeConsumingServiceContext> attributeConsumingServiceContextLookupStrategy = Functions.compose((Function)new ChildContextLookup(AttributeConsumingServiceContext.class), (Function)Functions.compose((Function)new ChildContextLookup(SAMLMetadataContext.class), (Function)Functions.compose((Function)new ChildContextLookup(SAMLPeerEntityContext.class), (Function)new InboundMessageContextLookup())));
    @Nullable
    private ReloadableService<AttributeResolver> attributeResolverService;
    private AttributeConsumingServiceContext acsContext;

    public void setAttributeConsumingServiceContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeConsumingServiceContext> strategy) {
        this.attributeConsumingServiceContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeConsumingServiceContext lookup strategy cannot be null");
    }

    public void setResolverService(@Nonnull ReloadableService<AttributeResolver> resolverService) {
        this.attributeResolverService = (ReloadableService)Constraint.isNotNull(resolverService, (String)"AttributeResolver cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.acsContext = (AttributeConsumingServiceContext)this.attributeConsumingServiceContextLookupStrategy.apply((Object)profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.acsContext == null) {
            this.log.trace("{} AttributeConsumingServiceContext not found", (Object)this.getLogPrefix());
            return;
        }
        AttributeConsumingService acs = this.acsContext.getAttributeConsumingService();
        if (acs == null) {
            this.log.trace("{} no AttributeConsumingService to map", (Object)this.getLogPrefix());
            return;
        }
        if (acs.getRequestAttributes().isEmpty() || acs.getObjectMetadata().containsKey(AttributesMapContainer.class) || acs.getParent() != null) {
            this.log.trace("{} skipping mapping for AttributeConsumingService", (Object)this.getLogPrefix());
            return;
        }
        try {
            AttributeMappingNodeProcessor processor = new AttributeMappingNodeProcessor(this.attributeResolverService);
            this.log.debug("{} mapping requested Attributes for generated AttributeConsumingService", (Object)this.getLogPrefix());
            processor.process((XMLObject)acs);
        }
        catch (FilterException e) {
            this.log.error("{} Error mapping Attributesresponding to request", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RuntimeException");
        }
    }
}

