/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.saml1.profile.impl;

import com.google.common.base.Function;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.DefaultPrincipalDeterminationStrategy;
import net.shibboleth.idp.saml.authn.principal.AuthenticationMethodPrincipal;
import net.shibboleth.idp.saml.profile.impl.BaseAddAuthenticationStatementToAssertion;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.core.SubjectLocality;
import org.opensaml.saml.saml1.profile.SAML1ActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddAuthenticationStatementToAssertion
extends BaseAddAuthenticationStatementToAssertion {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddAuthenticationStatementToAssertion.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, Assertion> assertionLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, AuthenticationMethodPrincipal> methodLookupStrategy;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;

    public void setAssertionLookupStrategy(@Nonnull Function<ProfileRequestContext, Assertion> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.assertionLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertion lookup strategy cannot be null");
    }

    public void setAuthenticationMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthenticationMethodPrincipal> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.methodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication method strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.methodLookupStrategy == null) {
            this.methodLookupStrategy = new DefaultPrincipalDeterminationStrategy(AuthenticationMethodPrincipal.class, (Principal)new AuthenticationMethodPrincipal("urn:oasis:names:tc:SAML:1.0:am:unspecified"));
        }
        if (this.assertionLookupStrategy == null) {
            this.assertionLookupStrategy = new AssertionStrategy();
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        Assertion assertion = (Assertion)this.assertionLookupStrategy.apply((Object)profileRequestContext);
        if (assertion == null) {
            this.log.error("Unable to obtain Assertion to modify");
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return;
        }
        AuthenticationStatement statement = this.buildAuthenticationStatement(profileRequestContext, (RequestedPrincipalContext)authenticationContext.getSubcontext(RequestedPrincipalContext.class));
        assertion.getAuthenticationStatements().add(statement);
        this.log.debug("{} Added AuthenticationStatement to Assertion {}", (Object)this.getLogPrefix(), (Object)assertion.getID());
    }

    @Nonnull
    private AuthenticationStatement buildAuthenticationStatement(@Nonnull ProfileRequestContext profileRequestContext, @Nullable RequestedPrincipalContext requestedPrincipalContext) {
        XMLObjectBuilderFactory bf = XMLObjectProviderRegistrySupport.getBuilderFactory();
        SAMLObjectBuilder statementBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(AuthenticationStatement.TYPE_NAME);
        SAMLObjectBuilder localityBuilder = (SAMLObjectBuilder)bf.getBuilderOrThrow(SubjectLocality.TYPE_NAME);
        AuthenticationStatement statement = (AuthenticationStatement)statementBuilder.buildObject();
        statement.setAuthenticationInstant(new DateTime(this.getAuthenticationResult().getAuthenticationInstant()));
        if (requestedPrincipalContext != null && requestedPrincipalContext.getMatchingPrincipal() != null && requestedPrincipalContext.getMatchingPrincipal() instanceof AuthenticationMethodPrincipal) {
            statement.setAuthenticationMethod(requestedPrincipalContext.getMatchingPrincipal().getName());
        } else {
            statement.setAuthenticationMethod(((AuthenticationMethodPrincipal)this.methodLookupStrategy.apply((Object)profileRequestContext)).getName());
        }
        if (this.getHttpServletRequest() != null) {
            SubjectLocality locality = (SubjectLocality)localityBuilder.buildObject();
            locality.setIPAddress(this.getHttpServletRequest().getRemoteAddr());
            statement.setSubjectLocality(locality);
        } else {
            this.log.debug("{} HttpServletRequest not available, omitting SubjectLocality element", (Object)this.getLogPrefix());
        }
        return statement;
    }

    private class AssertionStrategy
    implements Function<ProfileRequestContext, Assertion> {
        private AssertionStrategy() {
        }

        @Nullable
        public Assertion apply(@Nullable ProfileRequestContext input) {
            if (input != null && input.getOutboundMessageContext() != null) {
                Object outboundMessage = input.getOutboundMessageContext().getMessage();
                if (outboundMessage == null) {
                    Assertion ret = SAML1ActionSupport.buildAssertion((AbstractProfileAction)AddAuthenticationStatementToAssertion.this, (IdentifierGenerationStrategy)AddAuthenticationStatementToAssertion.this.getIdGenerator(), (String)AddAuthenticationStatementToAssertion.this.getIssuerId());
                    input.getOutboundMessageContext().setMessage((Object)ret);
                    return ret;
                }
                if (outboundMessage instanceof Assertion) {
                    return (Assertion)outboundMessage;
                }
                if (outboundMessage instanceof Response) {
                    if (AddAuthenticationStatementToAssertion.this.isStatementInOwnAssertion() || ((Response)outboundMessage).getAssertions().isEmpty()) {
                        return SAML1ActionSupport.addAssertionToResponse((AbstractProfileAction)AddAuthenticationStatementToAssertion.this, (Response)((Response)outboundMessage), (IdentifierGenerationStrategy)AddAuthenticationStatementToAssertion.this.getIdGenerator(), (String)AddAuthenticationStatementToAssertion.this.getIssuerId());
                    }
                    return (Assertion)((Response)outboundMessage).getAssertions().get(0);
                }
            }
            return null;
        }
    }
}

