/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.idp.saml.nameid.IPersistentIdStore;
import net.shibboleth.idp.saml.nameid.PersistentIdEntry;
import net.shibboleth.idp.saml.nameid.PersistentIdStore;
import net.shibboleth.idp.saml.nameid.impl.ComputedPersistentIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.JDBCPersistentIdStore;
import net.shibboleth.idp.saml.nameid.impl.JDBCPersistentIdStoreEx;
import net.shibboleth.idp.saml.nameid.impl.PersistentIdGenerationStrategy;
import net.shibboleth.idp.saml.nameid.impl.PersistentIdStoreEx;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.SAMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredPersistentIdGenerationStrategy
extends AbstractInitializableComponent
implements PersistentIdGenerationStrategy {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(StoredPersistentIdGenerationStrategy.class);
    @NonnullAfterInit
    private PersistentIdStoreEx pidStore;
    @Nullable
    private DataSource dataSource;
    @Nullable
    private PersistentIdStore deprecatedStore;
    @Nullable
    private ComputedPersistentIdGenerationStrategy computedIdStrategy;

    public void setIDStore(@Nullable IPersistentIdStore store) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        if (store instanceof PersistentIdStoreEx) {
            this.pidStore = (PersistentIdStoreEx)store;
            this.deprecatedStore = null;
        } else if (store instanceof PersistentIdStore) {
            this.deprecatedStore = (PersistentIdStore)store;
            this.pidStore = null;
        } else {
            this.pidStore = null;
            this.deprecatedStore = null;
        }
    }

    public void setDataSource(@Nullable DataSource source) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSource = source;
    }

    public void setComputedIdStrategy(@Nullable ComputedPersistentIdGenerationStrategy strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.computedIdStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.pidStore) {
            if (this.dataSource != null) {
                this.log.debug("Creating JDBCPersistentStoreEx instance around supplied DataSource");
                JDBCPersistentIdStoreEx newStore = new JDBCPersistentIdStoreEx();
                newStore.setDataSource(this.dataSource);
                newStore.initialize();
                this.pidStore = newStore;
            } else if (this.deprecatedStore != null) {
                if (this.deprecatedStore instanceof JDBCPersistentIdStore) {
                    this.log.warn("Transferring settings from deprecated JDBCPersistentStore, please update configuration");
                    JDBCPersistentIdStoreEx newStore = new JDBCPersistentIdStoreEx();
                    newStore.setVerifyDatabase(false);
                    newStore.setDataSource(((JDBCPersistentIdStore)this.deprecatedStore).getDataSource());
                    newStore.setQueryTimeout(((JDBCPersistentIdStore)this.deprecatedStore).getQueryTimeout());
                    newStore.setLocalEntityColumn(((JDBCPersistentIdStore)this.deprecatedStore).getLocalEntityColumn());
                    newStore.setPeerEntityColumn(((JDBCPersistentIdStore)this.deprecatedStore).getPeerEntityColumn());
                    newStore.setPersistentIdColumn(((JDBCPersistentIdStore)this.deprecatedStore).getPersistentIdColumn());
                    newStore.setPrincipalNameColumn(((JDBCPersistentIdStore)this.deprecatedStore).getPrincipalNameColumn());
                    newStore.setSourceIdColumn(((JDBCPersistentIdStore)this.deprecatedStore).getSourceIdColumn());
                    newStore.setPeerProvidedIdColumn(((JDBCPersistentIdStore)this.deprecatedStore).getPeerProvidedIdColumn());
                    newStore.setCreateTimeColumn(((JDBCPersistentIdStore)this.deprecatedStore).getCreateTimeColumn());
                    newStore.setDeactivationTimeColumn(((JDBCPersistentIdStore)this.deprecatedStore).getDeactivationTimeColumn());
                    newStore.initialize();
                    this.pidStore = newStore;
                } else {
                    throw new ComponentInitializationException("Non-JDBC version of deprecated PersistentIdStore interface is not usable in this version");
                }
            }
            if (null == this.pidStore) {
                throw new ComponentInitializationException("PersistentIdStore cannot be null");
            }
        }
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generate(@Nonnull @NotEmpty String assertingPartyId, @Nonnull @NotEmpty String relyingPartyId, @Nonnull @NotEmpty String principalName, @Nonnull @NotEmpty String sourceId) throws SAMLException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        try {
            PersistentIdEntry idEntry = this.pidStore.getBySourceValue(assertingPartyId, relyingPartyId, sourceId, principalName, true, this.computedIdStrategy);
            if (idEntry == null) {
                this.log.debug("No persistent ID returned from storage for '{}'", (Object)principalName);
                throw new SAMLException("No persistent ID returned from storage");
            }
            this.log.debug("Obtained persistent ID entry: {}", (Object)idEntry);
            String pid = StringSupport.trimOrNull((String)idEntry.getPersistentId());
            if (null == pid) {
                this.log.debug("Returned persistent ID was null");
                throw new SAMLException("Returned persistent ID was null");
            }
            return pid;
        }
        catch (IOException e) {
            this.log.debug("ID storage error obtaining persistent identifier", (Throwable)e);
            throw new SAMLException("ID storage error obtaining persistent identifier", (Exception)e);
        }
    }
}

