/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid.impl;

import com.google.common.base.Predicate;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationException;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.saml.authn.principal.NameIdentifierPrincipal;
import net.shibboleth.idp.saml.nameid.NameDecoderException;
import net.shibboleth.idp.saml.nameid.NameIDCanonicalizationFlowDescriptor;
import net.shibboleth.idp.saml.nameid.NameIdentifierDecoder;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml1.core.NameIdentifier;
import org.opensaml.saml.saml1.profile.SAML1ObjectSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameIdentifierCanonicalization
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final ActivationCondition embeddedPredicate = new ActivationCondition();
    @NonnullAfterInit
    private NameIdentifierDecoder decoder;

    @NonnullAfterInit
    public NameIdentifierDecoder getDecoder() {
        return this.decoder;
    }

    public void setDecoder(@Nonnull NameIdentifierDecoder theDecoder) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.decoder = (NameIdentifierDecoder)Constraint.isNotNull((Object)theDecoder, (String)"NameIdentifierDecoder cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.decoder) {
            throw new ComponentInitializationException(this.getLogPrefix() + " decoder not supplied");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        if (!this.embeddedPredicate.apply(profileRequestContext, c14nContext, true)) {
            return false;
        }
        return super.doPreExecute(profileRequestContext, c14nContext);
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        Set<NameIdentifierPrincipal> nameIdentifiers = c14nContext.getSubject().getPrincipals(NameIdentifierPrincipal.class);
        NameIdentifier nameIdentifier = nameIdentifiers.iterator().next().getNameIdentifier();
        try {
            c14nContext.setPrincipalName(this.decoder.decode(c14nContext, nameIdentifier));
            if (c14nContext.getPrincipalName() == null) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            }
        }
        catch (NameDecoderException e) {
            c14nContext.setException((Exception)((Object)e));
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"SubjectCanonicalizationError");
        }
    }

    public static class ActivationCondition
    implements Predicate<ProfileRequestContext> {
        @Nonnull
        private Logger log = LoggerFactory.getLogger(ActivationCondition.class);

        public boolean apply(@Nullable ProfileRequestContext input) {
            SubjectCanonicalizationContext c14nContext;
            if (input != null && (c14nContext = (SubjectCanonicalizationContext)input.getSubcontext(SubjectCanonicalizationContext.class)) != null) {
                return this.apply(input, c14nContext, false);
            }
            return false;
        }

        protected boolean formatMatches(@Nonnull @NotEmpty String format, @Nonnull SubjectCanonicalizationContext c14nContext) {
            SubjectCanonicalizationFlowDescriptor flowDescriptor = c14nContext.getAttemptedFlow();
            this.log.debug("Attempting to match format '{}'", (Object)format);
            if (null == flowDescriptor) {
                this.log.error("Supplied Context has no active FlowDescriptor");
                return false;
            }
            if (!(flowDescriptor instanceof NameIDCanonicalizationFlowDescriptor)) {
                this.log.error("Flow Descriptor named {} is not appropriate for NameID canonicalization. Use class=\"{}\"", (Object)flowDescriptor.getId(), (Object)NameIDCanonicalizationFlowDescriptor.class.getCanonicalName());
                return false;
            }
            NameIDCanonicalizationFlowDescriptor nameIDDescriptor = (NameIDCanonicalizationFlowDescriptor)flowDescriptor;
            for (String testFormat : nameIDDescriptor.getFormats()) {
                if (!SAML1ObjectSupport.areNameIdentifierFormatsEquivalent((String)testFormat, (String)format)) continue;
                this.log.debug("NameIDCanonicalizationFlowDescriptor {}: format matches {}", (Object)nameIDDescriptor.getId(), (Object)testFormat);
                return true;
            }
            this.log.debug("NameIDCanonicalizationFlowDescriptor {}: no format matches", (Object)nameIDDescriptor.getId());
            return false;
        }

        public boolean apply(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext, boolean duringAction) {
            Set<NameIdentifierPrincipal> nameIdentifiers = null;
            if (c14nContext.getSubject() != null) {
                nameIdentifiers = c14nContext.getSubject().getPrincipals(NameIdentifierPrincipal.class);
            }
            if (duringAction) {
                if (nameIdentifiers == null || nameIdentifiers.isEmpty()) {
                    c14nContext.setException((Exception)new SubjectCanonicalizationException("No NameIdentifierPrincipals were found"));
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                    return false;
                }
                if (nameIdentifiers.size() > 1) {
                    c14nContext.setException((Exception)new SubjectCanonicalizationException("Multiple NameIdentifierPrincipals were found"));
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                    return false;
                }
                if (!this.formatMatches(nameIdentifiers.iterator().next().getNameIdentifier().getFormat(), c14nContext)) {
                    c14nContext.setException((Exception)new SubjectCanonicalizationException("Format not supported"));
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                    return false;
                }
                return true;
            }
            if (nameIdentifiers == null || nameIdentifiers.size() != 1) {
                return false;
            }
            return this.formatMatches(nameIdentifiers.iterator().next().getNameIdentifier().getFormat(), c14nContext);
        }
    }
}

