/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.attribute.mapping.impl;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.ScopedStringAttributeValue;
import net.shibboleth.idp.saml.attribute.mapping.AbstractSAMLAttributeValueMapper;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.XMLObject;

public class ScopedStringAttributeValueMapper
extends AbstractSAMLAttributeValueMapper {
    private String delimiter = "@";

    @Nonnull
    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(@Nonnull @NotEmpty String delim) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        String trimmed = StringSupport.trimOrNull((String)delim);
        Constraint.isNotNull((Object)trimmed, (String)"ScopedStringAttributeDecoder: delimiter can not be empty null");
        this.delimiter = trimmed;
    }

    @Nullable
    protected IdPAttributeValue<?> decodeValue(@Nonnull XMLObject object) {
        Constraint.isNotNull((Object)object, (String)"Object supplied to must not be null");
        String stringValue = this.getStringValue(object);
        if (null == stringValue) {
            return null;
        }
        int offset = stringValue.indexOf(this.getDelimiter());
        if (offset < 0) {
            return null;
        }
        return ScopedStringAttributeValue.valueOf((String)stringValue.substring(0, offset), (String)stringValue.substring(offset + this.getDelimiter().length()));
    }

    @Nonnull
    protected String getAttributeTypeName() {
        return "Scoped";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ScopedStringAttributeValueMapper) {
            ScopedStringAttributeValueMapper other = (ScopedStringAttributeValueMapper)((Object)obj);
            return Objects.equals(this.getDelimiter(), other.getDelimiter());
        }
        return false;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getAttributeTypeName(), this.getDelimiter()});
    }
}

