/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.profile.config;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.config.DurationToLongConverter;
import net.shibboleth.idp.saml.profile.config.AbstractMetadataDrivenConfigurationLookupStrategy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.saml.saml2.core.Attribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurationConfigurationLookupStrategy
extends AbstractMetadataDrivenConfigurationLookupStrategy<Long> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DurationConfigurationLookupStrategy.class);
    @Nonnull
    private final DurationToLongConverter durationConverter = new DurationToLongConverter();

    @Override
    @Nullable
    protected Long doTranslate(@Nonnull Attribute tag) {
        List values = tag.getAttributeValues();
        if (values.size() != 1) {
            this.log.error("Tag '{}' contained multiple values, returning none");
            return null;
        }
        this.log.debug("Converting tag '{}' to Long duration property", (Object)tag.getName());
        return this.xmlObjectToDuration((XMLObject)values.get(0));
    }

    @Nullable
    private Long xmlObjectToDuration(@Nonnull XMLObject object) {
        XSAny wc;
        if (object instanceof XSString) {
            String value = ((XSString)object).getValue();
            if (value != null) {
                try {
                    return this.durationConverter.convert(value);
                }
                catch (IllegalArgumentException e) {
                    this.log.error("Error converting duration", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        if (object instanceof XSInteger) {
            Integer value = ((XSInteger)object).getValue();
            return value != null ? Long.valueOf(value.longValue()) : null;
        }
        if (object instanceof XSAny && (wc = (XSAny)object).getUnknownAttributes().isEmpty() && wc.getUnknownXMLObjects().isEmpty()) {
            String value = wc.getTextContent();
            if (value != null) {
                try {
                    return this.durationConverter.convert(value);
                }
                catch (IllegalArgumentException e) {
                    this.log.error("Error converting duration", (Throwable)e);
                    return null;
                }
            }
            return null;
        }
        this.log.error("Unsupported conversion to Long duration from XMLObject type ({})", (Object)object.getClass().getName());
        return null;
    }
}

