/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.nameid;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonStructure;
import javax.json.stream.JsonGenerator;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientIdParameters {
    @Nonnull
    @NotEmpty
    public static final String CONTEXT = "TransientId";
    private static final String ATTRIBUTE_RECIPIENT_FIELD = "sp";
    private static final String PRINCIPAL_FIELD = "princ";
    private final Logger log = LoggerFactory.getLogger(TransientIdParameters.class);
    private final String attributeRecipient;
    private final String principal;

    public TransientIdParameters(@Nullable String recipient, @Nullable String thePrincipal) {
        this.attributeRecipient = recipient;
        this.principal = thePrincipal;
    }

    public TransientIdParameters(@Nonnull @NotEmpty String encoded) throws IOException {
        Constraint.isNotNull((Object)StringSupport.trimOrNull((String)encoded), (String)"encoded data must not be null or empty");
        JsonReader reader = Json.createReader((Reader)new StringReader(encoded));
        JsonStructure st = reader.read();
        if (!(st instanceof JsonObject)) {
            throw new IOException("Found invalid data structure while parsing IdPSession");
        }
        JsonObject jsonObj = (JsonObject)st;
        this.principal = jsonObj.getString(PRINCIPAL_FIELD);
        this.attributeRecipient = jsonObj.getString(ATTRIBUTE_RECIPIENT_FIELD);
    }

    @Nullable
    public String getAttributeRecipient() {
        return this.attributeRecipient;
    }

    @Nullable
    public String getPrincipal() {
        return this.principal;
    }

    @Nonnull
    public String encode() throws IOException {
        try {
            StringWriter sink = new StringWriter(128);
            JsonGenerator gen = Json.createGenerator((Writer)sink);
            gen.writeStartObject().write(ATTRIBUTE_RECIPIENT_FIELD, this.getAttributeRecipient()).write(PRINCIPAL_FIELD, this.getPrincipal());
            gen.writeEnd().close();
            return sink.toString();
        }
        catch (JsonException e) {
            this.log.error("Exception while serializing IdPSession", (Throwable)e);
            throw new IOException("Exception while serializing IdPSession", e);
        }
    }
}

