/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.saml.authn.principal;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.principal.CloneablePrincipal;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public final class AuthenticationMethodPrincipal
implements CloneablePrincipal {
    @Nonnull
    @NotEmpty
    private String authnMethod;

    public AuthenticationMethodPrincipal(@Nonnull @ParameterName(name="method") @NotEmpty String method) {
        this.authnMethod = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)method), (String)"AuthenticationMethod cannot be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getName() {
        return this.authnMethod;
    }

    public int hashCode() {
        return this.authnMethod.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof AuthenticationMethodPrincipal) {
            return this.authnMethod.equals(((AuthenticationMethodPrincipal)other).getName());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("authnMethod", (Object)this.authnMethod).toString();
    }

    public AuthenticationMethodPrincipal clone() throws CloneNotSupportedException {
        AuthenticationMethodPrincipal copy = (AuthenticationMethodPrincipal)super.clone();
        copy.authnMethod = this.authnMethod;
        return copy;
    }
}

