/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.resolver;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

@ThreadSafe
public final class ResolverPluginDependency {
    private final String dependencyPluginId;
    private String dependencyAttributeId;

    public ResolverPluginDependency(@Nonnull @ParameterName(name="pluginId") @NotEmpty String pluginId) {
        this.dependencyPluginId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)pluginId), (String)"Dependency plugin ID may not be null or empty");
    }

    @Nonnull
    public String getDependencyPluginId() {
        return this.dependencyPluginId;
    }

    public void setDependencyAttributeId(@Nullable String attributeId) {
        this.dependencyAttributeId = StringSupport.trimOrNull((String)attributeId);
    }

    @Nullable
    public String getDependencyAttributeId() {
        return this.dependencyAttributeId;
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.dependencyPluginId, this.dependencyAttributeId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResolverPluginDependency other = (ResolverPluginDependency)obj;
        return Objects.equals(this.getDependencyPluginId(), other.getDependencyPluginId()) && Objects.equals(this.getDependencyAttributeId(), other.getDependencyAttributeId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pluginId", (Object)this.dependencyPluginId).add("attributeId", (Object)this.dependencyAttributeId).toString();
    }
}

