/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.attribute.context;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import org.opensaml.messaging.context.BaseContext;

@NotThreadSafe
public class AttributeContext
extends BaseContext {
    private Map<String, IdPAttribute> attributes = Collections.emptyMap();

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, IdPAttribute> getIdPAttributes() {
        return this.attributes;
    }

    public void setIdPAttributes(@Nullable @NullableElements Collection<IdPAttribute> newAttributes) {
        if (newAttributes == null) {
            this.attributes = Collections.emptyMap();
            return;
        }
        HashMap<String, IdPAttribute> checkedAttributes = new HashMap<String, IdPAttribute>();
        for (IdPAttribute attribute : newAttributes) {
            if (attribute == null) continue;
            checkedAttributes.put(attribute.getId(), attribute);
        }
        this.attributes = ImmutableMap.copyOf(checkedAttributes);
    }
}

