/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.velocity;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import net.shibboleth.ext.spring.velocity.VelocityConfig;
import net.shibboleth.ext.spring.velocity.VelocityEngineFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.web.context.ServletContextAware;

public class VelocityConfigurer
extends VelocityEngineFactory
implements VelocityConfig,
InitializingBean,
ResourceLoaderAware,
ServletContextAware {
    private static final String SPRING_MACRO_RESOURCE_LOADER_NAME = "springMacro";
    private static final String SPRING_MACRO_RESOURCE_LOADER_CLASS = "resource.loader.springMacro.class";
    private static final String SPRING_MACRO_LIBRARY = "net/shibboleth/ext/spring/velocity/spring.vm";
    @Nullable
    private ServletContext servletContext;
    @Nullable
    private VelocityEngine velocityEngine;

    public void setServletContext(ServletContext context) {
        this.servletContext = context;
    }

    public void afterPropertiesSet() throws IOException, VelocityException {
        if (this.velocityEngine == null) {
            this.velocityEngine = this.createVelocityEngine();
        }
    }

    @Override
    protected void postProcessVelocityEngine(@Nonnull VelocityEngine engine) {
        this.velocityEngine = engine;
        this.velocityEngine.setApplicationAttribute((Object)ServletContext.class.getName(), (Object)this.servletContext);
        this.velocityEngine.setProperty(SPRING_MACRO_RESOURCE_LOADER_CLASS, (Object)ClasspathResourceLoader.class.getName());
        this.velocityEngine.addProperty("resource.loaders", (Object)SPRING_MACRO_RESOURCE_LOADER_NAME);
        this.velocityEngine.addProperty("velocimacro.library.path", (Object)SPRING_MACRO_LIBRARY);
    }

    @Override
    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }
}

