/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.util.AbstractSpringExpressionEvaluatorEx;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;

public class SpringExpressionBiPredicate<T, U>
extends AbstractSpringExpressionEvaluatorEx
implements BiPredicate<T, U> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringExpressionBiPredicate.class);
    @Nullable
    private Pair<Class<T>, Class<U>> inputTypes;

    public SpringExpressionBiPredicate(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        super(expression);
        this.setOutputType(Boolean.class);
        this.setReturnOnError(false);
    }

    @Nullable
    public Pair<Class<T>, Class<U>> getInputTypes() {
        return this.inputTypes;
    }

    public void setInputTypes(@Nullable Pair<Class<T>, Class<U>> types) {
        this.inputTypes = types != null && types.getFirst() != null && types.getSecond() != null ? types : null;
    }

    public void setReturnOnError(boolean flag) {
        this.setReturnOnError((Object)flag);
    }

    @Override
    public boolean test(@Nullable T first, @Nullable U second) {
        Object result;
        Pair<Class<T>, Class<U>> types = this.getInputTypes();
        if (null != types) {
            if (null != first && !((Class)types.getFirst()).isInstance(first)) {
                this.log.error("Input of type {} was not of type {}", first.getClass(), types.getFirst());
                return (Boolean)this.getReturnOnError();
            }
            if (null != second && !((Class)types.getSecond()).isInstance(second)) {
                this.log.error("Input of type {} was not of type {}", second.getClass(), types.getSecond());
                return (Boolean)this.getReturnOnError();
            }
        }
        return (Boolean)((result = this.evaluate(first, second)) != null ? result : this.getReturnOnError());
    }

    @Override
    protected void prepareContext(@Nonnull EvaluationContext context, Object ... input) {
        context.setVariable("input1", input[0]);
        context.setVariable("input2", input[1]);
    }
}

