/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import net.shibboleth.utilities.java.support.logic.Constraint;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class PreferFileSystemResourceLoader
extends DefaultResourceLoader {
    protected Resource getResourceByPath(String path) {
        FileSystemResource r = new FileSystemResource(path);
        if (r.exists()) {
            return r;
        }
        return super.getResourceByPath(path);
    }

    public Resource getResource(String location) {
        Constraint.isNotNull((Object)location, (String)"Location must not be null");
        if (location.startsWith("classpath*:")) {
            return new ClassPathResource(location.substring("classpath*:".length()), this.getClassLoader());
        }
        return super.getResource(location);
    }
}

