/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.util.AbstractSpringExpressionEvaluatorEx;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;

public class SpringExpressionConsumer<T>
extends AbstractSpringExpressionEvaluatorEx
implements Consumer<T> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringExpressionConsumer.class);
    @Nullable
    private Class<T> inputTypeClass;

    public SpringExpressionConsumer(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        super(expression);
    }

    @Nullable
    public Class<T> getInputType() {
        return this.inputTypeClass;
    }

    public void setInputType(@Nullable Class<T> type) {
        this.inputTypeClass = type;
    }

    @Override
    public void accept(@Nullable T input) {
        if (null != this.getInputType() && null != input && !this.getInputType().isInstance(input)) {
            this.log.error("Input of type {} was not of type {}", input.getClass(), this.getInputType());
        } else {
            this.evaluate(input);
        }
    }

    @Override
    protected void prepareContext(@Nonnull EvaluationContext context, Object ... input) {
        context.setVariable("input", input[0]);
    }
}

