/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.IdentifiedComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifiedComponentManager<T extends IdentifiedComponent> {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(IdentifiedComponentManager.class);
    @Nonnull
    @NonnullElements
    private Collection<T> initialComponents;
    @Nonnull
    @NonnullElements
    private Collection<T> components;

    public IdentifiedComponentManager(@Nullable @NonnullElements Collection<T> freeObjects) {
        this.initialComponents = freeObjects != null ? List.copyOf(freeObjects) : Collections.emptyList();
        this.components = this.initialComponents;
    }

    public void setComponents(@Nullable @NonnullElements Collection<T> additionalObjects) {
        if (additionalObjects != null) {
            LinkedHashSet<T> holder = new LinkedHashSet<T>(additionalObjects);
            holder.addAll(this.initialComponents.stream().filter(obj -> {
                if (holder.contains(obj)) {
                    this.log.info("Replacing auto-wired component: {}", (Object)obj.getId());
                    return false;
                }
                return true;
            }).collect(Collectors.toUnmodifiableList()));
            this.components = List.copyOf(holder);
        } else {
            this.components = this.initialComponents;
        }
    }

    @Nonnull
    @NonnullElements
    public Collection<T> getComponents() {
        return this.components;
    }
}

