/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import net.shibboleth.ext.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.HttpServletSupport;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import net.shibboleth.utilities.java.support.xml.XMLConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public final class SpringSupport {
    @Nonnull
    public static final QName SPRING_BEANS_ELEMENT_NAME = new QName("http://www.springframework.org/schema/beans", "beans");
    @Nonnull
    static final Logger LOG = LoggerFactory.getLogger(SpringSupport.class);

    private SpringSupport() {
    }

    @Nullable
    public static void parseCustomElements(@Nullable @NonnullElements Collection<Element> elements, @Nonnull ParserContext parserContext) {
        if (elements == null) {
            return;
        }
        for (Element e : elements) {
            if (e == null) continue;
            SpringSupport.parseCustomElement(e, parserContext, null, false);
        }
    }

    @Nullable
    public static ManagedList<BeanDefinition> parseCustomElements(@Nullable @NonnullElements Collection<Element> elements, @Nonnull ParserContext parserContext, @Nonnull BeanDefinitionBuilder parentBuilder) {
        if (elements == null) {
            return null;
        }
        Constraint.isNotNull((Object)parentBuilder, (String)"parentBuilder must not be null");
        ManagedList definitions = new ManagedList(elements.size());
        for (Element e : elements) {
            if (e == null) continue;
            definitions.add((Object)SpringSupport.parseCustomElement(e, parserContext, parentBuilder, false));
        }
        return definitions;
    }

    @Nullable
    public static void parseLazyInitCustomElements(@Nullable @NonnullElements Collection<Element> elements, @Nonnull ParserContext parserContext) {
        if (elements == null) {
            return;
        }
        for (Element e : elements) {
            if (e == null) continue;
            SpringSupport.parseLazyInitCustomElement(e, parserContext);
        }
    }

    @Nullable
    public static BeanDefinition parseCustomElement(@Nullable Element element, @Nonnull ParserContext parserContext, @Nullable BeanDefinitionBuilder parentBuilder, boolean lazyInit) {
        if (element == null) {
            return null;
        }
        AbstractBeanDefinition containingBd = parentBuilder != null ? parentBuilder.getRawBeanDefinition() : null;
        BeanDefinition def = parserContext.getDelegate().parseCustomElement(element, (BeanDefinition)containingBd);
        if (lazyInit) {
            def.setLazyInit(true);
        }
        if (null == parentBuilder) {
            return null;
        }
        return def;
    }

    @Nullable
    public static void parseLazyInitCustomElement(@Nullable Element element, @Nonnull ParserContext parserContext) {
        if (element == null) {
            return;
        }
        SpringSupport.parseCustomElement(element, parserContext, null, true);
    }

    public static void parseNativeElement(@Nonnull Element springBeans, @Nullable BeanDefinitionRegistry registry) {
        XmlBeanDefinitionReader definitionReader = new XmlBeanDefinitionReader(registry);
        definitionReader.setValidationMode(3);
        definitionReader.setNamespaceAware(true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SerializeSupport.writeNode((Node)springBeans, (OutputStream)outputStream);
        definitionReader.loadBeanDefinitions(new InputSource(new ByteArrayInputStream(outputStream.toByteArray())));
    }

    @Nonnull
    public static BeanFactory createBeanFactory(@Nonnull Element springBeans) {
        if (!springBeans.hasAttributeNS(XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getNamespaceURI(), XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getLocalPart())) {
            for (Node parent = springBeans.getParentNode(); parent != null && parent.getNodeType() == 1; parent = parent.getParentNode()) {
                String schemaLoc = ((Element)parent).getAttributeNS(XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getNamespaceURI(), XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getLocalPart());
                if (Strings.isNullOrEmpty((String)schemaLoc)) continue;
                springBeans.setAttributeNS(XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getNamespaceURI(), XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getPrefix() + ":" + XMLConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.getLocalPart(), schemaLoc);
                break;
            }
        }
        FilesystemGenericApplicationContext ctx = new FilesystemGenericApplicationContext();
        SpringSupport.parseNativeElement(springBeans, (BeanDefinitionRegistry)ctx);
        ctx.refresh();
        return ctx.getBeanFactory();
    }

    @Nullable
    public static <T> T getBean(@Nonnull BeanFactory beanFactory, @Nonnull Class<T> clazz) {
        Object bean = null;
        try {
            bean = beanFactory.getBean(clazz);
            LOG.debug("created spring bean {}", bean);
        }
        catch (NoSuchBeanDefinitionException e) {
            LOG.debug("no spring bean configured of type {}", clazz);
        }
        return (T)bean;
    }

    @Nonnull
    public static AbstractBeanDefinition getAttributeValueAsList(@Nonnull Attr attribute) {
        BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(StringSupport.class, (String)"stringToList");
        result.addConstructorArgValue((Object)attribute.getValue());
        result.addConstructorArgValue((Object)" \n\r\t");
        return result.getBeanDefinition();
    }

    @Nullable
    public static AbstractBeanDefinition getStringValueAsBoolean(@Nullable String string) {
        BeanDefinitionBuilder result = BeanDefinitionBuilder.rootBeanDefinition(StringSupport.class, (String)"booleanOf");
        result.addConstructorArgValue((Object)string);
        return result.getBeanDefinition();
    }

    @Nonnull
    public static ManagedList<String> getElementTextContentAsManagedList(@Nullable Collection<Element> elements) {
        if (null == elements || elements.isEmpty()) {
            return new ManagedList(0);
        }
        ManagedList result = new ManagedList(elements.size());
        for (Element element : elements) {
            String textContent = StringSupport.trimOrNull((String)element.getTextContent());
            if (null == textContent) continue;
            result.add((Object)textContent);
        }
        return result;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public static List<Locale.LanguageRange> getLanguageRange(HttpServletRequest request) {
        List fromBrowser = HttpServletSupport.getLanguageRange((HttpServletRequest)request);
        ArrayList<Locale.LanguageRange> outList = new ArrayList<Locale.LanguageRange>(1 + fromBrowser.size());
        outList.add(new Locale.LanguageRange(RequestContextUtils.getLocale((HttpServletRequest)request).getLanguage()));
        outList.addAll(fromBrowser);
        return List.copyOf(outList);
    }
}

