/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.ext.spring.util.AbstractSpringExpressionEvaluatorEx;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;

public class SpringExpressionFunction<T, U>
extends AbstractSpringExpressionEvaluatorEx
implements Function<T, U> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SpringExpressionFunction.class);
    @Nullable
    private Class<T> inputType;

    public SpringExpressionFunction(@Nonnull @ParameterName(name="expression") @NotEmpty String expression) {
        super(expression);
    }

    @Nullable
    public Class<T> getInputType() {
        return this.inputType;
    }

    public void setInputType(@Nullable Class<T> type) {
        this.inputType = type;
    }

    @Override
    public void setOutputType(@Nullable Class<?> type) {
        super.setOutputType(type);
    }

    @Override
    public void setReturnOnError(@Nullable Object value) {
        super.setReturnOnError(value);
    }

    @Override
    public U apply(@Nullable T input) {
        if (null != input && null != this.getInputType() && !this.getInputType().isInstance(input)) {
            this.log.error("Input was type {} which is not an instance of {}", input.getClass(), this.getInputType());
            throw new ClassCastException("Input was type " + input.getClass() + " which is not an instance of " + this.getInputType());
        }
        return (U)this.evaluate(input);
    }

    @Override
    protected void prepareContext(@Nonnull EvaluationContext context, Object ... input) {
        context.setVariable("input", input[0]);
    }
}

