/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.util;

import java.util.LinkedHashSet;
import net.shibboleth.ext.spring.util.SchemaTypeAwareBeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SchemaTypeAwareBeanDefinitionDocumentReader
extends DefaultBeanDefinitionDocumentReader {
    protected void importBeanDefinitionResource(Element ele) {
        String location = ele.getAttribute("resource");
        if (!StringUtils.hasText((String)location)) {
            this.getReaderContext().error("Resource location must not be empty", (Object)ele);
            return;
        }
        location = this.getReaderContext().getEnvironment().resolveRequiredPlaceholders(location);
        LinkedHashSet<Resource> actualResources = new LinkedHashSet<Resource>(4);
        Resource r = this.getReaderContext().getResourceLoader().getResource(location);
        if (r.exists()) {
            int importCount = this.getReaderContext().getReader().loadBeanDefinitions(r);
            actualResources.add(r);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Imported " + importCount + " bean definitions from location [" + location + "]"));
            }
            Resource[] actResArray = actualResources.toArray(new Resource[0]);
            this.getReaderContext().fireImportProcessed(location, actResArray, this.extractSource(ele));
            return;
        }
        this.logger.debug((Object)("Resource location [" + location + "] does not exist, delegating to default behavior"));
        super.importBeanDefinitionResource(ele);
    }

    protected BeanDefinitionParserDelegate createDelegate(XmlReaderContext readerContext, Element root, BeanDefinitionParserDelegate parentDelegate) {
        SchemaTypeAwareBeanDefinitionParserDelegate delegate = new SchemaTypeAwareBeanDefinitionParserDelegate(readerContext);
        delegate.initDefaults(root, parentDelegate);
        return delegate;
    }
}

