/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.context;

import javax.servlet.ServletContext;
import net.shibboleth.ext.spring.resource.ConditionalResourceResolver;
import net.shibboleth.ext.spring.util.AnnotationParameterNameDiscoverer;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class FilesystemGenericWebApplicationContext
extends GenericWebApplicationContext {
    public FilesystemGenericWebApplicationContext() {
        this.getDefaultListableBeanFactory().setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    public FilesystemGenericWebApplicationContext(DefaultListableBeanFactory beanFactory) {
        super(beanFactory);
        beanFactory.setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    public FilesystemGenericWebApplicationContext(ServletContext context) {
        super(context);
        this.getDefaultListableBeanFactory().setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    public FilesystemGenericWebApplicationContext(DefaultListableBeanFactory beanFactory, ServletContext context) {
        super(beanFactory, context);
        beanFactory.setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        this.addProtocolResolver(new ConditionalResourceResolver());
    }

    protected Resource getResourceByPath(String path) {
        FileSystemResource r = new FileSystemResource(path);
        if (r.exists()) {
            return r;
        }
        return super.getResourceByPath(path);
    }
}

