/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import javax.annotation.Nonnull;
import net.shibboleth.ext.spring.resource.ConditionalResource;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ConditionalResourceResolver
implements ProtocolResolver {
    @Nonnull
    @NotEmpty
    static final String CONDITIONAL_RESOURCE_PREFIX = "conditional:";

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        Resource wrapped;
        if (location.startsWith(CONDITIONAL_RESOURCE_PREFIX) && (wrapped = resourceLoader.getResource(location.substring(CONDITIONAL_RESOURCE_PREFIX.length()))) != null) {
            ConditionalResource r = new ConditionalResource(wrapped);
            r.setId(location);
            try {
                r.initialize();
            }
            catch (ComponentInitializationException componentInitializationException) {
                // empty catch block
            }
            return r;
        }
        return null;
    }
}

