/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNRunnable
extends AbstractIdentifiedInitializableComponent
implements Runnable,
BeanNameAware,
InitializingBean {
    private final Logger log = LoggerFactory.getLogger(SVNRunnable.class);
    @Nonnull
    private final SVNClientManager clientManager;
    @Nonnull
    private SVNURL remoteRepository;
    @Nonnull
    private File workingCopyDirectory;
    private SVNRevision retrievalRevision;

    public SVNRunnable(@Nonnull @ParameterName(name="svnClientMgr") SVNClientManager svnClientMgr, @Nonnull @ParameterName(name="repositoryUrl") SVNURL repositoryUrl, @Nonnull @ParameterName(name="workingCopy") File workingCopy, @ParameterName(name="workingRevision") long workingRevision) {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        if (svnClientMgr == null) {
            this.log.error("SVN client manager may not be null");
            throw new BeanCreationException("SVN client manager may not be null");
        }
        this.clientManager = svnClientMgr;
        if (repositoryUrl == null) {
            throw new BeanCreationException("SVN repository URL may not be null");
        }
        this.remoteRepository = repositoryUrl;
        try {
            this.checkWorkingCopyDirectory(workingCopy);
            this.workingCopyDirectory = workingCopy;
        }
        catch (IOException e) {
            throw new BeanCreationException(e.getMessage());
        }
        this.retrievalRevision = workingRevision < 0L ? SVNRevision.HEAD : SVNRevision.create((long)workingRevision);
        try {
            this.checkoutOrUpdate();
        }
        catch (IOException e) {
            throw new BeanCreationException(e.getMessage());
        }
    }

    protected String getProtocol() {
        StringBuffer buffer = new StringBuffer(4 + this.remoteRepository.getProtocol().length());
        buffer.append("svn+").append(this.remoteRepository.getProtocol());
        return buffer.toString();
    }

    protected void checkWorkingCopyDirectory(@Nonnull File directory) throws IOException {
        boolean created;
        if (directory == null) {
            this.log.error("SVN working copy directory cannot be null");
            throw new IOException("SVN working copy directory cannot be null");
        }
        if (!directory.exists() && !(created = directory.mkdirs())) {
            String msg = "SVN working copy directory " + directory.getAbsolutePath() + " does not exist and could not be created";
            this.log.error(msg);
            throw new IOException(msg);
        }
        if (!directory.isDirectory()) {
            String msg = "SVN working copy location " + directory.getAbsolutePath() + " is not a directory";
            this.log.error(msg);
            throw new IOException(msg);
        }
        if (!directory.canRead()) {
            String msg = "SVN working copy directory " + directory.getAbsolutePath() + " cannot be read by this process";
            this.log.error(msg);
            throw new IOException(msg);
        }
        if (!directory.canWrite()) {
            String msg = "SVN working copy directory " + directory.getAbsolutePath() + " cannot be written to by this process";
            this.log.error(msg);
            throw new IOException(msg);
        }
    }

    protected void checkoutOrUpdate() throws IOException {
        this.log.debug("checking out or updating working copy");
        if (!this.workingCopyDirectoryExists()) {
            this.log.debug("Working copy does not yet exist, checking it out to {}", (Object)this.workingCopyDirectory.getAbsolutePath());
            this.checkoutResourceDirectory();
        } else {
            if (this.retrievalRevision != SVNRevision.HEAD) {
                this.log.debug("Working copy exists and version is pegged at {}, no need to update", (Object)this.retrievalRevision.toString());
                return;
            }
            this.log.debug("Working copy exists, updating to latest version.");
            this.updateResourceDirectory();
        }
    }

    private boolean workingCopyDirectoryExists() {
        File svnMetadataDir = new File(this.workingCopyDirectory, ".svn");
        return svnMetadataDir.exists();
    }

    private SVNRevision checkoutResourceDirectory() throws IOException {
        try {
            long newRevision = this.clientManager.getUpdateClient().doCheckout(this.remoteRepository, this.workingCopyDirectory, this.retrievalRevision, this.retrievalRevision, SVNDepth.INFINITY, true);
            this.log.debug("Checked out revision {} from remote repository {} and stored it in local working directory {}", new Object[]{newRevision, this.remoteRepository.toDecodedString(), this.workingCopyDirectory.getAbsolutePath()});
            return SVNRevision.create((long)newRevision);
        }
        catch (SVNException e) {
            String errMsg = "Unable to check out revsion " + this.retrievalRevision.toString() + " from remote repository " + this.remoteRepository.toDecodedString() + " to local working directory " + this.workingCopyDirectory.getAbsolutePath();
            this.log.error(errMsg, (Throwable)e);
            throw new IOException(errMsg, e);
        }
    }

    private void updateResourceDirectory() throws IOException {
        try {
            long newRevision = this.clientManager.getUpdateClient().doUpdate(this.workingCopyDirectory, this.retrievalRevision, SVNDepth.INFINITY, true, true);
            this.log.debug("Updated local working directory {} to revision {} from remote repository {}", new Object[]{this.workingCopyDirectory.getAbsolutePath(), newRevision, this.remoteRepository.toDecodedString()});
        }
        catch (SVNException e) {
            String errMsg = "Unable to update working copy of resoure " + this.remoteRepository.toDecodedString() + " in working copy " + this.workingCopyDirectory.getAbsolutePath() + " to revsion " + this.retrievalRevision.toString();
            this.log.error(errMsg, (Throwable)e);
            throw new IOException(errMsg, e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    public void setBeanName(String name) {
        if (!this.isInitialized()) {
            this.setId(name);
        }
    }

    @Override
    public void run() {
        try {
            this.checkoutOrUpdate();
        }
        catch (IOException e) {
            this.log.error("Failed to update", (Throwable)e);
        }
    }
}

