/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.IOException;
import net.shibboleth.ext.spring.resource.ConditionalResource;
import net.shibboleth.ext.spring.resource.ConditionalResourceResolver;
import net.shibboleth.ext.spring.resource.HTTPResource;
import net.shibboleth.ext.spring.resource.ResourceTestHelper;
import net.shibboleth.ext.spring.util.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.repository.RepositorySupport;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ConditionalResourceTest {
    private final String existsURL = RepositorySupport.buildHTTPResourceURL((String)"spring-extensions", (String)"src/test/resources/net/shibboleth/ext/spring/resource/document.xml", (boolean)false);
    private final String nonExistsURL = RepositorySupport.buildHTTPResourceURL((String)"spring-extensions.git", (String)"trunk/src/test/resources/data/document.xml", (boolean)false);
    private HttpClient client;

    @BeforeClass
    public void setupClient() throws Exception {
        this.client = new HttpClientBuilder().buildClient();
    }

    @Test
    public void existsTest() throws IOException, ComponentInitializationException {
        HTTPResource existsHTTPResource = new HTTPResource(this.client, this.existsURL);
        HTTPResource notExistsHTTPResource = new HTTPResource(this.client, this.nonExistsURL);
        ConditionalResource existsResource = new ConditionalResource((Resource)existsHTTPResource);
        ConditionalResource notExistsResource = new ConditionalResource((Resource)notExistsHTTPResource);
        existsResource.setId("test");
        existsResource.initialize();
        notExistsResource.setId("test");
        notExistsResource.initialize();
        Assert.assertTrue((boolean)existsHTTPResource.exists());
        Assert.assertFalse((boolean)notExistsHTTPResource.exists());
        Assert.assertTrue((boolean)existsResource.exists());
        Assert.assertTrue((boolean)notExistsResource.exists());
    }

    @Test
    public void contextHandlerFailBeforeTest() throws IOException, ComponentInitializationException {
        HTTPResource existsHTTPResource = new HTTPResource(this.client, this.existsURL);
        existsHTTPResource.setHttpClientContextHandler(new HttpClientContextHandler(){

            public void invokeBefore(HttpClientContext context, HttpUriRequest request) throws IOException {
                throw new IOException("Fail");
            }

            public void invokeAfter(HttpClientContext context, HttpUriRequest request) throws IOException {
            }
        });
        ConditionalResource existsResource = new ConditionalResource((Resource)existsHTTPResource);
        existsResource.setId("test");
        existsResource.initialize();
        Assert.assertTrue((boolean)existsResource.exists());
    }

    @Test
    public void contextHandlerFailAfterTest() throws IOException, ComponentInitializationException {
        HTTPResource existsHTTPResource = new HTTPResource(this.client, this.existsURL);
        existsHTTPResource.setHttpClientContextHandler(new HttpClientContextHandler(){

            public void invokeBefore(HttpClientContext context, HttpUriRequest request) throws IOException {
            }

            public void invokeAfter(HttpClientContext context, HttpUriRequest request) throws IOException {
                throw new IOException("Fail");
            }
        });
        ConditionalResource existsResource = new ConditionalResource((Resource)existsHTTPResource);
        existsResource.setId("test");
        existsResource.initialize();
        Assert.assertTrue((boolean)existsResource.exists());
    }

    @Test
    public void testCompare() throws IOException, ComponentInitializationException {
        HTTPResource existsHTTPResource = new HTTPResource(this.client, this.existsURL);
        ConditionalResource existsResource = new ConditionalResource((Resource)existsHTTPResource);
        existsResource.setId("test");
        existsResource.initialize();
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)existsResource, (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
    }

    @Test
    public void testBeanExists() {
        ClassPathResource existsCPResource = new ClassPathResource("net/shibboleth/ext/spring/resource/conditional.xml");
        ConditionalResource existsResource = new ConditionalResource((Resource)existsCPResource);
        GenericApplicationContext parentContext = new GenericApplicationContext();
        parentContext.refresh();
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)parentContext);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions((Resource)existsResource);
        context.refresh();
        Assert.assertEquals((Object)context.getBean("testBean"), (Object)"foo");
    }

    @Test
    public void testBeanMissing() {
        ClassPathResource missingCPResource = new ClassPathResource("net/shibboleth/ext/spring/resource/missing.xml");
        ConditionalResource missingResource = new ConditionalResource((Resource)missingCPResource);
        GenericApplicationContext parentContext = new GenericApplicationContext();
        parentContext.refresh();
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)parentContext);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions((Resource)missingResource);
        context.refresh();
        Assert.assertFalse((boolean)context.containsBean("testBean"));
    }

    @Test
    public void testImport() {
        ClassPathResource resource = new ClassPathResource("net/shibboleth/ext/spring/resource/conditional-import.xml");
        GenericApplicationContext parentContext = new GenericApplicationContext();
        parentContext.refresh();
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)parentContext);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        context.addProtocolResolver((ProtocolResolver)new ConditionalResourceResolver());
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions((Resource)resource);
        context.refresh();
        Assert.assertEquals((Object)context.getBean("testBean"), (Object)"foo");
    }
}

