/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resource.Resource;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.NestedIOException;

public class HTTPResource
extends AbstractIdentifiedInitializableComponent
implements org.springframework.core.io.Resource,
BeanNameAware,
InitializingBean,
Resource {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPResource.class);
    @Nonnull
    private final HttpClient httpClient;
    @Nonnull
    private final URL resourceURL;
    @Nullable
    private HttpClientContextHandler httpClientContextHandler;

    public HTTPResource(@Nonnull @ParameterName(name="client") HttpClient client, @Nonnull @ParameterName(name="url") @NotEmpty String url) throws IOException {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
        String trimmedAddress = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)url), (String)"Provided URL cannot be null or empty");
        this.resourceURL = new URL(trimmedAddress);
    }

    public HTTPResource(@Nonnull @ParameterName(name="") HttpClient client, @Nonnull @ParameterName(name="url") URL url) throws IOException {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
        this.resourceURL = (URL)Constraint.isNotNull((Object)url, (String)"Provided URL cannot be null or empty");
    }

    public void setHttpClientContextHandler(@Nonnull HttpClientContextHandler handler) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpClientContextHandler = handler;
    }

    protected HttpCacheContext buildHttpClientContext() {
        return HttpCacheContext.create();
    }

    protected void reportCachingStatus(HttpCacheContext context) {
        CacheResponseStatus responseStatus = context.getCacheResponseStatus();
        if (null == responseStatus) {
            this.log.debug("Non caching client provided");
            return;
        }
        switch (responseStatus) {
            case CACHE_HIT: {
                this.log.debug("A response was generated from the cache with no requests sent upstream");
                break;
            }
            case CACHE_MODULE_RESPONSE: {
                this.log.debug("The response was generated directly by the caching module");
                break;
            }
            case CACHE_MISS: {
                this.log.debug("The response came from an upstream server");
                break;
            }
            case VALIDATED: {
                this.log.debug("The response was generated from the cache after validating the entry with the origin server");
                break;
            }
            default: {
                this.log.info("Unknown status {}", (Object)responseStatus.toString());
            }
        }
    }

    public InputStream getInputStream() throws IOException {
        HttpGet httpGet = new HttpGet(this.resourceURL.toExternalForm());
        HttpCacheContext context = this.buildHttpClientContext();
        if (this.httpClientContextHandler != null) {
            this.log.debug("Invoking HttpClientContextHandler prior to execution");
            this.httpClientContextHandler.invokeBefore((HttpClientContext)context, (HttpUriRequest)httpGet);
        }
        this.log.debug("Attempting to get data from remote resource '{}'", (Object)this.resourceURL);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet, (HttpContext)context);
        if (this.httpClientContextHandler != null) {
            this.log.debug("Invoking HttpClientContextHandler after execution");
            this.httpClientContextHandler.invokeAfter((HttpClientContext)context, (HttpUriRequest)httpGet);
        }
        this.reportCachingStatus(context);
        int httpStatusCode = response.getStatusLine().getStatusCode();
        if (httpStatusCode != 200) {
            String errMsg = "Non-ok status code " + httpStatusCode + " returned from remote resource " + this.resourceURL;
            this.log.error(errMsg);
            this.closeResponse(response);
            throw new IOException(errMsg);
        }
        return new ConnectionClosingInputStream(response);
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    public void setBeanName(String name) {
        this.setId(name);
    }

    public boolean exists() {
        HttpResponse response;
        this.log.debug("Attempting to fetch remote resource as '{}'", (Object)this.resourceURL);
        try {
            response = this.getResourceHeaders();
        }
        catch (IOException e) {
            return false;
        }
        int httpStatusCode = response.getStatusLine().getStatusCode();
        return httpStatusCode == 200;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isOpen() {
        return false;
    }

    public URL getURL() throws IOException {
        return this.resourceURL;
    }

    public URI getURI() throws IOException {
        try {
            return this.resourceURL.toURI();
        }
        catch (URISyntaxException ex) {
            throw new NestedIOException("Invalid URI [" + this.resourceURL + "]", (Throwable)ex);
        }
    }

    public File getFile() throws IOException {
        throw new FileNotFoundException("HTTPResource cannot be resolved to absolute file path because it does not reside in the file system: " + this.resourceURL);
    }

    protected HttpResponse getResourceHeaders() throws IOException {
        HttpGet httpRequest = new HttpGet(this.resourceURL.toExternalForm());
        HttpResponse httpResponse = null;
        try {
            HttpCacheContext context = this.buildHttpClientContext();
            if (this.httpClientContextHandler != null) {
                this.log.debug("Invoking HttpClientContextHandler prior to execution");
                this.httpClientContextHandler.invokeBefore((HttpClientContext)context, (HttpUriRequest)httpRequest);
            }
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)context);
            if (this.httpClientContextHandler != null) {
                this.log.debug("Invoking HttpClientContextHandler after execution");
                this.httpClientContextHandler.invokeAfter((HttpClientContext)context, (HttpUriRequest)httpRequest);
            }
            this.reportCachingStatus(context);
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            HttpResponse httpResponse2 = httpResponse;
            this.closeResponse(httpResponse);
            return httpResponse2;
        }
        catch (IOException e) {
            try {
                throw new IOException("Error contacting remote resource " + this.resourceURL.toString(), e);
            }
            catch (Throwable throwable) {
                this.closeResponse(httpResponse);
                throw throwable;
            }
        }
    }

    @Nullable
    protected String getResponseHeader(String what) throws IOException {
        this.log.debug("Attempting to fetch remote resource as '{}'", (Object)this.resourceURL);
        HttpResponse response = this.getResourceHeaders();
        int httpStatusCode = response.getStatusLine().getStatusCode();
        if (httpStatusCode != 200) {
            String errMsg = "Non-ok status code " + httpStatusCode + " returned from remote resource " + this.resourceURL;
            this.log.error(errMsg);
            throw new IOException(errMsg);
        }
        Header httpHeader = response.getFirstHeader(what);
        if (httpHeader != null) {
            return httpHeader.getValue();
        }
        return null;
    }

    public long contentLength() throws IOException {
        String response = this.getResponseHeader("Content-Length");
        if (null != response) {
            return Long.parseLong(response);
        }
        String errMsg = "Response from remote resource " + this.resourceURL.toString() + " did not contain a Content-Length header";
        this.log.error(errMsg);
        throw new IOException(errMsg);
    }

    public long lastModified() throws IOException {
        String response = this.getResponseHeader("Last-Modified");
        if (null != response) {
            return DateUtils.parseDate((String)response).getTime();
        }
        String errMsg = "Response from remote resource " + this.resourceURL.toString() + " did not contain a Last-Modified header";
        this.log.error(errMsg);
        throw new IOException(errMsg);
    }

    public HTTPResource createRelative(String relativePath) throws IOException {
        String path = relativePath.startsWith("/") ? relativePath.substring(1) : relativePath;
        return new HTTPResource(this.httpClient, new URL(this.resourceURL, path));
    }

    public Resource createRelativeResource(String relativePath) throws IOException {
        return this.createRelative(relativePath);
    }

    public String getFilename() {
        return new File(this.resourceURL.getFile()).getName();
    }

    public String getDescription() {
        StringBuilder builder = new StringBuilder("HTTPResource [").append(this.resourceURL.toString()).append(']');
        return builder.toString();
    }

    protected void closeResponse(@Nullable HttpResponse response) {
        try {
            if (response != null && response instanceof CloseableHttpResponse) {
                ((CloseableHttpResponse)response).close();
            }
        }
        catch (IOException e) {
            this.log.error("Error closing HTTP response from '{}'", (Object)this.resourceURL.toExternalForm(), (Object)e);
        }
    }

    private static class ConnectionClosingInputStream
    extends InputStream {
        private final HttpResponse response;
        private final InputStream stream;

        public ConnectionClosingInputStream(@Nonnull HttpResponse httpResponse) throws IOException {
            this.response = httpResponse;
            this.stream = this.response.getEntity().getContent();
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            if (this.response instanceof CloseableHttpResponse) {
                ((CloseableHttpResponse)this.response).close();
            }
        }

        @Override
        public void mark(int readLimit) {
            this.stream.mark(readLimit);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.stream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }
    }
}

