/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.ext.spring.factory;

import java.util.ArrayList;
import java.util.List;
import net.shibboleth.ext.spring.factory.HttpClientFactoryBean;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.httpclient.FileCachingHttpClientBuilder;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import org.apache.http.client.HttpClient;

public class FileCachingHttpClientFactoryBean
extends HttpClientFactoryBean {
    private List<HttpClient> clientRefs = new ArrayList<HttpClient>();

    public void setCacheDirectory(String cacheDirectory) {
        ((FileCachingHttpClientBuilder)this.getHttpClientBuilder()).setCacheDirectory(cacheDirectory);
    }

    public void setMaxCacheEntries(int maxCacheEntries) {
        ((FileCachingHttpClientBuilder)this.getHttpClientBuilder()).setMaxCacheEntries(maxCacheEntries);
    }

    public void setMaxCacheEntrySize(long maxCacheEntrySize) {
        ((FileCachingHttpClientBuilder)this.getHttpClientBuilder()).setMaxCacheEntrySize(maxCacheEntrySize);
    }

    @Override
    protected HttpClientBuilder createHttpClientBuilder() {
        return new FileCachingHttpClientBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HttpClient doCreateInstance() throws Exception {
        HttpClient client = super.doCreateInstance();
        FileCachingHttpClientFactoryBean fileCachingHttpClientFactoryBean = this;
        synchronized (fileCachingHttpClientFactoryBean) {
            InitializableComponent component;
            if (client instanceof InitializableComponent && !(component = (InitializableComponent)client).isInitialized()) {
                component.initialize();
            }
            this.clientRefs.add(client);
        }
        return client;
    }
}

