/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.supercsv.encoder.CsvEncoder;
import org.supercsv.io.ICsvWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.CsvContext;
import org.supercsv.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCsvWriter
implements ICsvWriter {
    private final Writer writer;
    private final CsvPreference preference;
    private final CsvEncoder encoder;
    private int lineNumber = 0;
    private int rowNumber = 0;
    private int columnNumber = 0;

    public AbstractCsvWriter(Writer writer, CsvPreference preference) {
        this(writer, preference, true);
    }

    public AbstractCsvWriter(Writer writer, CsvPreference preference, boolean bufferizeWriter) {
        if (writer == null) {
            throw new NullPointerException("writer should not be null");
        }
        if (preference == null) {
            throw new NullPointerException("preference should not be null");
        }
        this.writer = bufferizeWriter ? new BufferedWriter(writer) : writer;
        this.preference = preference;
        this.encoder = preference.getEncoder();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    protected void incrementRowAndLineNo() {
        ++this.lineNumber;
        ++this.rowNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getRowNumber() {
        return this.rowNumber;
    }

    protected void writeRow(List<?> columns) throws IOException {
        this.writeRow(Util.objectListToStringArray(columns));
    }

    protected void writeRow(Object ... columns) throws IOException {
        this.writeRow(Util.objectArrayToStringArray(columns));
    }

    protected void writeRow(String ... columns) throws IOException {
        if (columns == null) {
            throw new NullPointerException(String.format("columns to write should not be null on line %d", this.lineNumber));
        }
        if (columns.length == 0) {
            throw new IllegalArgumentException(String.format("columns to write should not be empty on line %d", this.lineNumber));
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < columns.length; ++i) {
            String csvElement;
            this.columnNumber = i + 1;
            if (i > 0) {
                builder.append((char)this.preference.getDelimiterChar());
            }
            if ((csvElement = columns[i]) == null) continue;
            CsvContext context = new CsvContext(this.lineNumber, this.rowNumber, this.columnNumber);
            String escapedCsv = this.encoder.encode(csvElement, context, this.preference);
            builder.append(escapedCsv);
            this.lineNumber = context.getLineNumber();
        }
        builder.append(this.preference.getEndOfLineSymbols());
        this.writer.write(builder.toString());
    }

    @Override
    public void writeComment(String comment) throws IOException {
        ++this.lineNumber;
        if (comment == null) {
            throw new NullPointerException(String.format("comment to write should not be null on line %d", this.lineNumber));
        }
        this.writer.write(comment + this.preference.getEndOfLineSymbols());
    }

    @Override
    public void writeHeader(String ... header) throws IOException {
        this.incrementRowAndLineNo();
        this.writeRow(header);
    }
}

