/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.writer;

import java.io.IOException;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.lib.search.lucene.analysis.NgramAnalyzer;
import net.sf.okapi.tm.pensieve.common.Metadata;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitField;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.similarities.BooleanSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PensieveWriter
implements ITmWriter {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private IndexWriter indexWriter;

    public PensieveWriter(Directory indexDirectory, boolean createNewTmIndex) throws IOException {
        IndexWriterConfig conf = new IndexWriterConfig((Analyzer)new NgramAnalyzer(4));
        conf.setOpenMode(createNewTmIndex ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND);
        conf.setSimilarity((Similarity)new BooleanSimilarity());
        this.indexWriter = new IndexWriter(indexDirectory, conf);
        this.indexWriter.commit();
    }

    @Override
    public void close() {
        try {
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        catch (AlreadyClosedException e) {
        }
        finally {
            try {
                this.indexWriter.close();
            }
            catch (IOException ignored) {
                this.LOGGER.warn("Exception closing Pensieve IndexWriter.", (Throwable)ignored);
            }
        }
    }

    @Override
    public void commit() {
        try {
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    @Override
    public void indexTranslationUnit(TranslationUnit tu) {
        if (tu == null) {
            throw new NullPointerException("TextUnit can not be null");
        }
        Document doc = this.createDocument(tu);
        if (doc != null) {
            try {
                this.indexWriter.addDocument((Iterable)doc);
            }
            catch (CorruptIndexException e) {
                throw new OkapiIOException("Error adding a translationUnit to the TM. Corrupted index.", e);
            }
            catch (IOException e) {
                throw new OkapiIOException("Error adding a translationUnit to the TM.", e);
            }
        }
    }

    @Override
    public void indexTranslationUnit(TranslationUnit tu, boolean overwrite) {
        if (tu == null) {
            throw new NullPointerException("TextUnit can not be null.");
        }
        try {
            if (overwrite) {
                TextFragment srcFrag = tu.getSource().getContent();
                if (srcFrag.hasCode()) {
                    BooleanQuery.Builder bqb = new BooleanQuery.Builder();
                    bqb = bqb.add((Query)new TermQuery(new Term(TranslationUnitField.SOURCE_EXACT.name(), srcFrag.getCodedText())), BooleanClause.Occur.MUST);
                    bqb = bqb.add((Query)new TermQuery(new Term(TranslationUnitField.SOURCE_CODES.name(), Code.codesToString(srcFrag.getCodes(), true))), BooleanClause.Occur.MUST);
                    this.indexWriter.deleteDocuments(new Query[]{bqb.build()});
                } else {
                    this.indexWriter.deleteDocuments(new Term[]{new Term(TranslationUnitField.SOURCE_EXACT.name(), srcFrag.getCodedText())});
                }
            }
        }
        catch (CorruptIndexException e) {
            throw new OkapiIOException("Error deleting a translationUnit from the TM. Corrupted index.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error deleting a translationUnit from the TM.", e);
        }
        this.indexTranslationUnit(tu);
    }

    @Override
    public void delete(String id) {
        if (Util.isEmpty(id)) {
            throw new IllegalArgumentException("id is a required field for delete to happen");
        }
        try {
            this.indexWriter.deleteDocuments(new Term[]{new Term(MetadataType.ID.fieldName(), id)});
        }
        catch (CorruptIndexException e) {
            throw new OkapiIOException("Error deleting a translationUnit from the TM. Corrupted index.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error deleting a translationUnit from the TM.", e);
        }
    }

    @Override
    public void update(TranslationUnit tu) {
        if (tu == null || tu.getMetadata().get((Object)MetadataType.ID) == null) {
            throw new IllegalArgumentException("tu must be set and at least have its ID set");
        }
        this.delete((String)tu.getMetadata().get((Object)MetadataType.ID));
        this.indexTranslationUnit(tu);
    }

    Field createStoredNotAnalyzedField(TranslationUnitField field, String val) {
        return new Field(field.name(), (CharSequence)val, (IndexableFieldType)StringField.TYPE_STORED);
    }

    void addMetadataToDocument(Document doc, Metadata metadata) {
        for (MetadataType type : metadata.keySet()) {
            doc.add((IndexableField)new Field(type.fieldName(), (CharSequence)metadata.get((Object)type), (IndexableFieldType)StringField.TYPE_STORED));
        }
    }

    Document createDocument(TranslationUnit tu) {
        if (tu == null) {
            throw new NullPointerException("source content not set");
        }
        if (tu.isSourceEmpty()) {
            return null;
        }
        Document doc = new Document();
        doc.add((IndexableField)this.createStoredNotAnalyzedField(TranslationUnitField.SOURCE_LANG, tu.getSource().getLanguage().toString()));
        doc.add((IndexableField)this.createRawCodedTextField(TranslationUnitField.SOURCE_EXACT, tu.getSource().getContent(), true));
        doc.add((IndexableField)this.createSourceField(TranslationUnitField.SOURCE, tu.getSource().getContent().getText()));
        doc.add((IndexableField)this.createCodesField(TranslationUnitField.SOURCE_CODES, tu.getSource().getContent(), true));
        if (!tu.isTargetEmpty()) {
            doc.add((IndexableField)this.createStoredNotAnalyzedField(TranslationUnitField.TARGET_LANG, tu.getTarget().getLanguage().toString()));
            doc.add((IndexableField)this.createRawCodedTextField(TranslationUnitField.TARGET, tu.getTarget().getContent(), false));
            doc.add((IndexableField)this.createCodesField(TranslationUnitField.TARGET_CODES, tu.getTarget().getContent(), false));
        }
        this.addMetadataToDocument(doc, tu.getMetadata());
        return doc;
    }

    private Field createNotStoredAnalyzedWithTermVectorField(TranslationUnitField tuField, String val) {
        FieldType type = new FieldType();
        type.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        type.setStored(true);
        type.setStoreTermVectors(true);
        return new Field(tuField.name(), (CharSequence)val, (IndexableFieldType)type);
    }

    private Field createSourceField(TranslationUnitField tuField, String val) {
        FieldType ft = new FieldType((IndexableFieldType)TextField.TYPE_NOT_STORED);
        ft.setStoreTermVectors(true);
        return new Field(tuField.name(), (CharSequence)val, (IndexableFieldType)ft);
    }

    private Field createRawCodedTextField(TranslationUnitField tuField, TextFragment frag, boolean indexed) {
        return new StringField(tuField.name(), frag.getCodedText(), Field.Store.YES);
    }

    private Field createCodesField(TranslationUnitField tuField, TextFragment frag, boolean indexed) {
        return new StringField(tuField.name(), Code.codesToString(frag.getCodes(), true), Field.Store.YES);
    }
}

