/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tmimport;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.filters.pensieve.PensieveFilterWriter;
import net.sf.okapi.steps.tmimport.Parameters;

@UsingParameters(value=Parameters.class)
public class TMImportStep
extends BasePipelineStep {
    private Parameters params = new Parameters();
    private IFilterWriter writer;
    private LocaleId targetLocale;
    private String rootDir;

    @Override
    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.ROOT_DIRECTORY)
    public void setRootDirectory(String rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    public String getDescription() {
        return "Import text into a new or existing Pensieve TM. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "TM Import";
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                break;
            }
            case END_BATCH: {
                if (this.writer == null) break;
                this.writer.close();
                this.writer = null;
                break;
            }
            case START_DOCUMENT: {
                if (this.writer != null) break;
                this.writer = new PensieveFilterWriter();
                this.writer.setOutput(Util.fillRootDirectoryVariable(this.params.getTmDirectory(), this.rootDir));
                this.writer.setOptions(this.targetLocale, "UTF-8");
                ((PensieveFilterWriter)this.writer).setOverwriteSameSource(this.params.getOverwriteSameSource());
                this.writer.handleEvent(event);
                break;
            }
            case END_DOCUMENT: {
                break;
            }
            case START_SUBDOCUMENT: 
            case END_SUBDOCUMENT: 
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: {
                this.writer.handleEvent(event);
                break;
            }
            case TEXT_UNIT: {
                this.writer.handleEvent(event);
                break;
            }
        }
        return event;
    }
}

