/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.paraaligner;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String OUTPUT_ONE_TO_ONE_MATCHES_ONLY = "outputOneToOneMatchesOnly";
    private static final String USE_SKELETON_ALIGNMENT = "useSkeletonAlignment";

    public boolean isOutputOneToOneMatchesOnly() {
        return this.getBoolean(OUTPUT_ONE_TO_ONE_MATCHES_ONLY);
    }

    public void setOutputOneToOneMatchesOnly(boolean outputOneToOneMatchesOnly) {
        this.setBoolean(OUTPUT_ONE_TO_ONE_MATCHES_ONLY, outputOneToOneMatchesOnly);
    }

    public boolean isUseSkeletonAlignment() {
        return this.getBoolean(USE_SKELETON_ALIGNMENT);
    }

    public void setUseSkeletonAlignment(boolean useSkeletonAlignment) {
        this.setBoolean(USE_SKELETON_ALIGNMENT, useSkeletonAlignment);
    }

    @Override
    public void reset() {
        super.reset();
        this.setOutputOneToOneMatchesOnly(true);
        this.setUseSkeletonAlignment(false);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(OUTPUT_ONE_TO_ONE_MATCHES_ONLY, "Output 1-1 Matches Only?", "Ouput only 1-1 aligned paragraphs?");
        desc.add(USE_SKELETON_ALIGNMENT, "Use Skeleton Alignment? (Experimental)", "Use Skeleton alignment? (Experimental)");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Paragraph Aligner", true, false);
        desc.addCheckboxPart(paramsDesc.get(OUTPUT_ONE_TO_ONE_MATCHES_ONLY));
        desc.addCheckboxPart(paramsDesc.get(USE_SKELETON_ALIGNMENT));
        return desc;
    }
}

