/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization.textunitflat;

import java.util.HashMap;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.Note;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.WhitespaceStrategy;
import net.sf.okapi.proto.textunitflat.AltTranslation;
import net.sf.okapi.proto.textunitflat.Code;
import net.sf.okapi.proto.textunitflat.Note;
import net.sf.okapi.proto.textunitflat.Property;
import net.sf.okapi.proto.textunitflat.TextContainer;
import net.sf.okapi.proto.textunitflat.TextFragment;
import net.sf.okapi.proto.textunitflat.TextPart;
import net.sf.okapi.proto.textunitflat.TextUnit;
import net.sf.okapi.proto.textunitflat.TextUnits;

public class TextUnitFlat2Proto {
    static TextFragment.TagType toTagType(TextFragment.TagType tt) {
        switch (tt) {
            case CLOSING: {
                return TextFragment.TagType.CLOSING;
            }
            case OPENING: {
                return TextFragment.TagType.OPENING;
            }
            case PLACEHOLDER: {
                return TextFragment.TagType.PLACEHOLDER;
            }
        }
        return TextFragment.TagType.UNRECOGNIZED;
    }

    static net.sf.okapi.proto.textunitflat.Code toCode(Code code, int position, boolean isolated) {
        Code.Builder builder = net.sf.okapi.proto.textunitflat.Code.newBuilder().setTagType(TextUnitFlat2Proto.toTagType(code.getTagType())).setId(code.getId()).setCodeType(code.getType()).setData(code.getData()).setOuterData(code.getOuterData()).setFlag(code.getFlag()).setPosition(position).setIsolated(isolated).setAdded(code.isAdded());
        if (null != code.getDisplayText()) {
            builder.setDisplayText(code.getDisplayText());
        }
        if (null != code.getOriginalId()) {
            builder.setOriginalId(code.getOriginalId());
        }
        if (null != code.getMergedData() && !code.getMergedData().isEmpty()) {
            builder.setMergedData(code.getMergedData());
        }
        for (String propName : code.getPropertyNames()) {
            builder.addProperties(TextUnitFlat2Proto.toProperty(code.getProperty(propName)));
        }
        return builder.build();
    }

    static TextFragment toTextFragment(net.sf.okapi.common.resource.TextFragment tf) {
        TextFragment.Builder builder = TextFragment.newBuilder().setText(tf.getText());
        if (tf.hasCode()) {
            tf.balanceMarkers();
            List<Code> codes = tf.getCodes();
            int codeCount = 0;
            block3: for (int i = 0; i < tf.length(); ++i) {
                switch (tf.charAt(i)) {
                    case '\ue101': 
                    case '\ue102': 
                    case '\ue103': {
                        Code code = codes.get(net.sf.okapi.common.resource.TextFragment.toIndex(tf.charAt(++i)));
                        int newPos = i - codeCount * 2;
                        builder.addCodes(TextUnitFlat2Proto.toCode(code, newPos - 1, tf.charAt(i - 1) == '\ue103'));
                        ++codeCount;
                        continue block3;
                    }
                }
            }
        }
        return builder.build();
    }

    static Property toProperty(net.sf.okapi.common.resource.Property prop) {
        Property.Builder builder = Property.newBuilder().setName(prop.getName()).setValue(prop.getValue() == null ? "" : prop.getValue()).setReadOnly(prop.isReadOnly());
        return builder.build();
    }

    static net.sf.okapi.proto.textunitflat.TextContainer toTextContainer(TextContainer tc, LocaleId locale) {
        AltTranslationsAnnotation altTranslationsAnnotation;
        TextContainer.Builder builder = net.sf.okapi.proto.textunitflat.TextContainer.newBuilder().setSegApplied(tc.hasBeenSegmented()).setLocale(locale == null ? "und" : locale.toBCP47());
        if (tc.getId() != null) {
            builder.setId(tc.getId());
        }
        for (TextPart textPart : tc.getParts()) {
            builder.addParts(TextUnitFlat2Proto.toTextPart(textPart));
        }
        for (String string : tc.getPropertyNames()) {
            builder.addProperties(TextUnitFlat2Proto.toProperty(tc.getProperty(string)));
        }
        NoteAnnotation na = tc.getAnnotation(NoteAnnotation.class);
        if (na != null) {
            for (net.sf.okapi.common.annotation.Note note : na) {
                builder.addNotes(TextUnitFlat2Proto.toNote(note));
            }
        }
        if ((altTranslationsAnnotation = tc.getAnnotation(AltTranslationsAnnotation.class)) != null) {
            for (AltTranslation altTranslation : altTranslationsAnnotation) {
                builder.addAltTrans(TextUnitFlat2Proto.toAltTrans(altTranslation));
            }
        }
        return builder.build();
    }

    private static net.sf.okapi.proto.textunitflat.TextPart toTextPart(TextPart part) {
        TextPart.Builder builder = net.sf.okapi.proto.textunitflat.TextPart.newBuilder().setSegment(part.isSegment()).setWhitespaceStrategy(TextUnitFlat2Proto.toWhitespaceStrategy(part.getWhitespaceStrategy())).setText(TextUnitFlat2Proto.toTextFragment(part.getContent()));
        if (part.getOriginalId() != null) {
            builder.setOriginalId(part.getOriginalId());
        }
        if (part.getId() != null) {
            builder.setId(part.getId());
        }
        for (String propName : part.getPropertyNames()) {
            builder.addProperties(TextUnitFlat2Proto.toProperty(part.getProperty(propName)));
        }
        return builder.build();
    }

    private static TextPart.WhitespaceStrategy toWhitespaceStrategy(WhitespaceStrategy whitespaceStrategy) {
        switch (whitespaceStrategy) {
            case INHERIT: {
                return TextPart.WhitespaceStrategy.INHERIT;
            }
            case NORMALIZE: {
                return TextPart.WhitespaceStrategy.NORMALIZE;
            }
            case PRESERVE: {
                return TextPart.WhitespaceStrategy.PRESERVE;
            }
        }
        return TextPart.WhitespaceStrategy.INHERIT;
    }

    public static Note toNote(net.sf.okapi.common.annotation.Note note) {
        Note.Builder builder = Note.newBuilder().setNote(note.getNoteText()).setAnnotates(TextUnitFlat2Proto.toAnnotates(note.getAnnotates() == null ? Note.Annotates.GENERAL : note.getAnnotates())).setPriority(TextUnitFlat2Proto.toPriority(note.getPriority() == null ? Note.Priority.ONE : note.getPriority())).setFrom(note.getFrom() == null ? "" : note.getFrom()).setXmlLang(note.getXmLang() == null ? "" : note.getXmLang());
        return builder.build();
    }

    public static AltTranslation.MatchType toMatchType(MatchType matchType) {
        switch (matchType) {
            case ACCEPTED: {
                return AltTranslation.MatchType.ACCEPTED;
            }
            case EXACT_UNIQUE_ID: {
                return AltTranslation.MatchType.EXACT_UNIQUE_ID;
            }
            case EXACT_LOCAL_CONTEXT: {
                return AltTranslation.MatchType.EXACT_LOCAL_CONTEXT;
            }
            case EXACT: {
                return AltTranslation.MatchType.EXACT;
            }
            case EXACT_TEXT_ONLY: {
                return AltTranslation.MatchType.EXACT_TEXT_ONLY;
            }
            case FUZZY: {
                return AltTranslation.MatchType.FUZZY;
            }
        }
        return AltTranslation.MatchType.UKNOWN;
    }

    public static net.sf.okapi.proto.textunitflat.AltTranslation toAltTrans(AltTranslation altTrans) {
        AltTranslation.Builder builder = net.sf.okapi.proto.textunitflat.AltTranslation.newBuilder().setTextUnit(TextUnitFlat2Proto.toTextUnit(altTrans.getTextUnit(), altTrans.getSourceLocale())).setSourceLocale(altTrans.getSourceLocale().toBCP47()).setTargetLocale(altTrans.getTargetLocale().toBCP47()).setType(TextUnitFlat2Proto.toMatchType(altTrans.getType())).setCombinedScore(altTrans.getCombinedScore()).setOrigin(altTrans.getOrigin());
        if (altTrans.getEngine() != null) {
            builder.setEngine(altTrans.getEngine());
        }
        builder.setFromOriginal(altTrans.getFromOriginal());
        builder.setFuzzyScore(altTrans.getFuzzyScore());
        builder.setQualityScore(altTrans.getQualityScore());
        builder.setAltTransType(altTrans.getALttransType());
        return builder.build();
    }

    public static Note.Annotates toAnnotates(Note.Annotates annotates) {
        switch (annotates) {
            case SOURCE: {
                return Note.Annotates.SOURCE;
            }
            case TARGET: {
                return Note.Annotates.TARGET;
            }
        }
        return Note.Annotates.GENERAL;
    }

    public static Note.Priority toPriority(Note.Priority priority) {
        switch (priority) {
            case ONE: {
                return Note.Priority.ONE;
            }
            case TWO: {
                return Note.Priority.TWO;
            }
            case THREE: {
                return Note.Priority.THREE;
            }
            case FOUR: {
                return Note.Priority.FOUR;
            }
            case FIVE: {
                return Note.Priority.FIVE;
            }
            case SIX: {
                return Note.Priority.SIX;
            }
            case SEVEN: {
                return Note.Priority.SEVEN;
            }
            case EIGHT: {
                return Note.Priority.EIGHT;
            }
            case NINE: {
                return Note.Priority.NINE;
            }
        }
        return Note.Priority.TEN;
    }

    public static TextUnit toTextUnit(ITextUnit tu, LocaleId sourceLocale) {
        TextUnit.Builder builder = TextUnit.newBuilder().setSource(TextUnitFlat2Proto.toTextContainer(tu.getSource(), sourceLocale)).setId(tu.getId()).setPreserveWS(tu.preserveWhitespaces()).setTranslatable(tu.isTranslatable());
        if (null != tu.getMimeType()) {
            builder.setMimeType(tu.getMimeType());
        }
        if (null != tu.getName()) {
            builder.setName(tu.getName());
        }
        if (null != tu.getType()) {
            builder.setTuType(tu.getType());
        }
        HashMap<String, net.sf.okapi.proto.textunitflat.TextContainer> targets = new HashMap<String, net.sf.okapi.proto.textunitflat.TextContainer>();
        for (LocaleId locale : tu.getTargetLocales()) {
            targets.put(locale.toBCP47(), TextUnitFlat2Proto.toTextContainer(tu.getTarget(locale), locale));
        }
        builder.putAllTargets(targets);
        for (String propName : tu.getPropertyNames()) {
            builder.addProperties(TextUnitFlat2Proto.toProperty(tu.getProperty(propName)));
        }
        NoteAnnotation na = tu.getAnnotation(NoteAnnotation.class);
        if (na != null) {
            for (net.sf.okapi.common.annotation.Note note : na) {
                builder.addNotes(TextUnitFlat2Proto.toNote(note));
            }
        }
        return builder.build();
    }

    public static TextUnits toTextUnits(List<ITextUnit> textunits, LocaleId sourceLocale) {
        TextUnits.Builder builder = TextUnits.newBuilder();
        for (ITextUnit tu : textunits) {
            builder.addTextUnits(TextUnitFlat2Proto.toTextUnit(tu, sourceLocale));
        }
        return builder.build();
    }
}

