/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.txml;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.txml.Parameters;
import net.sf.okapi.filters.txml.TXMLSegAnnotation;
import net.sf.okapi.filters.txml.TXMLSkeletonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class TXMLFilter
implements IFilter {
    private static final String TARGETLOCALE = "targetlocale";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private boolean hasNext;
    private XMLStreamReader reader;
    private RawDocument input;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private LinkedList<Event> queue;
    private boolean canceled;
    private GenericSkeleton skel;
    private String lineBreak;
    private ITextUnit tu;
    private IdGenerator otherId;
    private StringBuilder buffer;
    private TXMLSkeletonWriter skelWriter;
    private EncoderManager encoderManager;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        try {
            this.hasNext = false;
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_txml";
    }

    @Override
    public String getDisplayName() {
        return "TXML Filter";
    }

    @Override
    public String getMimeType() {
        return "text/xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "text/xml", this.getClass().getName(), "TXML", "Wordfast Pro TXML documents", null, ".txml;"));
        list.add(new FilterConfiguration(this.getName() + "-fillEmptyTargets", "text/xml", this.getClass().getName(), "TXML (Fill empty targets in output)", "Wordfast Pro TXML documents with empty targets filled on output.", "fillEmptyTargets.fprm", ".txml;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
                this.hasNext = false;
            }
            if (this.queue.isEmpty()) {
                this.read();
            }
            if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
                this.hasNext = false;
            }
            return this.queue.poll();
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        try {
            this.canceled = false;
            this.input = input;
            XMLInputFactory fact = XMLInputFactory.newInstance();
            fact.setProperty("javax.xml.stream.isCoalescing", true);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            input.setEncoding("UTF-8");
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
            detector.detectBom();
            this.reader = input.getInputCharSequence() != null ? fact.createXMLStreamReader(input.getStream(), input.getEncoding()) : (detector.isAutodetected() ? fact.createXMLStreamReader(input.getStream(), detector.getEncoding()) : fact.createXMLStreamReader(input.getStream()));
            String realEnc = this.reader.getCharacterEncodingScheme();
            String encoding = input.getEncoding();
            if (realEnc != null) {
                encoding = realEnc;
            }
            this.srcLoc = input.getSourceLocale();
            if (this.srcLoc == null) {
                throw new NullPointerException("Source language not set.");
            }
            this.trgLoc = input.getTargetLocale();
            if (this.trgLoc == null) {
                throw new NullPointerException("Target language not set.");
            }
            this.otherId = new IdGenerator(null, "o");
            this.hasNext = true;
            this.queue = new LinkedList();
            this.buffer = new StringBuilder();
            StartDocument startDoc = new StartDocument(this.otherId.createId());
            startDoc.setEncoding(encoding, detector.hasUtf8Bom());
            this.lineBreak = detector.getNewlineType().toString();
            if (input.getInputURI() != null) {
                startDoc.setName(input.getInputURI().getPath());
            }
            startDoc.setLocale(this.srcLoc);
            startDoc.setFilterId(this.getName());
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setType("text/xml");
            startDoc.setMimeType("text/xml");
            startDoc.setMultilingual(true);
            startDoc.setLineBreak(this.lineBreak);
            this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
            this.skel = new GenericSkeleton();
            startDoc.setProperty(new Property("encoding", encoding, false));
            this.skel.append("<?xml version=\"1.0\" encoding=\"");
            this.skel.addValuePlaceholder(startDoc, "encoding", LocaleId.EMPTY);
            this.skel.append("\"?>" + this.lineBreak);
            startDoc.setSkeleton(this.skel);
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        if (this.skelWriter == null) {
            this.skelWriter = new TXMLSkeletonWriter(this.params.getAllowEmptyOutputTarget());
        }
        return this.skelWriter;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    private void read() throws XMLStreamException {
        this.skel = new GenericSkeleton();
        this.buffer.setLength(0);
        while (this.reader.hasNext()) {
            int type = this.reader.next();
            switch (type) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if ("translatable".equals(name)) {
                        this.processTranslatable();
                        return;
                    }
                    if ("txml".equals(name)) {
                        this.processTxml();
                        break;
                    }
                    if ("localizable".equals(name)) {
                        this.buildStartElement(true);
                        this.logger.warn("The <localizable> element is not supported yet: it will not be extracted.");
                        break;
                    }
                    this.buildStartElement(true);
                    break;
                }
                case 2: {
                    this.buildEndElement(true);
                    if (!this.reader.getLocalName().equals("txml")) break;
                    this.createDocumentPartIfNeeded();
                    break;
                }
                case 6: {
                    this.skel.append(this.reader.getText().replace("\n", this.lineBreak));
                    break;
                }
                case 4: 
                case 12: {
                    this.skel.append(Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, true, null));
                    break;
                }
                case 5: {
                    this.skel.append("<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                    break;
                }
                case 3: {
                    this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    Ending ending = new Ending(this.otherId.createId());
                    ending.setSkeleton(this.skel);
                    this.queue.add(new Event(EventType.END_DOCUMENT, ending));
                    return;
                }
            }
        }
    }

    private void processTxml() {
        String tmp = this.reader.getAttributeValue(null, "locale");
        if (!Util.isEmpty(tmp) && !this.srcLoc.equalToString(tmp)) {
            this.logger.warn("Specified source was '{}' but source language in the file is '{}'.\nUsing '{}'.", new Object[]{this.srcLoc.toString(), tmp, tmp});
            this.srcLoc = LocaleId.fromString(tmp);
        }
        if (!Util.isEmpty(tmp = this.reader.getAttributeValue(null, TARGETLOCALE)) && !this.trgLoc.equalToString(tmp)) {
            this.logger.warn("Specified target was '{}' but target language in the file is '{}'.\nUsing '{}'.", new Object[]{this.trgLoc.toString(), tmp, tmp});
            this.trgLoc = LocaleId.fromString(tmp);
        }
        this.buildStartElement(true);
    }

    private void processTranslatable() throws XMLStreamException {
        this.createDocumentPartIfNeeded();
        this.tu = new TextUnit(this.reader.getAttributeValue(null, "blockId"));
        this.buildStartElement(true);
        String segId = null;
        TextPart ws1 = null;
        Segment srcSeg = null;
        Segment trgSeg = null;
        TextPart ws2 = null;
        TextContainer srcCont = this.tu.getSource();
        TextContainer trgCont = this.tu.createTarget(this.trgLoc, true, 0);
        boolean hasOneTarget = false;
        boolean srcDone = false;
        boolean gtmt = false;
        boolean modified = false;
        boolean inRevision = false;
        Object comment = "";
        boolean firstPartIsComment = false;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    TextFragment tf;
                    String name = this.reader.getLocalName();
                    if ("segment".equals(name)) {
                        segId = this.reader.getAttributeValue(null, "segmentId");
                        String tmp = this.reader.getAttributeValue(null, "modified");
                        if (!Util.isEmpty(tmp)) {
                            modified = tmp.equals("true");
                        }
                        if (Util.isEmpty(tmp = this.reader.getAttributeValue(null, "gtmt"))) break;
                        gtmt = tmp.equals("true");
                        break;
                    }
                    if (!inRevision && "source".equals(name)) {
                        tf = this.processContent(name);
                        srcSeg = new Segment(segId, tf);
                        srcDone = true;
                        break;
                    }
                    if (!inRevision && "target".equals(name)) {
                        tf = this.processContent(name);
                        trgSeg = new Segment(segId, tf);
                        break;
                    }
                    if ("ws".equals(name)) {
                        if (srcDone) {
                            ws2 = new TextPart(this.processContent(name));
                            break;
                        }
                        ws1 = new TextPart(this.processContent(name));
                        break;
                    }
                    if (!"revisions".equals(name)) break;
                    inRevision = true;
                    break;
                }
                case 2: {
                    String name = this.reader.getLocalName();
                    if ("segment".equals(name)) {
                        if (ws1 != null) {
                            srcCont.append(ws1, srcCont.count() == 1);
                            if (trgCont != null) {
                                trgCont.append(ws1.clone(), trgCont.count() == 1);
                            }
                        }
                        srcCont.getSegments().append(srcSeg, srcCont.count() == 1);
                        srcSeg.setAnnotation(new TXMLSegAnnotation((ws1 == null ? "" : "b") + (ws2 == null ? "" : "a")));
                        if (trgSeg != null) {
                            trgCont.getSegments().append(trgSeg, trgCont.count() == 1);
                            hasOneTarget = true;
                            if (gtmt && !modified) {
                                TextUnitUtil.addAltTranslation(trgSeg, new AltTranslation(this.srcLoc, this.trgLoc, srcSeg.getContent(), srcSeg.getContent(), trgSeg.getContent(), MatchType.MT, 95, "SourceDoc"));
                            }
                        } else {
                            trgCont.getSegments().append(new TextFragment(), trgCont.count() == 1);
                        }
                        if (ws1 != null && srcCont.count() == 2) {
                            srcCont.changePart(0);
                            if (trgCont != null) {
                                trgCont.changePart(0);
                            }
                        }
                        if (ws2 != null) {
                            srcCont.append(ws2, false);
                            if (trgCont != null) {
                                trgCont.append(ws2.clone(), false);
                            }
                        }
                        ws1 = null;
                        srcSeg = null;
                        trgSeg = null;
                        ws2 = null;
                        srcDone = false;
                        gtmt = false;
                        modified = false;
                        break;
                    }
                    if ("revisions".equals(name)) {
                        inRevision = false;
                        break;
                    }
                    if (!"translatable".equals(name)) break;
                    if (!hasOneTarget) {
                        this.tu.removeTarget(this.trgLoc);
                    }
                    if (firstPartIsComment) {
                        this.skel.append((String)comment);
                        if (this.tu.getSource().count() == 1 && this.tu.getSource().isEmpty()) {
                            this.buildEndElement(true);
                            this.tu = null;
                            this.createDocumentPartIfNeeded();
                        }
                    }
                    if (this.tu != null) {
                        this.skel.addContentPlaceholder(this.tu);
                        this.tu.setSkeleton(this.skel);
                        this.tu.setPreserveWhitespaces(true);
                        this.tu.setMimeType("text/xml");
                        this.queue.add(new Event(EventType.TEXT_UNIT, this.tu));
                        this.buildEndElement(true);
                    }
                    return;
                }
                case 5: {
                    if (srcCont.count() == 1 && srcCont.isEmpty()) {
                        comment = (String)comment + "<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->";
                        firstPartIsComment = true;
                        break;
                    }
                    srcCont.append(new TextPart("<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->"), true);
                }
            }
        }
    }

    private TextFragment processContent(String nameForExit) throws XMLStreamException {
        TextFragment tf = new TextFragment();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: 
                case 6: 
                case 12: {
                    tf.append(this.reader.getText());
                    break;
                }
                case 1: {
                    String name = this.reader.getLocalName();
                    TextFragment.TagType tagType = TextFragment.TagType.PLACEHOLDER;
                    String type = "ph";
                    int idToUse = -1;
                    this.appendCode(tagType, idToUse, name, type, false, tf);
                    break;
                }
                case 2: {
                    String name = this.reader.getLocalName();
                    if (!name.equals(nameForExit)) break;
                    return tf;
                }
            }
        }
        return tf;
    }

    private String buildStartElement(boolean store) {
        StringBuilder tmp = new StringBuilder();
        String prefix = this.reader.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            tmp.append("<" + this.reader.getLocalName());
        } else {
            tmp.append("<" + prefix + ":" + this.reader.getLocalName());
        }
        int count = this.reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            prefix = this.reader.getNamespacePrefix(i);
            tmp.append(String.format(" xmlns%s=\"%s\"", prefix != null ? ":" + prefix : "", this.reader.getNamespaceURI(i)));
        }
        count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            prefix = this.reader.getAttributePrefix(i);
            String attrName = String.format("%s%s", prefix == null || prefix.length() == 0 ? "" : prefix + ":", this.reader.getAttributeLocalName(i));
            if (TARGETLOCALE.equals(attrName)) {
                tmp.append(" targetlocale=\"");
                this.skel.append(tmp.toString());
                this.skel.append(this.trgLoc.toString());
                tmp.setLength(0);
                tmp.append("\"");
                continue;
            }
            tmp.append(String.format(" %s=\"%s\"", attrName, Util.escapeToXML(this.reader.getAttributeValue(i).replace("\n", this.lineBreak), 3, true, null)));
        }
        tmp.append(">");
        if (store) {
            this.skel.append(tmp.toString());
        }
        return tmp.toString();
    }

    private String buildEndElement(boolean store) {
        StringBuilder tmp = new StringBuilder();
        String prefix = this.reader.getPrefix();
        if (prefix != null && prefix.length() > 0) {
            tmp.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
        } else {
            tmp.append("</" + this.reader.getLocalName() + ">");
        }
        if (store) {
            this.skel.append(tmp.toString());
        }
        return tmp.toString();
    }

    private void createDocumentPartIfNeeded() {
        if (!this.skel.isEmpty(true)) {
            DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
            this.skel = new GenericSkeleton();
        }
    }

    private void appendCode(TextFragment.TagType tagType, int id, String tagName, String type, boolean store, TextFragment content) {
        try {
            String prefix;
            int endStack = 1;
            StringBuilder innerCode = new StringBuilder();
            StringBuilder outerCode = null;
            outerCode = new StringBuilder();
            outerCode.append("<" + tagName);
            int count = this.reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (!this.reader.isAttributeSpecified(i)) continue;
                prefix = this.reader.getAttributePrefix(i);
                outerCode.append(String.format(" %s%s=\"%s\"", prefix == null || prefix.length() == 0 ? "" : prefix + ":", this.reader.getAttributeLocalName(i), Util.escapeToXML(this.reader.getAttributeValue(i).replace("\n", this.lineBreak), 3, true, null)));
            }
            outerCode.append(">");
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        int i;
                        if (store) {
                            this.buildStartElement(store);
                        }
                        StringBuilder tmpg = new StringBuilder();
                        if (tagName.equals(this.reader.getLocalName())) {
                            ++endStack;
                        }
                        if ((prefix = this.reader.getPrefix()) == null || prefix.length() == 0) {
                            tmpg.append("<" + this.reader.getLocalName());
                        } else {
                            tmpg.append("<" + prefix + ":" + this.reader.getLocalName());
                        }
                        count = this.reader.getNamespaceCount();
                        for (i = 0; i < count; ++i) {
                            prefix = this.reader.getNamespacePrefix(i);
                            tmpg.append(String.format(" xmlns%s=\"%s\"", prefix != null ? ":" + prefix : "", this.reader.getNamespaceURI(i)));
                        }
                        count = this.reader.getAttributeCount();
                        for (i = 0; i < count; ++i) {
                            if (!this.reader.isAttributeSpecified(i)) continue;
                            prefix = this.reader.getAttributePrefix(i);
                            tmpg.append(String.format(" %s%s=\"%s\"", prefix == null || prefix.length() == 0 ? "" : prefix + ":", this.reader.getAttributeLocalName(i), Util.escapeToXML(this.reader.getAttributeValue(i).replace("\n", this.lineBreak), 3, true, null)));
                        }
                        tmpg.append(">");
                        innerCode.append(tmpg.toString());
                        outerCode.append(tmpg.toString());
                        break;
                    }
                    case 2: {
                        if (store) {
                            this.buildEndElement(store);
                        }
                        if (tagName.equals(this.reader.getLocalName()) && --endStack == 0) {
                            Code code = content.append(tagType, type, innerCode.toString(), id);
                            outerCode.append("</" + tagName + ">");
                            code.setOuterData(outerCode.toString());
                            return;
                        }
                        prefix = this.reader.getPrefix();
                        if (prefix == null || prefix.length() == 0) {
                            innerCode.append("</" + this.reader.getLocalName() + ">");
                            outerCode.append("</" + this.reader.getLocalName() + ">");
                            break;
                        }
                        innerCode.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
                        outerCode.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        innerCode.append(this.reader.getText());
                        outerCode.append(Util.escapeToXML(this.reader.getText(), 0, true, null));
                        if (!store) break;
                        this.skel.append(Util.escapeToXML(this.reader.getText(), 0, true, null));
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }
}

