/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.tmx;

import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.AlignmentStatus;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.tmx.TmxFilter;
import net.sf.okapi.filters.tmx.TmxUtils;

public class TmxTuv {
    LocaleId lang;
    TmxFilter.TuvXmlLang trgType;
    int langCount;
    GenericSkeleton skelBefore = new GenericSkeleton();
    GenericSkeleton skelAfter = new GenericSkeleton();
    TextContainer tc = new TextContainer();
    String lineBreak;
    boolean finishedSegSection;
    private final String sep;

    TmxTuv(LocaleId lang, TmxFilter.TuvXmlLang trgType, int counter, int segType, String lineBreak, String sep) {
        this.lang = lang;
        this.trgType = trgType;
        this.langCount = counter;
        this.lineBreak = lineBreak;
        this.sep = sep;
        if (segType == 0) {
            this.tc.setHasBeenSegmentedFlag(true);
            this.tc.getSegments().setAlignmentStatus(AlignmentStatus.ALIGNED);
        } else if (segType == 1) {
            this.tc.setHasBeenSegmentedFlag(false);
            this.tc.getSegments().setAlignmentStatus(AlignmentStatus.NOT_ALIGNED);
        }
    }

    void parseStartElement(XMLStreamReader reader, TmxFilter.TuvXmlLang tuvTrgType, boolean processAllTargets, boolean escapeGT) {
        this.parseStartElement(reader, tuvTrgType, processAllTargets, escapeGT, null);
    }

    String parseStartElement(XMLStreamReader reader, TmxFilter.TuvXmlLang tuvTrgType, boolean processAllTargets, boolean escapeGT, String elem) {
        int i;
        String propName = "";
        String prefix = reader.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            this.skelBefore.append("<" + reader.getLocalName());
        } else {
            this.skelBefore.append("<" + prefix + ":" + reader.getLocalName());
        }
        int count = reader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            TmxUtils.copyXMLNSToSkeleton(this.skelBefore, reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
        }
        count = reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            if (!reader.isAttributeSpecified(i)) continue;
            TmxUtils.copyAttributeToSkeleton(this.skelBefore, reader, i, this.lineBreak, escapeGT);
            if (elem != null && elem.equals("prop")) {
                if (!reader.getAttributeLocalName(i).equals("type")) continue;
                propName = reader.getAttributeValue(i);
                continue;
            }
            if (elem != null && elem.equals("note") || tuvTrgType != TmxFilter.TuvXmlLang.SOURCE && tuvTrgType != TmxFilter.TuvXmlLang.TARGET && !processAllTargets) continue;
            this.tc.setProperty(new Property(reader.getAttributeLocalName(i), reader.getAttributeValue(i), true));
        }
        this.skelBefore.append(">");
        if (elem != null && elem.equals("note")) {
            propName = "note";
        }
        return propName;
    }

    void appendToSkel(String pskel) {
        if (!this.finishedSegSection) {
            this.skelBefore.append(pskel);
        } else {
            this.skelAfter.append(pskel);
        }
    }

    void parseEndElement(XMLStreamReader reader) {
        this.parseEndElement(reader, false);
    }

    void parseEndElement(XMLStreamReader reader, boolean addToSkelBefore) {
        String ns = reader.getPrefix();
        if (ns == null || ns.length() == 0) {
            if (addToSkelBefore) {
                this.skelBefore.append("</" + reader.getLocalName() + ">");
            } else {
                this.skelAfter.append("</" + reader.getLocalName() + ">");
            }
        } else {
            if (addToSkelBefore) {
                this.skelBefore.append("</" + ns + ":" + reader.getLocalName() + ">");
            } else {
                this.skelAfter.append("</" + ns + ":" + reader.getLocalName() + ">");
            }
            this.skelBefore.append("</" + ns + ":" + reader.getLocalName() + ">");
        }
    }

    void setProperty(Property prop) {
        Property existingProp = this.tc.getProperty(prop.getName());
        if (existingProp != null) {
            existingProp.setValue(existingProp.getValue() + this.sep + prop.getValue());
        } else {
            this.tc.setProperty(prop);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----TmxTuv-----\n");
        sb.append("Trg Lang: ").append(this.lang).append("     Trg Type: ").append((Object)this.trgType).append("     Counter: ").append(this.langCount).append("\n");
        sb.append("Skel Before: ").append(this.skelBefore).append("\n");
        for (String pname : this.tc.getPropertyNames()) {
            sb.append("Prop Name: ").append(pname).append("     Prop Value: ").append(this.tc.getProperty(pname)).append("\n");
        }
        sb.append(this.tc.getCodedText()).append("\n");
        sb.append("Skel After: ").append(this.skelAfter).append("\n\n");
        return sb.toString();
    }
}

