/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.filters.openxml.ContentFilter;
import net.sf.okapi.filters.openxml.DefaultPart;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupModifiablePart;
import net.sf.okapi.filters.openxml.Namespace;
import net.sf.okapi.filters.openxml.Namespaces2;
import net.sf.okapi.filters.openxml.NonModifiablePart;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.RelationshipsPart;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;
import net.sf.okapi.filters.openxml.WordStyleDefinitions;
import net.sf.okapi.filters.openxml.WordStyleDefinitionsReader;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

class WordDocument
implements Document {
    private static final String TARGET_REL_FILE = "document.xml.rels";
    private static final String GLOSSARY_DOCUMENT = "/glossaryDocument";
    private static final String STYLES = "/styles";
    private final Document.General generalDocument;
    private Enumeration<? extends ZipEntry> entries;
    private String glossaryPartName;
    private StyleDefinitions mainStyleDefinitions;
    private StyleDefinitions glossaryStyleDefinitions;
    private LinkedHashMap<ZipEntry, Markup> postponedParts;

    WordDocument(Document.General generalDocument) {
        this.generalDocument = generalDocument;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.postponedParts = new LinkedHashMap();
        this.entries = this.entries();
        this.initialiseGlossaryPartName();
        this.initialiseStyleDefinitions();
        return this.generalDocument.startDocumentEvent();
    }

    private Enumeration<? extends ZipEntry> entries() {
        ArrayList<? extends ZipEntry> list = Collections.list(this.generalDocument.entries());
        ArrayList<String> additionalParts = new ArrayList<String>();
        additionalParts.add("word/_rels/document.xml.rels");
        additionalParts.add("word/document.xml");
        list.sort(new ZipEntryComparator(additionalParts));
        return Collections.enumeration(list);
    }

    private void initialiseGlossaryPartName() throws IOException, XMLStreamException {
        String glossaryDocumentSourceType = this.generalDocument.documentRelationshipsNamespace().uri().concat(GLOSSARY_DOCUMENT);
        this.glossaryPartName = this.generalDocument.relationshipTargetFor(glossaryDocumentSourceType);
    }

    private void initialiseStyleDefinitions() throws IOException, XMLStreamException {
        String styles = this.generalDocument.documentRelationshipsNamespace().uri().concat(STYLES);
        String partPath = this.generalDocument.relationshipTargetFor(styles);
        this.mainStyleDefinitions = this.styleDefinitions(partPath);
        partPath = this.glossaryRelationshipTargetFor(styles);
        this.glossaryStyleDefinitions = this.styleDefinitions(partPath);
    }

    private String glossaryRelationshipTargetFor(String relationshipType) throws IOException, XMLStreamException {
        if (null == this.glossaryPartName) {
            return null;
        }
        Relationships relationships = this.generalDocument.relationshipsFor(this.glossaryPartName);
        List<Relationships.Rel> rels = relationships.getRelByType(relationshipType);
        if (null == rels) {
            return null;
        }
        return rels.get((int)0).target;
    }

    private StyleDefinitions styleDefinitions(String partPath) throws IOException, XMLStreamException {
        if (null == partPath) {
            return new StyleDefinitions.Empty();
        }
        try (Reader reader = this.generalDocument.getPartReader(partPath);){
            WordStyleDefinitions styleDefinitions = new WordStyleDefinitions(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory());
            styleDefinitions.readWith(new WordStyleDefinitionsReader(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.generalDocument.inputFactory().createXMLEventReader(reader)));
            WordStyleDefinitions wordStyleDefinitions = styleDefinitions;
            return wordStyleDefinitions;
        }
    }

    @Override
    public boolean isStyledTextPart(ZipEntry entry) {
        String type = this.generalDocument.contentTypeFor(entry);
        return type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml") || type.equals("application/vnd.ms-word.document.macroEnabled.main+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml") || type.equals("application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml") || type.equals("application/vnd.openxmlformats-officedocument.drawingml.chart+xml") || this.isGlossaryStyledTextPart(entry);
    }

    private boolean isGlossaryStyledTextPart(ZipEntry entry) {
        String type = this.generalDocument.contentTypeFor(entry);
        return type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml");
    }

    @Override
    public boolean hasNextPart() {
        return this.entries.hasMoreElements() || !this.postponedParts.isEmpty();
    }

    @Override
    public Part nextPart() throws IOException, XMLStreamException {
        if (!this.entries.hasMoreElements()) {
            return this.nextPostponedPart();
        }
        ZipEntry entry = this.entries.nextElement();
        String contentType = this.generalDocument.contentTypeFor(entry);
        if ("application/vnd.openxmlformats-package.relationships+xml".equals(contentType) && entry.getName().endsWith(TARGET_REL_FILE) && this.generalDocument.conditionalParameters().getExtractExternalHyperlinks()) {
            return new RelationshipsPart(this.generalDocument, entry);
        }
        if (!this.isTranslatablePart(entry)) {
            if (this.isStylesPart(contentType)) {
                this.postponedParts.put(entry, new Markup.Empty());
                return this.nextPart();
            }
            return new NonModifiablePart(this.generalDocument, entry);
        }
        if (this.isStyledTextPart(entry)) {
            StyleDefinitions styleDefinitions = this.styleDefinitionsFor(entry);
            StyleOptimisation styleOptimisation = this.styleOptimisationsFor(entry, styleDefinitions);
            return new StyledTextPart(this.generalDocument, entry, styleDefinitions, styleOptimisation);
        }
        ContentFilter contentFilter = new ContentFilter(this.generalDocument.conditionalParameters(), entry.getName());
        ParseType parseType = ParseType.MSWORD;
        if ("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml".equals(contentType)) {
            contentFilter.setBInSettingsFile(true);
        } else if ("application/vnd.openxmlformats-package.core-properties+xml".equals(contentType)) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        }
        contentFilter.setUpConfig(parseType);
        return new DefaultPart(this.generalDocument, entry, contentFilter);
    }

    private Part nextPostponedPart() throws IOException, XMLStreamException {
        Iterator<Map.Entry<ZipEntry, Markup>> iterator = this.postponedParts.entrySet().iterator();
        Map.Entry<ZipEntry, Markup> mapEntry = iterator.next();
        iterator.remove();
        String contentType = this.generalDocument.contentTypeFor(mapEntry.getKey());
        if (this.isStylesPart(contentType)) {
            return new MarkupModifiablePart(this.generalDocument, mapEntry.getKey(), this.styleDefinitions(mapEntry.getKey()).asMarkup());
        }
        return new MarkupModifiablePart(this.generalDocument, mapEntry.getKey(), mapEntry.getValue());
    }

    private StyleDefinitions styleDefinitions(ZipEntry entry) throws IOException, XMLStreamException {
        String styles = this.generalDocument.documentRelationshipsNamespace().uri().concat(STYLES);
        String partPath = this.glossaryRelationshipTargetFor(styles);
        if (entry.getName().equals(partPath)) {
            return this.glossaryStyleDefinitions;
        }
        return this.mainStyleDefinitions;
    }

    private StyleDefinitions styleDefinitionsFor(ZipEntry entry) {
        if (this.isGlossaryStyledTextPart(entry)) {
            return this.glossaryStyleDefinitions;
        }
        return this.mainStyleDefinitions;
    }

    private StyleOptimisation styleOptimisationsFor(ZipEntry entry, StyleDefinitions styleDefinitions) throws IOException, XMLStreamException {
        Namespace namespace = this.namespacesOf(entry).forPrefix("w");
        if (null == namespace) {
            return new StyleOptimisation.Bypass();
        }
        return new StyleOptimisation.Default(new StyleOptimisation.Bypass(), this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), new QName(namespace.uri(), "pPr", namespace.prefix()), new QName(namespace.uri(), "rPr", namespace.prefix()), Collections.singletonList(new QName(namespace.uri(), "rStyle", namespace.prefix())), styleDefinitions);
    }

    private Namespaces2 namespacesOf(ZipEntry entry) throws IOException, XMLStreamException {
        try (InputStreamReader reader = new InputStreamReader(this.generalDocument.inputStreamFor(entry));){
            Namespaces2.Default namespaces = new Namespaces2.Default(this.generalDocument.inputFactory());
            namespaces.readWith(reader);
            Namespaces2.Default default_ = namespaces;
            return default_;
        }
    }

    private boolean isTranslatablePart(ZipEntry entry) {
        String type = this.generalDocument.contentTypeFor(entry);
        if (!entry.getName().endsWith(".xml")) {
            return false;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml")) {
            return true;
        }
        if (type.equals("application/vnd.ms-word.document.macroEnabled.main+xml")) {
            return true;
        }
        if (this.generalDocument.conditionalParameters().getTranslateDocProperties() && type.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.header+xml") || type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml")) {
            return this.generalDocument.conditionalParameters().getTranslateWordHeadersFooters();
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml")) {
            return this.generalDocument.conditionalParameters().getTranslateComments();
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.drawingml.chart+xml")) {
            return true;
        }
        return this.isStyledTextPart(entry);
    }

    private boolean isStylesPart(String type) {
        return "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml".equals(type);
    }

    @Override
    public void close() throws IOException {
    }
}

