/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.RunFonts;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

class RunPropertyFactory {
    private static final int DEFAULT_EVENTS_SIZE = 2;
    private static final EnumSet<WpmlTogglePropertyName> WPML_TOGGLE_PROPERTY_NAMES = EnumSet.complementOf(EnumSet.of(WpmlTogglePropertyName.UNSUPPORTED));
    private static final Set<String> DML_BOOLEAN_PROPERTY_NAMES = new HashSet<String>(Arrays.asList("b", "dirty", "err", "i", "kumimoji", "noProof", "normalizeH", "smtClean"));
    private static final Set<String> DML_HYPERLINK_NAMES = new HashSet<String>(Arrays.asList("hlinkClick", "hlinkMouseOver"));

    RunPropertyFactory() {
    }

    static RunProperty createRunProperty(StartElementContext startElementContext) throws XMLStreamException {
        QName startElementName = startElementContext.getStartElement().getName();
        switch (startElementName.getPrefix()) {
            case "a": {
                if (DML_HYPERLINK_NAMES.contains(startElementName.getLocalPart())) {
                    return new RunProperty.HyperlinkRunProperty(XMLEventHelpers.gatherEvents(startElementContext));
                }
                if (!RunProperty.FontRunProperty.DML_NAMES.contains(startElementName.getLocalPart())) break;
                return new RunProperty.FontRunProperty(XMLEventHelpers.gatherEvents(startElementContext), startElementContext.getEventFactory());
            }
            case "w": {
                if ("rFonts".equals(startElementName.getLocalPart())) {
                    return new RunProperty.FontsRunProperty(RunFonts.createRunFonts(startElementContext));
                }
                if ("rStyle".equals(startElementName.getLocalPart())) {
                    return new RunProperty.StyleRunProperty(XMLEventHelpers.gatherEvents(startElementContext));
                }
                if (WPML_TOGGLE_PROPERTY_NAMES.contains((Object)WpmlTogglePropertyName.fromString(startElementName.getLocalPart()))) {
                    return new RunProperty.WpmlToggleRunProperty(XMLEventHelpers.gatherEvents(startElementContext));
                }
                if ("highlight".equals(startElementName.getLocalPart())) {
                    return new RunProperty.HighlightRunProperty(XMLEventHelpers.gatherEvents(startElementContext));
                }
                if ("color".equals(startElementName.getLocalPart())) {
                    return new RunProperty.ColorRunProperty(XMLEventHelpers.gatherEvents(startElementContext));
                }
                if (!"shd".equals(startElementName.getLocalPart())) break;
                return new RunProperty.ShadeRunProperty(XMLEventHelpers.gatherEvents(startElementContext));
            }
            case "": {
                if (RunProperty.FontRunProperty.SML_NAMES.contains(startElementName.getLocalPart())) {
                    return new RunProperty.FontRunProperty(XMLEventHelpers.gatherEvents(startElementContext), startElementContext.getEventFactory());
                }
                return new RunProperty.SmlRunProperty(XMLEventHelpers.gatherEvents(startElementContext));
            }
        }
        return new RunProperty.GenericRunProperty(XMLEventHelpers.gatherEvents(startElementContext));
    }

    static RunProperty createRunProperty(Attribute attribute) {
        return RunPropertyFactory.createRunProperty(attribute.getName(), attribute.getValue());
    }

    static RunProperty createRunProperty(QName name, String value) {
        if (DML_BOOLEAN_PROPERTY_NAMES.contains(name.getLocalPart())) {
            return new RunProperty.BooleanAttributeRunProperty(name, value);
        }
        return new RunProperty.AttributeRunProperty(name, value);
    }

    static RunProperty createRunProperty(CreationalParameters creationalParameters, String localName, Map<String, String> attributes) {
        ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(2);
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>(attributes.size());
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            attributeList.add(creationalParameters.getEventFactory().createAttribute(creationalParameters.getPrefix(), creationalParameters.getNamespaceUri(), attribute.getKey(), attribute.getValue()));
        }
        events.add(creationalParameters.getEventFactory().createStartElement(creationalParameters.getPrefix(), creationalParameters.getNamespaceUri(), localName, attributeList.iterator(), null));
        events.add(creationalParameters.getEventFactory().createEndElement(creationalParameters.getPrefix(), creationalParameters.getNamespaceUri(), localName));
        return new RunProperty.GenericRunProperty(events);
    }

    static enum SmlPropertyName {
        BOLD("b", "true"),
        ITALICS("i", "true"),
        SHADOW("shadow", "true"),
        STRIKE_THROUGH("strike", "true"),
        UNDERLINE("u", "single"),
        UNSUPPORTED("", "");

        private final String name;
        private final String defaultValue;

        private SmlPropertyName(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        String getDefaultValue() {
            return this.defaultValue;
        }

        static SmlPropertyName fromString(String name) {
            for (SmlPropertyName propertyName : SmlPropertyName.values()) {
                if (!propertyName.name.equals(name)) continue;
                return propertyName;
            }
            return UNSUPPORTED;
        }
    }

    static enum WpmlTogglePropertyName {
        BOLD("b"),
        COMPLEX_SCRIPT_BOLD("bCs"),
        CAPS("caps"),
        EMBOSS("emboss"),
        ITALICS("i"),
        COMPLEX_SCRIPT_ITALICS("iCs"),
        IMPRINT("imprint"),
        OUTLINE("outline"),
        SHADOW("shadow"),
        SMALL_CAPS("smallCaps"),
        STRIKE_THROUGH("strike"),
        DOUBLE_STRIKE_THROUGH("dstrike"),
        VANISH("vanish"),
        SPEC_VANISH("specVanish"),
        NO_PROOF("noProof"),
        O_MATH("oMath"),
        COMPLEX_SCRIPT("cs"),
        RIGHT_TO_LEFT("rtl"),
        SNAP_TO_GRID("snapToGrid"),
        WEB_HIDDEN("webHidden"),
        UNSUPPORTED("");

        private final String name;

        private WpmlTogglePropertyName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        static WpmlTogglePropertyName fromString(String value) {
            if (null == value) {
                return UNSUPPORTED;
            }
            for (WpmlTogglePropertyName propertyName : WpmlTogglePropertyName.values()) {
                if (!propertyName.toString().equals(value)) continue;
                return propertyName;
            }
            return UNSUPPORTED;
        }
    }
}

