/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import com.twelvemonkeys.io.ole2.CompoundDocument;
import com.twelvemonkeys.io.ole2.CorruptDocumentException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiEncryptedDataException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.ContentTypes;
import net.sf.okapi.filters.openxml.DispersedTranslations;
import net.sf.okapi.filters.openxml.ExcelDocument;
import net.sf.okapi.filters.openxml.Namespace;
import net.sf.okapi.filters.openxml.Namespaces2;
import net.sf.okapi.filters.openxml.Part;
import net.sf.okapi.filters.openxml.PowerpointDocument;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.VisioDocument;
import net.sf.okapi.filters.openxml.WordDocument;

interface Document {
    public Event open() throws IOException, XMLStreamException;

    public boolean isStyledTextPart(ZipEntry var1);

    public boolean hasNextPart();

    public Part nextPart() throws IOException, XMLStreamException;

    public void close() throws IOException;

    public static class General
    implements Document {
        private static final String UNSUPPORTED_MAIN_DOCUMENT_PART = "Unsupported main document part";
        private static final String EMPTY = "";
        private static final String OFFICE_DOCUMENT = "/officeDocument";
        private static final String DOCUMENT = "/document";
        private final ConditionalParameters conditionalParameters;
        private final XMLInputFactory inputFactory;
        private final XMLOutputFactory outputFactory;
        private final XMLEventFactory eventFactory;
        private final DispersedTranslations dispersedTranslations;
        private final String startDocumentId;
        private final URI uri;
        private final LocaleId sourceLocale;
        private final String encoding;
        private final EncoderManager encoderManager;
        private final IFilter subfilter;
        private final IFilterWriter filterWriter;
        private ZipFile zipFile;
        private int currentSubDocumentId;
        private ContentTypes contentTypes;
        private String mainPartName;
        private Namespace documentRelationshipsNamespace;
        private Document categorisedDocument;

        General(ConditionalParameters conditionalParameters, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, DispersedTranslations dispersedTranslations, String startDocumentId, URI uri, LocaleId sourceLocale, String encoding, EncoderManager encoderManager, IFilter subfilter, IFilterWriter filterWriter) {
            this.conditionalParameters = conditionalParameters;
            this.inputFactory = inputFactory;
            this.outputFactory = outputFactory;
            this.eventFactory = eventFactory;
            this.dispersedTranslations = dispersedTranslations;
            this.startDocumentId = startDocumentId;
            this.uri = uri;
            this.sourceLocale = sourceLocale;
            this.encoding = encoding;
            this.encoderManager = encoderManager;
            this.subfilter = subfilter;
            this.filterWriter = filterWriter;
        }

        @Override
        public Event open() throws IOException, XMLStreamException {
            File fZip = new File(this.uri.getPath());
            if (this.isEncrypted(fZip)) {
                throw new OkapiEncryptedDataException();
            }
            this.zipFile = new ZipFile(new File(this.uri.getPath()), 1);
            this.currentSubDocumentId = 0;
            this.initializeContentTypes();
            this.initializeMainPartNameAndDocumentRelationshipsNamespace();
            this.initializeCategorisedDocument();
            return this.categorisedDocument.open();
        }

        private boolean isEncrypted(File file) throws IOException {
            boolean bl;
            FileImageInputStream is = new FileImageInputStream(file);
            try {
                is.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                new CompoundDocument((ImageInputStream)is);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (CorruptDocumentException e) {
                    return false;
                }
            }
            is.close();
            return bl;
        }

        private void initializeContentTypes() throws XMLStreamException, IOException {
            this.contentTypes = new ContentTypes(this.inputFactory);
            this.contentTypes.parseFromXML(this.getPartReader("[Content_Types].xml"));
        }

        private void initializeMainPartNameAndDocumentRelationshipsNamespace() throws IOException, XMLStreamException {
            Relationships relationships = this.relationshipsFor(EMPTY);
            String officeDocumentSourceType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships".concat(OFFICE_DOCUMENT);
            String strictOfficeDocumentSourceType = "http://purl.oclc.org/ooxml/officeDocument/relationships".concat(OFFICE_DOCUMENT);
            String visioDocumentSourceType = "http://schemas.microsoft.com/visio/2010/relationships".concat(DOCUMENT);
            if (relationships.hasRelType(officeDocumentSourceType)) {
                this.mainPartName = relationships.getRelByType((String)officeDocumentSourceType).get((int)0).target;
                this.documentRelationshipsNamespace = new Namespace.Default("http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            } else if (relationships.hasRelType(strictOfficeDocumentSourceType)) {
                this.mainPartName = relationships.getRelByType((String)strictOfficeDocumentSourceType).get((int)0).target;
                this.documentRelationshipsNamespace = new Namespace.Default("http://purl.oclc.org/ooxml/officeDocument/relationships");
            } else if (relationships.hasRelType(visioDocumentSourceType)) {
                this.mainPartName = relationships.getRelByType((String)visioDocumentSourceType).get((int)0).target;
                this.documentRelationshipsNamespace = new Namespace.Default("http://schemas.microsoft.com/visio/2010/relationships");
            } else {
                throw new OkapiBadFilterInputException(UNSUPPORTED_MAIN_DOCUMENT_PART);
            }
        }

        private void initializeCategorisedDocument() throws XMLStreamException, IOException {
            switch (this.contentTypes.getContentType(this.mainPartName)) {
                case "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml": 
                case "application/vnd.ms-word.document.macroEnabled.main+xml": 
                case "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml": 
                case "application/vnd.ms-word.template.macroEnabledTemplate.main+xml": {
                    this.categorisedDocument = new WordDocument(this);
                    break;
                }
                case "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml": 
                case "application/vnd.ms-powerpoint.presentation.macroEnabled.main+xml": 
                case "application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml": 
                case "application/vnd.ms-powerpoint.slideshow.macroEnabled.main+xml": 
                case "application/vnd.openxmlformats-officedocument.presentationml.template.main+xml": 
                case "application/vnd.ms-powerpoint.template.macroEnabled.main+xml": {
                    this.categorisedDocument = new PowerpointDocument(this);
                    break;
                }
                case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": 
                case "application/vnd.ms-excel.sheet.macroEnabled.main+xml": 
                case "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml": 
                case "application/vnd.ms-excel.template.macroEnabled.main+xml": {
                    this.categorisedDocument = new ExcelDocument(this, this.encoderManager, this.subfilter);
                    break;
                }
                case "application/vnd.ms-visio.drawing.main+xml": 
                case "application/vnd.ms-visio.drawing.macroEnabled.main+xml": {
                    this.categorisedDocument = new VisioDocument(this);
                    break;
                }
                default: {
                    throw new OkapiBadFilterInputException(String.format("%s: %s", UNSUPPORTED_MAIN_DOCUMENT_PART, this.mainPartName));
                }
            }
        }

        Event startDocumentEvent() {
            StartDocument startDoc = new StartDocument(this.startDocumentId);
            startDoc.setName(this.uri.getPath());
            startDoc.setLocale(this.sourceLocale);
            startDoc.setMimeType("text/xml");
            startDoc.setLineBreak("\n");
            startDoc.setEncoding(this.encoding, false);
            startDoc.setFilterWriter(this.filterWriter);
            startDoc.setFilterId("okf_openxml");
            startDoc.setFilterParameters(this.conditionalParameters);
            ZipSkeleton skel = new ZipSkeleton(this.zipFile, null);
            return new Event(EventType.START_DOCUMENT, startDoc, skel);
        }

        @Override
        public boolean isStyledTextPart(ZipEntry entry) {
            return this.categorisedDocument.isStyledTextPart(entry);
        }

        @Override
        public boolean hasNextPart() {
            return this.categorisedDocument.hasNextPart();
        }

        @Override
        public Part nextPart() throws IOException, XMLStreamException {
            return this.categorisedDocument.nextPart();
        }

        @Override
        public void close() throws IOException {
            if (null != this.categorisedDocument) {
                this.categorisedDocument.close();
            }
            if (null != this.categorisedDocument) {
                this.zipFile.close();
            }
        }

        ConditionalParameters conditionalParameters() {
            return this.conditionalParameters;
        }

        XMLInputFactory inputFactory() {
            return this.inputFactory;
        }

        XMLOutputFactory outputFactory() {
            return this.outputFactory;
        }

        XMLEventFactory eventFactory() {
            return this.eventFactory;
        }

        DispersedTranslations dispersedTranslations() {
            return this.dispersedTranslations;
        }

        String documentId() {
            return this.startDocumentId;
        }

        String nextSubDocumentId() {
            return String.valueOf(++this.currentSubDocumentId);
        }

        LocaleId sourceLocale() {
            return this.sourceLocale;
        }

        String encoding() {
            return this.encoding;
        }

        ZipFile zipFile() {
            return this.zipFile;
        }

        InputStream inputStreamFor(ZipEntry entry) throws IOException {
            return this.zipFile.getInputStream(entry);
        }

        Enumeration<? extends ZipEntry> entries() {
            return this.zipFile.entries();
        }

        String contentTypeFor(ZipEntry entry) {
            return this.contentTypes.getContentType("/".concat(entry.getName()));
        }

        String mainPartName() {
            return this.mainPartName;
        }

        Namespace documentRelationshipsNamespace() {
            return this.documentRelationshipsNamespace;
        }

        Document categorisedDocument() {
            return this.categorisedDocument;
        }

        Namespaces2 namespacesOf(ZipEntry entry) throws IOException, XMLStreamException {
            try (InputStreamReader reader = new InputStreamReader(this.inputStreamFor(entry));){
                Namespaces2.Default namespaces = new Namespaces2.Default(this.inputFactory);
                namespaces.readWith(reader);
                Namespaces2.Default default_ = namespaces;
                return default_;
            }
        }

        Reader getPartReader(String partName) throws IOException {
            ZipEntry entry = this.zipFile.getEntry(partName);
            if (entry == null) {
                throw new OkapiBadFilterInputException("File is missing " + partName);
            }
            return new InputStreamReader(this.zipFile.getInputStream(entry), this.encoding);
        }

        Relationships relationshipsFor(String part) throws IOException, XMLStreamException {
            String partName = this.relationshipsPartNameFor(part);
            Relationships rels = new Relationships(this.inputFactory);
            if (this.isPartAvailable(partName)) {
                rels.parseFromXML(partName, this.getPartReader(partName));
            }
            return rels;
        }

        String relationshipsPartNameFor(String part) {
            int lastSlash = part.lastIndexOf("/");
            if (lastSlash == -1) {
                return "_rels/" + part + ".rels";
            }
            return part.substring(0, lastSlash) + "/_rels" + part.substring(lastSlash) + ".rels";
        }

        private boolean isPartAvailable(String partName) {
            return this.zipFile.getEntry(partName) != null;
        }

        String relationshipTargetFor(String relationshipType) throws IOException, XMLStreamException {
            Relationships relationships = this.relationshipsFor(this.mainPartName);
            List<Relationships.Rel> rels = relationships.getRelByType(relationshipType);
            if (null == rels) {
                return null;
            }
            return rels.get((int)0).target;
        }

        Map<String, String> relsByEntry(List<String> entryNames, String relType) throws IOException, XMLStreamException {
            HashMap<String, String> result = new HashMap<String, String>();
            for (String entryName : entryNames) {
                List<Relationships.Rel> rels = this.relationshipsFor(entryName).getRelByType(relType);
                if (rels == null || rels.isEmpty()) continue;
                for (Relationships.Rel rel : rels) {
                    result.put(rel.target, entryName);
                }
            }
            return result;
        }
    }
}

