/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CellAlignment;
import net.sf.okapi.filters.openxml.CellProtection;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.Fill;
import net.sf.okapi.filters.openxml.Font;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.NumberFormat;

interface DifferentialFormat {
    public static final String NAME = "dxf";

    public NumberFormat numberFormat();

    public Font font();

    public Fill fill();

    public CellAlignment alignment();

    public CellProtection protection();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Combined
    implements DifferentialFormat {
        private final NumberFormat numberFormat;
        private final Font font;
        private final Fill fill;
        private final CellAlignment alignment;
        private final CellProtection protection;

        Combined(NumberFormat numberFormat, Font font, Fill fill, CellAlignment alignment, CellProtection protection) {
            this.numberFormat = numberFormat;
            this.font = font;
            this.fill = fill;
            this.alignment = alignment;
            this.protection = protection;
        }

        @Override
        public NumberFormat numberFormat() {
            return this.numberFormat;
        }

        @Override
        public Font font() {
            return this.font;
        }

        @Override
        public Fill fill() {
            return this.fill;
        }

        @Override
        public CellAlignment alignment() {
            return this.alignment;
        }

        @Override
        public CellProtection protection() {
            return this.protection;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Default
    implements DifferentialFormat {
        private static final String BORDER = "border";
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final StartElement startElement;
        private NumberFormat numberFormat;
        private Font font;
        private Fill fill;
        private List<XMLEvent> borderEvents;
        private CellAlignment alignment;
        private CellProtection protection;
        private EndElement endElement;

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StartElement startElement) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.startElement = startElement;
        }

        @Override
        public NumberFormat numberFormat() {
            if (null == this.numberFormat) {
                this.numberFormat = NumberFormat.BuiltIn.GENERAL;
            }
            return this.numberFormat;
        }

        @Override
        public Font font() {
            if (null == this.font) {
                this.font = new Font.Empty();
            }
            return this.font;
        }

        @Override
        public Fill fill() {
            if (null == this.fill) {
                this.fill = new Fill.Empty();
            }
            return this.fill;
        }

        @Override
        public CellAlignment alignment() {
            if (null == this.alignment) {
                this.alignment = new CellAlignment.Empty();
            }
            return this.alignment;
        }

        @Override
        public CellProtection protection() {
            if (null == this.protection) {
                this.protection = new CellProtection.Empty();
            }
            return this.protection;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if ("font".equals(se.getName().getLocalPart())) {
                    this.font = new Font.Default(this.conditionalParameters, this.eventFactory, se);
                    this.font.readWith(reader);
                    continue;
                }
                if ("numFmt".equals(se.getName().getLocalPart())) {
                    this.numberFormat = new NumberFormat.Explicit(se);
                    this.numberFormat.readWith(reader);
                    continue;
                }
                if ("fill".equals(se.getName().getLocalPart())) {
                    this.fill = new Fill.Default(se);
                    this.fill.readWith(reader);
                    continue;
                }
                if ("alignment".equals(se.getName().getLocalPart())) {
                    this.alignment = new CellAlignment.Default(this.eventFactory, se);
                    this.alignment.readWith(reader);
                    continue;
                }
                if (BORDER.equals(se.getName().getLocalPart())) {
                    this.borderEvents = Default.eventsFor(se, reader);
                    continue;
                }
                if (!"protection".equals(se.getName().getLocalPart())) continue;
                this.protection = new CellProtection.Default(se);
                this.protection.readWith(reader);
            }
        }

        private static List<XMLEvent> eventsFor(StartElement startElement, XMLEventReader reader) throws XMLStreamException {
            LinkedList<XMLEvent> events = new LinkedList<XMLEvent>();
            events.add(startElement);
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                events.add(e);
                if (!e.isEndElement() || !e.asEndElement().getName().equals(startElement.getName())) continue;
                break;
            }
            return events;
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new LinkedList<MarkupComponent>()));
            mb.add(this.startElement);
            mb.add(this.font().asMarkup());
            mb.add(this.numberFormat().asMarkup());
            mb.add(this.fill().asMarkup());
            mb.add(this.alignment().asMarkup());
            if (null != this.borderEvents) {
                mb.addAll(this.borderEvents);
            }
            mb.add(this.protection().asMarkup());
            mb.add(this.endElement);
            return mb.build();
        }
    }

    public static final class Empty
    implements DifferentialFormat {
        @Override
        public NumberFormat numberFormat() {
            return NumberFormat.BuiltIn.GENERAL;
        }

        @Override
        public Font font() {
            return new Font.Empty();
        }

        @Override
        public Fill fill() {
            return new Fill.Empty();
        }

        @Override
        public CellAlignment alignment() {
            return new CellAlignment.Empty();
        }

        @Override
        public CellProtection protection() {
            return new CellProtection.Empty();
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

