/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.CellReference;
import net.sf.okapi.filters.openxml.ClarificationContext;
import net.sf.okapi.filters.openxml.CrossSheetCellReference;
import net.sf.okapi.filters.openxml.DispersedTranslations;
import net.sf.okapi.filters.openxml.MarkupComponent;

interface CharactersClarification {
    public void adjustClarificationContextWith(MarkupComponent.Context var1);

    public void performFor(List<XMLEvent> var1);

    public static final class ReferencesTranslation
    implements CharactersClarification {
        private static final String UNEXPECTED_NUMBER_OF_MATCHING_GROUPS = "Unexpected number of matched groups: ";
        private static final String INVALID_REFERENCE = "Invalid reference: ";
        private static final String EMPTY = "";
        private static final String DOUBLE_QUOTES = "\"";
        private static final String COMMA = ",";
        private static final Pattern pivotDataFormula = Pattern.compile("(.*?GETPIVOTDATA\\s?\\()(.+?)(\\).*)", 32);
        private static final Pattern crossReferenceInFormula = Pattern.compile("(.*?[,(']{1,2})([^/?*\\[\\]]+?)([,!)']{1}.*)", 32);
        private static final String INVALID_TABLE_NAME_CHARS = "[^/\\\\*'?\\[\\]:\\(\\), ]";
        private static final Pattern structuredReferenceInFormula = Pattern.compile("(.*?)((?:[^/\\\\*'?\\[\\]:\\(\\), ]*?[\\[]{2}.+?[\\]]{2})|(?:[^/\\\\*'?\\[\\]:\\(\\), ]*?\\[.+\\]))(.*)", 32);
        private static final Pattern itemAndColumnSpecifier = Pattern.compile("(.*?[\\[]{1,2})(.+?)([\\]]{1}.*)", 32);
        private final ClarificationContext clarificationContext;
        private final DispersedTranslations dispersedTranslations;

        ReferencesTranslation(ClarificationContext clarificationContext, DispersedTranslations dispersedTranslations) {
            this.clarificationContext = clarificationContext;
            this.dispersedTranslations = dispersedTranslations;
        }

        @Override
        public void adjustClarificationContextWith(MarkupComponent.Context context) {
            this.clarificationContext.adjust(context);
        }

        @Override
        public void performFor(List<XMLEvent> events) {
            ListIterator<XMLEvent> iterator = events.listIterator();
            while (iterator.hasNext()) {
                XMLEvent e = iterator.next();
                if (!e.isCharacters()) continue;
                String original = e.asCharacters().getData();
                String translated = this.translatedWithPivotDataFunctionIn(original);
                translated = this.translatedWithCrossReferencesIn(translated);
                if (original.equals(translated = this.translatedWithStructuredReferencesIn(translated))) continue;
                iterator.set(this.clarificationContext.creationalParameters().getEventFactory().createCharacters(translated));
            }
        }

        private String translatedWithPivotDataFunctionIn(String original) {
            Matcher matcher = pivotDataFormula.matcher(original);
            if (!matcher.find()) {
                return original;
            }
            StringBuilder result = new StringBuilder();
            if (matcher.groupCount() != MatchingGroup.values().length) {
                throw new IllegalStateException(UNEXPECTED_NUMBER_OF_MATCHING_GROUPS.concat(String.valueOf(matcher.groupCount())));
            }
            result.append(matcher.group(MatchingGroup.NON_TRANSLATABLE.value()));
            result.append(this.translatedWithPivotDataIn(matcher.group(MatchingGroup.TRANSLATABLE.value())));
            result.append(matcher.group(MatchingGroup.UNPROCESSED.value()));
            return result.toString();
        }

        private String translatedWithPivotDataIn(String string) {
            String[] parts = string.split("\\s?,\\s?");
            CrossSheetCellReference pivotTablePartReference = this.relativeCrossSheetCellReferenceFrom(parts[1]);
            if (!this.dispersedTranslations.presentFor(pivotTablePartReference)) {
                return string;
            }
            String namespace = this.dispersedTranslations.namespaceFor(pivotTablePartReference);
            StringBuilder result = new StringBuilder();
            this.translateAndAppend(namespace, parts[0], result);
            result.append(COMMA);
            result.append(parts[1]);
            if (2 < parts.length) {
                result.append(COMMA);
                for (int i = 2; i < parts.length; ++i) {
                    this.translateAndAppend(namespace, parts[i], result);
                    if (i >= parts.length - 1) continue;
                    result.append(COMMA);
                }
            }
            return result.toString();
        }

        private void translateAndAppend(String namespace, String data, StringBuilder result) {
            String unwrappedData = this.unwrap(data);
            if (this.dispersedTranslations.namespaceAndRawSourceMatch(namespace, unwrappedData)) {
                String v = this.dispersedTranslations.encodedTargetOrRawSourceFor(namespace, unwrappedData, this.clarificationContext.targetLocale());
                result.append(DOUBLE_QUOTES).append(v).append(DOUBLE_QUOTES);
            } else {
                result.append(data);
            }
        }

        private String unwrap(String stringInDoubleQuotes) {
            String result = 2 == stringInDoubleQuotes.length() ? EMPTY : stringInDoubleQuotes.substring(1, stringInDoubleQuotes.length() - 1);
            return result;
        }

        private CrossSheetCellReference relativeCrossSheetCellReferenceFrom(String string) {
            CellReference cellReference;
            String worksheetName;
            String[] parts = string.split("!");
            if (1 == parts.length) {
                worksheetName = this.clarificationContext.markupComponentContext().name();
                cellReference = this.relativeCellReferenceFrom(parts[0]);
            } else if (2 == parts.length) {
                worksheetName = parts[0];
                cellReference = this.relativeCellReferenceFrom(parts[1]);
            } else {
                throw new IllegalStateException(INVALID_REFERENCE.concat(string));
            }
            return new CrossSheetCellReference(worksheetName, cellReference);
        }

        private CellReference relativeCellReferenceFrom(String string) {
            return new CellReference(string.replaceAll("\\$", EMPTY));
        }

        private String translatedWithCrossReferencesIn(String original) {
            Matcher matcher = crossReferenceInFormula.matcher(original);
            if (!matcher.find()) {
                return original;
            }
            return this.translatedWith(EMPTY, matcher);
        }

        private String translatedWithStructuredReferencesIn(String original) {
            String part;
            Matcher matcher = structuredReferenceInFormula.matcher(original);
            if (!matcher.find()) {
                return original;
            }
            StringBuilder result = new StringBuilder();
            do {
                if (matcher.groupCount() != MatchingGroup.values().length) {
                    throw new IllegalStateException(UNEXPECTED_NUMBER_OF_MATCHING_GROUPS.concat(String.valueOf(matcher.groupCount())));
                }
                result.append(matcher.group(MatchingGroup.NON_TRANSLATABLE.value()));
                String reference = matcher.group(MatchingGroup.TRANSLATABLE.value());
                result.append(this.translatedWithItemAndColumnSpecifiersIn(reference));
                part = matcher.group(MatchingGroup.UNPROCESSED.value());
                matcher.reset(part);
            } while (matcher.find());
            if (part != null) {
                result.append(part);
            }
            return result.toString();
        }

        private String translatedWithItemAndColumnSpecifiersIn(String original) {
            Matcher matcher = itemAndColumnSpecifier.matcher(original);
            if (!matcher.find()) {
                return original;
            }
            if (matcher.groupCount() != MatchingGroup.values().length) {
                throw new IllegalStateException(UNEXPECTED_NUMBER_OF_MATCHING_GROUPS.concat(String.valueOf(matcher.groupCount())));
            }
            String firstMatchedGroup = matcher.group(MatchingGroup.NON_TRANSLATABLE.value());
            int startOfTableSpecifier = firstMatchedGroup.indexOf("[");
            String tableName = -1 == startOfTableSpecifier ? EMPTY : firstMatchedGroup.substring(0, startOfTableSpecifier);
            return this.translatedWith(tableName, matcher);
        }

        private String translatedWith(String namespace, Matcher matcher) {
            String part;
            StringBuilder result = new StringBuilder();
            do {
                if (matcher.groupCount() != MatchingGroup.values().length) {
                    throw new IllegalStateException(UNEXPECTED_NUMBER_OF_MATCHING_GROUPS.concat(String.valueOf(matcher.groupCount())));
                }
                result.append(matcher.group(MatchingGroup.NON_TRANSLATABLE.value()));
                String specifier = matcher.group(MatchingGroup.TRANSLATABLE.value());
                if (this.dispersedTranslations.namespaceAndRawSourceMatch(namespace, specifier)) {
                    String v = this.dispersedTranslations.encodedTargetOrRawSourceFor(namespace, specifier, this.clarificationContext.targetLocale());
                    result.append(v);
                } else {
                    result.append(specifier);
                }
                part = matcher.group(MatchingGroup.UNPROCESSED.value());
                matcher.reset(part);
            } while (matcher.find());
            if (part != null) {
                result.append(part);
            }
            return result.toString();
        }

        private static enum MatchingGroup {
            NON_TRANSLATABLE(1),
            TRANSLATABLE(2),
            UNPROCESSED(3);

            private final int value;

            private MatchingGroup(int value) {
                this.value = value;
            }

            int value() {
                return this.value;
            }
        }
    }

    public static final class Bypass
    implements CharactersClarification {
        @Override
        public void adjustClarificationContextWith(MarkupComponent.Context context) {
        }

        @Override
        public void performFor(List<XMLEvent> events) {
        }
    }
}

