/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventFactory;
import net.sf.okapi.filters.openxml.Cell;
import net.sf.okapi.filters.openxml.CellType;

interface Cells {
    public void add(Cell var1);

    public Cells of(CellType var1);

    public ListIterator<Cell> iterator();

    public boolean worksheetStartsAt(ListIterator<Cell> var1);

    public boolean rowStartsAt(ListIterator<Cell> var1);

    public static class Default
    implements Cells {
        private final XMLEventFactory eventFactory;
        private final List<Cell> items;
        private int sharedStringIndex;

        Default(XMLEventFactory eventFactory, List<Cell> items) {
            this.eventFactory = eventFactory;
            this.items = items;
        }

        @Override
        public void add(Cell cell) {
            this.items.add(cell);
            if (CellType.SHARED_STRING == cell.type() || CellType.INLINE_STRING == cell.type()) {
                cell.value().update(this.eventFactory.createCharacters(String.valueOf(this.sharedStringIndex)));
                ++this.sharedStringIndex;
            }
        }

        @Override
        public Cells of(CellType type) {
            return new Default(this.eventFactory, this.items.stream().filter(c -> c.type() == type).collect(Collectors.toList()));
        }

        @Override
        public ListIterator<Cell> iterator() {
            return this.items.listIterator();
        }

        @Override
        public boolean worksheetStartsAt(ListIterator<Cell> iterator) {
            if (!iterator.hasPrevious()) {
                return true;
            }
            Cell current = iterator.previous();
            if (!iterator.hasPrevious()) {
                iterator.next();
                return true;
            }
            Cell previous = iterator.previous();
            iterator.next();
            iterator.next();
            return !previous.worksheetName().equals(current.worksheetName());
        }

        @Override
        public boolean rowStartsAt(ListIterator<Cell> iterator) {
            if (!iterator.hasPrevious()) {
                return true;
            }
            Cell current = iterator.previous();
            if (!iterator.hasPrevious()) {
                iterator.next();
                return true;
            }
            Cell previous = iterator.previous();
            iterator.next();
            iterator.next();
            return previous.cellReferencesRange().first().row() != current.cellReferencesRange().first().row();
        }
    }
}

