/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.idml.DesignMapFragments;
import net.sf.okapi.filters.idml.DesignMapSubDocument;
import net.sf.okapi.filters.idml.Markup;
import net.sf.okapi.filters.idml.MarkupModifiableSubDocument;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.MimeType;
import net.sf.okapi.filters.idml.NonModifiableSubDocument;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.StorySubDocument;
import net.sf.okapi.filters.idml.StyleDefinitions;
import net.sf.okapi.filters.idml.SubDocument;
import net.sf.okapi.filters.idml.ZipInput;

interface Document {
    public Event open() throws XMLStreamException, IOException;

    public boolean hasNextSubDocument();

    public SubDocument nextSubDocument();

    public void close() throws IOException;

    public static class Default
    implements Document {
        private final Parameters parameters;
        private final XMLInputFactory inputFactory;
        private final XMLOutputFactory outputFactory;
        private final XMLEventFactory eventFactory;
        private final String startDocumentId;
        private final URI uri;
        private final LocaleId sourceLocale;
        private final String encoding;
        private final String lineBreak;
        private final IFilterWriter filterWriter;
        private ZipFile zipFile;
        private ZipInput<XMLEventReader> zipInputReader;
        private DesignMapFragments designMapFragments;
        private StyleDefinitions styleDefinitions;
        private List<String> translatablePartNames;
        private Enumeration<? extends ZipEntry> zipFileEntries;
        private int currentSubDocumentId;

        Default(Parameters parameters, XMLInputFactory inputFactory, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, String startDocumentId, URI uri, LocaleId sourceLocale, String encoding, String lineBreak, IFilterWriter filterWriter) {
            this.parameters = parameters;
            this.inputFactory = inputFactory;
            this.outputFactory = outputFactory;
            this.eventFactory = eventFactory;
            this.startDocumentId = startDocumentId;
            this.uri = uri;
            this.sourceLocale = sourceLocale;
            this.encoding = encoding;
            this.lineBreak = lineBreak;
            this.filterWriter = filterWriter;
        }

        @Override
        public Event open() throws XMLStreamException, IOException {
            this.zipFile = new ZipFile(new File(this.uri.getPath()), 1);
            ZipInput.Stream zipInputStream = new ZipInput.Stream(this.zipFile);
            MimeType mimeType = new MimeType(zipInputStream);
            mimeType.from(this.zipFile.getEntry("mimetype"));
            if (!"application/vnd.adobe.indesign-idml-package".equals(mimeType.toString(this.encoding))) {
                throw new OkapiBadFilterInputException("IDML filter tried to initialise a file that is not supported.");
            }
            this.zipInputReader = new ZipInput.Reader(zipInputStream, this.encoding, this.inputFactory);
            this.designMapFragments = new DesignMapFragments.Default(this.parameters, this.eventFactory, this.zipFile, this.zipInputReader);
            this.designMapFragments.from(this.zipFile.getEntry("designmap.xml"));
            this.styleDefinitions = new StyleDefinitions.Default(new Markup.Default(new LinkedList<MarkupRange>()), this.zipInputReader, this.eventFactory);
            this.styleDefinitions.from(this.zipFile.getEntry(this.designMapFragments.stylesPartName()));
            this.translatablePartNames = this.designMapFragments.translatablePartNames();
            this.zipFileEntries = this.zipFileEntries();
            this.currentSubDocumentId = 0;
            return this.getStartDocumentEvent(this.uri, this.sourceLocale, this.filterWriter);
        }

        private Enumeration<? extends ZipEntry> zipFileEntries() throws IOException, XMLStreamException {
            ArrayList<? extends ZipEntry> entryList = Collections.list(this.zipFile.entries());
            entryList.sort(new ZipEntryComparator(this.designMapFragments.orderedPartNames()));
            return Collections.enumeration(entryList);
        }

        private Event getStartDocumentEvent(URI uri, LocaleId sourceLocale, IFilterWriter filterWriter) {
            StartDocument startDoc = new StartDocument(this.startDocumentId);
            startDoc.setName(uri.getPath());
            startDoc.setLocale(sourceLocale);
            startDoc.setMimeType("application/vnd.adobe.indesign-idml-package");
            startDoc.setFilterWriter(filterWriter);
            startDoc.setFilterId("okf_idml");
            startDoc.setFilterParameters(this.parameters);
            startDoc.setLineBreak(this.lineBreak);
            startDoc.setEncoding(this.encoding, false);
            ZipSkeleton skel = new ZipSkeleton(this.zipFile, null);
            return new Event(EventType.START_DOCUMENT, startDoc, skel);
        }

        @Override
        public boolean hasNextSubDocument() {
            return this.zipFileEntries.hasMoreElements();
        }

        @Override
        public SubDocument nextSubDocument() {
            ZipEntry zipEntry = this.zipFileEntries.nextElement();
            if (!this.isTranslatableSubDocument(zipEntry.getName())) {
                if (this.isStylesSubDocument(zipEntry.getName())) {
                    return new MarkupModifiableSubDocument(this.zipFile, zipEntry, this.outputFactory, this.encoding, this.styleDefinitions);
                }
                return new NonModifiableSubDocument(this.zipFile, zipEntry);
            }
            if ("designmap.xml".equals(zipEntry.getName())) {
                return new DesignMapSubDocument(this.parameters, this.eventFactory, this.zipFile, zipEntry, this.startDocumentId, String.valueOf(++this.currentSubDocumentId), this.designMapFragments.events());
            }
            return new StorySubDocument(this.parameters, this.eventFactory, this.zipFile, this.zipInputReader, zipEntry, this.startDocumentId, String.valueOf(++this.currentSubDocumentId));
        }

        private boolean isTranslatableSubDocument(String partName) {
            return this.translatablePartNames.contains(partName);
        }

        private boolean isStylesSubDocument(String entryName) {
            return this.designMapFragments.stylesPartName().equals(entryName);
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }

        private static class ZipEntryComparator
        implements Comparator<ZipEntry> {
            private final List<String> partNames;

            ZipEntryComparator(List<String> partNames) {
                this.partNames = partNames;
            }

            @Override
            public int compare(ZipEntry o1, ZipEntry o2) {
                int index1 = this.partNames.indexOf(o1.getName());
                int index2 = this.partNames.indexOf(o2.getName());
                if (index1 == -1) {
                    index1 = Integer.MAX_VALUE;
                }
                if (index2 == -1) {
                    index2 = Integer.MAX_VALUE;
                }
                return Integer.compare(index1, index2);
            }
        }
    }
}

