/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.abstractmarkup.config;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.htmlparser.jericho.StartTagType;
import net.htmlparser.jericho.Tag;
import net.sf.okapi.filters.abstractmarkup.config.IllegalConditionalAttributeException;
import net.sf.okapi.filters.abstractmarkup.config.YamlConfigurationReader;

public class TaggedFilterConfiguration {
    private static final String GLOBAL_PRESERVE_WHITESPACE = "preserve_whitespace";
    private static final String GLOBAL_EXCLUDE_BY_DEFAULT = "exclude_by_default";
    private static final String INLINE_CDATA = "inlineCdata";
    private static final String INLINE = "INLINE";
    private static final String INLINE_INCLUDED = "INLINE_INCLUDED";
    private static final String INLINE_EXCLUDED = "INLINE_EXCLUDED";
    private static final String GROUP = "GROUP";
    private static final String EXCLUDE = "EXCLUDE";
    private static final String INCLUDE = "INCLUDE";
    private static final String TEXTUNIT = "TEXTUNIT";
    private static final String SCRIPT = "SCRIPT";
    private static final String SERVER = "SERVER";
    private static final String ALL_ELEMENTS_EXCEPT = "allElementsExcept";
    private static final String ONLY_THESE_ELEMENTS = "onlyTheseElements";
    private static final String EQUALS = "EQUALS";
    private static final String NOT_EQUALS = "NOT_EQUALS";
    private static final String MATCHES = "MATCHES";
    private static final String ELEMENT_TYPE = "elementType";
    private static final String WELLFORMED = "assumeWellformed";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String GLOBAL_PCDATA_SUBFILTER = "global_pcdata_subfilter";
    private static final String GLOBAL_CDATA_SUBFILTER = "global_cdata_subfilter";
    private static final String CONDITIONS = "conditions";
    private static final String PRESERVE_CONDITION = "preserve";
    private static final String DEFAULT_CONDITION = "default";
    private static final String SIMPLIFIER_RULES = "simplifierRules";
    private static final String ATTRIBUTE_TRANSLATABLE_ATTRIBUTES = "ATTRIBUTE_TRANS";
    private static final String ATTRIBUTE_WRITABLE_ATTRIBUTES = "ATTRIBUTE_WRITABLE";
    private static final String ATTRIBUTE_READ_ONLY_ATTRIBUTES = "ATTRIBUTE_READONLY";
    private static final String ATTRIBUTE_ID_ATTRIBUTES = "ATTRIBUTE_ID";
    private static final String ELEMENT_TRANSLATABLE_ATTRIBUTES = "translatableAttributes";
    private static final String ELEMENT_WRITABLE_ATTRIBUTES = "writableLocalizableAttributes";
    private static final String ELEMENT_READ_ONLY_ATTRIBUTES = "readOnlyLocalizableAttributes";
    private static final String ELEMENT_ID_ATTRIBUTES = "idAttributes";
    public static final EnumSet<RULE_TYPE> ATTRIBUTE_ON_ELEMENT_RULES = EnumSet.of(RULE_TYPE.ELEMENT_ATTRIBUTE_TRANS, RULE_TYPE.ELEMENT_ATTRIBUTE_WRITABLE, RULE_TYPE.ELEMENT_ATTRIBUTE_READONLY, RULE_TYPE.ELEMENT_ATTRIBUTE_ID);
    public static final EnumSet<RULE_TYPE> INLINE_AND_EXCLUDE = EnumSet.of(RULE_TYPE.INLINE_ELEMENT, RULE_TYPE.EXCLUDED_ELEMENT);
    public static final EnumSet<RULE_TYPE> INLINE_AND_EXCLUDE_FAIL = EnumSet.of(RULE_TYPE.INLINE_ELEMENT_FAIL, RULE_TYPE.EXCLUDED_ELEMENT_FAIL);
    public static final EnumSet<RULE_TYPE> INLINE_AND_INCLUDE = EnumSet.of(RULE_TYPE.INLINE_ELEMENT, RULE_TYPE.INCLUDED_ELEMENT);
    public static final EnumSet<RULE_TYPE> INLINE_AND_INCLUDE_FAIL = EnumSet.of(RULE_TYPE.INLINE_ELEMENT_FAIL, RULE_TYPE.INCLUDED_ELEMENT_FAIL);
    public static final EnumSet<RULE_TYPE> FAILED = EnumSet.of(RULE_TYPE.INLINE_EXCLUDED_ELEMENT_FAIL, new RULE_TYPE[]{RULE_TYPE.INLINE_INCLUDED_ELEMENT_FAIL, RULE_TYPE.INLINE_ELEMENT_FAIL, RULE_TYPE.GROUP_ELEMENT_FAIL, RULE_TYPE.EXCLUDED_ELEMENT_FAIL, RULE_TYPE.INCLUDED_ELEMENT_FAIL, RULE_TYPE.TEXT_UNIT_ELEMENT_FAIL, RULE_TYPE.PRESERVE_WHITESPACE_FAIL});
    private final YamlConfigurationReader configReader;

    public TaggedFilterConfiguration() {
        this.configReader = new YamlConfigurationReader();
    }

    public TaggedFilterConfiguration(URL configurationPathAsResource) {
        this.configReader = new YamlConfigurationReader(configurationPathAsResource);
    }

    public TaggedFilterConfiguration(File configurationFile) {
        this.configReader = new YamlConfigurationReader(configurationFile);
    }

    public TaggedFilterConfiguration(String configurationScript) {
        this.configReader = new YamlConfigurationReader(configurationScript);
    }

    public YamlConfigurationReader getConfigReader() {
        return this.configReader;
    }

    public String toString() {
        return this.configReader.toString();
    }

    public boolean isGlobalPreserveWhitespace() {
        Boolean pw = (Boolean)this.configReader.getProperty(GLOBAL_PRESERVE_WHITESPACE);
        if (pw == null) {
            return true;
        }
        return pw;
    }

    public boolean isGlobalExcludeByDefault() {
        Boolean pw = (Boolean)this.configReader.getProperty(GLOBAL_EXCLUDE_BY_DEFAULT);
        if (pw == null) {
            return false;
        }
        return pw;
    }

    public boolean isWellformed() {
        Boolean wf = (Boolean)this.configReader.getProperty(WELLFORMED);
        if (wf == null) {
            return false;
        }
        return wf;
    }

    public boolean isInlineCdata() {
        Boolean ic = (Boolean)this.configReader.getProperty(INLINE_CDATA);
        if (ic == null) {
            return false;
        }
        return ic;
    }

    public boolean isUseCodeFinder() {
        Boolean useCF = (Boolean)this.configReader.getProperty(USECODEFINDER);
        if (useCF == null) {
            return false;
        }
        return useCF;
    }

    public boolean getBooleanParameter(String parameterName) {
        Boolean res = (Boolean)this.configReader.getProperty(parameterName);
        if (res == null) {
            return false;
        }
        return res;
    }

    public int getIntegerParameter(String parameterName) {
        Integer res = (Integer)this.configReader.getProperty(parameterName);
        if (res == null) {
            return -1;
        }
        return res;
    }

    public String getStringParameter(String parameterName) {
        return (String)this.configReader.getProperty(parameterName);
    }

    public String getGlobalPCDATASubfilter() {
        return (String)this.configReader.getProperty(GLOBAL_PCDATA_SUBFILTER);
    }

    public String getGlobalCDATASubfilter() {
        return (String)this.configReader.getProperty(GLOBAL_CDATA_SUBFILTER);
    }

    public String getCodeFinderRules() {
        return (String)this.configReader.getProperty(CODEFINDERRULES);
    }

    public String getElementType(Tag element) {
        if (element.getTagType() == StartTagType.COMMENT) {
            return "comment";
        }
        if (element.getTagType() == StartTagType.XML_PROCESSING_INSTRUCTION) {
            return "processing-instruction";
        }
        List<Map> rules = this.configReader.getElementRules(element.getName().toLowerCase());
        if (rules != null && !rules.isEmpty()) {
            for (Map r : rules) {
                if (!r.containsKey(ELEMENT_TYPE)) continue;
                return (String)r.get(ELEMENT_TYPE);
            }
        }
        return element.getName();
    }

    public EnumSet<RULE_TYPE> getAttributeRuleTypes(String attribute, String tag, Map<String, String> attributes) {
        String elementTag;
        List<Map> rules = this.configReader.getAttributeRules(attribute.toLowerCase());
        EnumSet<RULE_TYPE> types = EnumSet.noneOf(RULE_TYPE.class);
        String string = elementTag = tag == null ? "" : tag.toLowerCase();
        if (attributes == null || attributes.isEmpty()) {
            return this.getAttributeRuleTypes(attribute.toLowerCase(), elementTag);
        }
        if (rules != null && !rules.isEmpty()) {
            for (Map r : rules) {
                if (!this.doesAttributeRuleConditionApply(r, attributes) || this.doesElementFilterApply(elementTag, r)) continue;
                List ruleTypes = (List)r.get("ruleTypes");
                for (String t : ruleTypes) {
                    if (RULE_TYPE.toEnum(t) == RULE_TYPE.ATTRIBUTE_PRESERVE_WHITESPACE) {
                        List preserveWhiteSpace = (List)r.get(PRESERVE_CONDITION);
                        List defaultWhiteSpace = (List)r.get(DEFAULT_CONDITION);
                        if (preserveWhiteSpace != null && this.applyConditions(preserveWhiteSpace, attributes)) {
                            types.add(RULE_TYPE.ATTRIBUTE_PRESERVE_WHITESPACE);
                            continue;
                        }
                        if (defaultWhiteSpace == null || !this.applyConditions(defaultWhiteSpace, attributes)) continue;
                        types.add(RULE_TYPE.ATTRIBUTE_DEFAULT_WHITESPACE);
                        continue;
                    }
                    types.add(RULE_TYPE.toEnum(t));
                }
            }
            return types;
        }
        return types;
    }

    public EnumSet<RULE_TYPE> getAttributeRuleTypes(String attribute) {
        return this.getAttributeRuleTypes(attribute, null);
    }

    public EnumSet<RULE_TYPE> getAttributeRuleTypes(String attribute, String tag) {
        String elementTag;
        String lowerAttribute = attribute.toLowerCase();
        List<Map> rules = this.configReader.getAttributeRules(lowerAttribute);
        EnumSet<RULE_TYPE> types = EnumSet.noneOf(RULE_TYPE.class);
        String string = elementTag = tag == null ? "" : tag.toLowerCase();
        if (rules != null && !rules.isEmpty()) {
            for (Map r : rules) {
                if (r.get(CONDITIONS) != null || this.doesElementFilterApply(elementTag, r)) continue;
                List ruleTypes = (List)r.get("ruleTypes");
                for (String t : ruleTypes) {
                    if (RULE_TYPE.toEnum(t) == RULE_TYPE.ATTRIBUTE_PRESERVE_WHITESPACE) continue;
                    types.add(RULE_TYPE.toEnum(t));
                }
            }
            return types;
        }
        return types;
    }

    public EnumSet<RULE_TYPE> getAttributeOnElementRuleTypes(String tag, String attribute, Map<String, String> attributes) {
        List<Map> rules = this.configReader.getElementRules(tag.toLowerCase());
        EnumSet<RULE_TYPE> types = EnumSet.noneOf(RULE_TYPE.class);
        if (rules != null && !rules.isEmpty()) {
            for (Map r : rules) {
                if (!this.hasAttributeRules(r)) continue;
                for (RULE_TYPE a : ATTRIBUTE_ON_ELEMENT_RULES) {
                    if (!this.doesAttributeRuleOnElementRuleConditionApply(r, a.toString(), attribute, attributes)) continue;
                    types.add(a);
                }
            }
        }
        return types;
    }

    private boolean hasAttributeRules(Map r) {
        return r.containsKey(ELEMENT_TRANSLATABLE_ATTRIBUTES) || r.containsKey(ELEMENT_READ_ONLY_ATTRIBUTES) || r.containsKey(ELEMENT_WRITABLE_ATTRIBUTES) || r.containsKey(ELEMENT_ID_ATTRIBUTES);
    }

    public EnumSet<RULE_TYPE> getElementRuleTypes(String tag, Map<String, String> attributes, boolean isStartTag) {
        List<Map> rules = this.configReader.getElementRules(tag.toLowerCase());
        EnumSet<RULE_TYPE> types = EnumSet.noneOf(RULE_TYPE.class);
        if (rules != null && !rules.isEmpty()) {
            for (Map r : rules) {
                List ruleTypes = (List)r.get("ruleTypes");
                block11: for (String t : ruleTypes) {
                    RULE_TYPE rt = RULE_TYPE.toEnum(t);
                    boolean ruleApplied = true;
                    if (isStartTag) {
                        ruleApplied = this.doesElementRuleConditionApply(r, attributes);
                    }
                    switch (rt) {
                        case INLINE_EXCLUDED_ELEMENT: {
                            types.add(ruleApplied ? rt : RULE_TYPE.INLINE_EXCLUDED_ELEMENT_FAIL);
                            continue block11;
                        }
                        case INLINE_INCLUDED_ELEMENT: {
                            types.add(ruleApplied ? rt : RULE_TYPE.INLINE_INCLUDED_ELEMENT_FAIL);
                            continue block11;
                        }
                        case INLINE_ELEMENT: {
                            types.add(ruleApplied ? rt : RULE_TYPE.INLINE_ELEMENT_FAIL);
                            continue block11;
                        }
                        case GROUP_ELEMENT: {
                            types.add(ruleApplied ? rt : RULE_TYPE.GROUP_ELEMENT_FAIL);
                            continue block11;
                        }
                        case EXCLUDED_ELEMENT: {
                            types.add(ruleApplied ? rt : RULE_TYPE.EXCLUDED_ELEMENT_FAIL);
                            continue block11;
                        }
                        case INCLUDED_ELEMENT: {
                            types.add(ruleApplied ? rt : RULE_TYPE.INCLUDED_ELEMENT_FAIL);
                            continue block11;
                        }
                        case TEXT_UNIT_ELEMENT: {
                            types.add(ruleApplied ? rt : RULE_TYPE.TEXT_UNIT_ELEMENT_FAIL);
                            continue block11;
                        }
                        case PRESERVE_WHITESPACE: {
                            types.add(ruleApplied ? rt : RULE_TYPE.PRESERVE_WHITESPACE_FAIL);
                            continue block11;
                        }
                    }
                    if (!ruleApplied) continue;
                    types.add(rt);
                }
            }
            return types;
        }
        return types;
    }

    public EnumSet<RULE_TYPE> getElementRuleTypes(String tag, boolean isStartTag) {
        return this.getElementRuleTypes(tag, Collections.emptyMap(), isStartTag);
    }

    private boolean applyConditions(List condition, Map<String, String> attributes) {
        String conditionalAttribute = (String)condition.get(0);
        String compareType = (String)condition.get(1);
        if (condition.get(2) instanceof List) {
            List conditionValues = (List)condition.get(2);
            if (compareType.equalsIgnoreCase(NOT_EQUALS)) {
                for (String value : conditionValues) {
                    if (this.applyCondition(attributes.get(conditionalAttribute.toLowerCase()), compareType, value)) continue;
                    return false;
                }
                return true;
            }
            for (String value : conditionValues) {
                if (!this.applyCondition(attributes.get(conditionalAttribute.toLowerCase()), compareType, value)) continue;
                return true;
            }
        } else {
            if (condition.get(2) instanceof String) {
                String conditionValue = (String)condition.get(2);
                return this.applyCondition(attributes.get(conditionalAttribute.toLowerCase()), compareType, conditionValue);
            }
            throw new IllegalConditionalAttributeException("Error reading conditions. Have you quoted values such as 'true', 'false', 'yes', and 'no'?");
        }
        return false;
    }

    private boolean applyCondition(String attributeValue, String compareType, String conditionValue) {
        if (compareType.equalsIgnoreCase(EQUALS)) {
            return conditionValue.equalsIgnoreCase(attributeValue);
        }
        if (compareType.equalsIgnoreCase(NOT_EQUALS)) {
            return !conditionValue.equalsIgnoreCase(attributeValue);
        }
        if (compareType.equalsIgnoreCase(MATCHES)) {
            boolean result;
            if (attributeValue == null) {
                return false;
            }
            Pattern matchPattern = Pattern.compile(conditionValue);
            try {
                Matcher m = matchPattern.matcher(attributeValue);
                result = m.matches();
            }
            catch (PatternSyntaxException e) {
                throw new IllegalConditionalAttributeException(e);
            }
            return result;
        }
        throw new IllegalConditionalAttributeException(String.format("Unknown match type: %s", compareType));
    }

    public boolean doesElementRuleConditionApply(Map elementRule, Map<String, String> attributes) {
        if (elementRule == null) {
            return false;
        }
        List conditions = (List)elementRule.get(CONDITIONS);
        if (conditions != null) {
            return this.applyConditions(conditions, attributes);
        }
        return true;
    }

    private boolean doesAttributeRuleOnElementRuleConditionApply(Map elementRule, String attributeRuleName, String attribute, Map<String, String> attributes) {
        Map actionableAttributes;
        if (elementRule == null) {
            return false;
        }
        Object ta = elementRule.get(attributeRuleName);
        if (ta == null) {
            return false;
        }
        if (ta instanceof List) {
            List actionableAttributes2 = (List)elementRule.get(attributeRuleName);
            for (String a : actionableAttributes2) {
                if (!a.equalsIgnoreCase(attribute)) continue;
                return true;
            }
        } else if (ta instanceof Map && (actionableAttributes = (Map)elementRule.get(attributeRuleName)).containsKey(attribute.toLowerCase())) {
            List condition = (List)actionableAttributes.get(attribute.toLowerCase());
            if (condition == null) {
                return true;
            }
            if (condition.get(0) instanceof List) {
                for (int i = 0; i <= condition.size() - 1; ++i) {
                    List c = (List)condition.get(i);
                    if (!this.applyConditions(c, attributes)) continue;
                    return true;
                }
            } else if (this.applyConditions(condition, attributes)) {
                return true;
            }
        }
        return false;
    }

    private boolean doesAttributeRuleConditionApply(Map attributeRule, Map<String, String> attributes) {
        if (attributeRule == null) {
            return false;
        }
        List conditions = (List)attributeRule.get(CONDITIONS);
        if (conditions != null) {
            return this.applyConditions(conditions, attributes);
        }
        return true;
    }

    private boolean doesElementFilterApply(String tag, Map attributeRule) {
        List excludedElements = (List)attributeRule.get(ALL_ELEMENTS_EXCEPT);
        List onlyTheseElements = (List)attributeRule.get(ONLY_THESE_ELEMENTS);
        if (excludedElements == null && onlyTheseElements == null) {
            return false;
        }
        if (excludedElements != null) {
            for (int i = 0; i <= excludedElements.size() - 1; ++i) {
                String elem = (String)excludedElements.get(i);
                if (!elem.equalsIgnoreCase(tag)) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i <= onlyTheseElements.size() - 1; ++i) {
            String elem = (String)onlyTheseElements.get(i);
            if (!elem.equalsIgnoreCase(tag)) continue;
            return false;
        }
        return true;
    }

    public boolean isTranslatableAttribute(String tag, String attribute, Map<String, String> attributes) {
        EnumSet<RULE_TYPE> ruleTypes = this.getAttributeRuleTypes(attribute, tag, attributes);
        ruleTypes.addAll(this.getAttributeOnElementRuleTypes(tag, attribute, attributes));
        return ruleTypes.contains((Object)RULE_TYPE.ATTRIBUTE_TRANS) || ruleTypes.contains((Object)RULE_TYPE.ELEMENT_ATTRIBUTE_TRANS);
    }

    public boolean isReadOnlyLocalizableAttribute(String tag, String attribute, Map<String, String> attributes) {
        EnumSet<RULE_TYPE> ruleTypes = this.getAttributeRuleTypes(attribute, tag, attributes);
        ruleTypes.addAll(this.getAttributeOnElementRuleTypes(tag, attribute, attributes));
        return ruleTypes.contains((Object)RULE_TYPE.ATTRIBUTE_READONLY) || ruleTypes.contains((Object)RULE_TYPE.ELEMENT_ATTRIBUTE_READONLY);
    }

    public boolean isWritableLocalizableAttribute(String tag, String attribute, Map<String, String> attributes) {
        EnumSet<RULE_TYPE> ruleTypes = this.getAttributeRuleTypes(attribute, tag, attributes);
        ruleTypes.addAll(this.getAttributeOnElementRuleTypes(tag, attribute, attributes));
        return ruleTypes.contains((Object)RULE_TYPE.ATTRIBUTE_WRITABLE) || ruleTypes.contains((Object)RULE_TYPE.ELEMENT_ATTRIBUTE_WRITABLE);
    }

    public boolean isIdAttribute(String tag, String attribute, Map<String, String> attributes) {
        EnumSet<RULE_TYPE> ruleTypes = this.getAttributeRuleTypes(attribute, tag, attributes);
        ruleTypes.addAll(this.getAttributeOnElementRuleTypes(tag, attribute, attributes));
        return ruleTypes.contains((Object)RULE_TYPE.ATTRIBUTE_ID) || ruleTypes.contains((Object)RULE_TYPE.ELEMENT_ATTRIBUTE_ID);
    }

    public boolean isPreserveWhitespaceCondition(String attribute, Map<String, String> attributes) {
        List<Map> attributeRules = this.configReader.getAttributeRules(attribute);
        for (Map r : attributeRules) {
            List preserveWhiteSpace;
            if (!this.doesAttributeRuleConditionApply(r, attributes) || (preserveWhiteSpace = (List)r.get(PRESERVE_CONDITION)) == null) continue;
            return this.applyConditions(preserveWhiteSpace, attributes);
        }
        return false;
    }

    public boolean isDefaultWhitespaceCondition(String attribute, Map<String, String> attributes) {
        List<Map> attributeRules = this.configReader.getAttributeRules(attribute);
        for (Map r : attributeRules) {
            List defaultWhiteSpace;
            if (!this.doesAttributeRuleConditionApply(r, attributes) || (defaultWhiteSpace = (List)r.get(DEFAULT_CONDITION)) == null) continue;
            return this.applyConditions(defaultWhiteSpace, attributes);
        }
        return false;
    }

    public String getElementType(String elementName) {
        List<Map> rules = this.configReader.getElementRules(elementName.toLowerCase());
        for (Map r : rules) {
            if (r == null || !r.containsKey(ELEMENT_TYPE)) continue;
            return (String)r.get(ELEMENT_TYPE);
        }
        return elementName;
    }

    public String getSimplifierRules() {
        return (String)this.configReader.getProperty(SIMPLIFIER_RULES);
    }

    public void setSimplifierRules(String rules) {
        this.configReader.addProperty(SIMPLIFIER_RULES, rules);
    }

    public boolean getQuoteModeDefined() {
        Boolean res = (Boolean)this.configReader.getProperty("quoteModeDefined");
        if (res == null) {
            return false;
        }
        return res;
    }

    public void setQuoteModeDefined(boolean defined) {
        this.configReader.addProperty("quoteModeDefined", defined);
    }

    public int getQuoteMode() {
        Integer res = (Integer)this.configReader.getProperty("quoteMode");
        if (res == null) {
            return 2;
        }
        return res;
    }

    public void setQuoteMode(String quoteMode) {
        this.configReader.addProperty("quoteMode", quoteMode);
    }

    public static enum RULE_TYPE {
        INLINE_ELEMENT("INLINE"),
        INLINE_ELEMENT_FAIL("INLINE_ELEMENT_FAIL"),
        INLINE_EXCLUDED_ELEMENT("INLINE_EXCLUDED"),
        INLINE_EXCLUDED_ELEMENT_FAIL("INLINE_EXCLUDED_ELEMENT_FAIL"),
        INLINE_INCLUDED_ELEMENT("INLINE_INCLUDED"),
        INLINE_INCLUDED_ELEMENT_FAIL("INLINE_INCLUDED_ELEMENT_FAIL"),
        EXCLUDED_ELEMENT("EXCLUDE"),
        EXCLUDED_ELEMENT_FAIL("EXCLUDED_ELEMENT_FAIL"),
        INCLUDED_ELEMENT("INCLUDE"),
        INCLUDED_ELEMENT_FAIL("INCLUDED_ELEMENT_FAIL"),
        GROUP_ELEMENT("GROUP"),
        GROUP_ELEMENT_FAIL("GROUP_ELEMENT_FAIL"),
        TEXT_UNIT_ELEMENT("TEXTUNIT"),
        TEXT_UNIT_ELEMENT_FAIL("TEXT_UNIT_ELEMENT_FAIL"),
        PRESERVE_WHITESPACE("PRESERVE_WHITESPACE"),
        PRESERVE_WHITESPACE_FAIL("PRESERVE_WHITESPACE_FAIL"),
        SCRIPT_ELEMENT("SCRIPT"),
        SERVER_ELEMENT("SERVER"),
        ATTRIBUTE_TRANS("ATTRIBUTE_TRANS"),
        ATTRIBUTE_WRITABLE("ATTRIBUTE_WRITABLE"),
        ATTRIBUTE_READONLY("ATTRIBUTE_READONLY"),
        ATTRIBUTE_ID("ATTRIBUTE_ID"),
        ELEMENT_ATTRIBUTE_TRANS("translatableAttributes"),
        ELEMENT_ATTRIBUTE_WRITABLE("writableLocalizableAttributes"),
        ELEMENT_ATTRIBUTE_READONLY("readOnlyLocalizableAttributes"),
        ELEMENT_ATTRIBUTE_ID("idAttributes"),
        ATTRIBUTE_PRESERVE_WHITESPACE("ATTRIBUTE_PRESERVE_WHITESPACE"),
        ATTRIBUTE_DEFAULT_WHITESPACE("ATTRIBUTE_DEFAULT_WHITESPACE"),
        ATTRIBUTES_ONLY("ATTRIBUTES_ONLY"),
        RULE_NOT_FOUND("RULE_NOT_FOUND");

        private final String name;

        private RULE_TYPE(String s) {
            this.name = s;
        }

        public static RULE_TYPE toEnum(String value) {
            for (RULE_TYPE v : RULE_TYPE.values()) {
                if (!v.equalsName(value)) continue;
                return v;
            }
            throw new IllegalArgumentException();
        }

        public boolean equalsName(String otherName) {
            return this.name.equalsIgnoreCase(otherName);
        }

        public String toString() {
            return this.name;
        }
    }
}

