/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.mymemory;

import com.ibm.icu.util.ULocale;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.mymemory.Parameters;
import net.sf.okapi.lib.translation.BaseConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.lib.translation.QueryUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class MyMemoryTMConnector
extends BaseConnector
implements ITMQuery {
    private static final String BASE_URL = "https://api.mymemory.translated.net";
    private static final String BASE_QUERY = "/get?q=%s&langpair=%s|%s";
    public static final SimpleDateFormat sdfShort = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat sdfLong = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final List<QueryResult> results;
    private final QueryUtil qutil;
    private final JSONParser parser;
    private int current = -1;
    private int maxHits = 25;
    private int threshold = 75;
    private Parameters params = new Parameters();

    public MyMemoryTMConnector() {
        this.qutil = new QueryUtil();
        this.parser = new JSONParser();
        this.results = new ArrayList<QueryResult>();
    }

    @Override
    public String getName() {
        return "MyMemory";
    }

    @Override
    public String getSettingsDisplay() {
        return "Server: https://api.mymemory.translated.net\nAllow MT: " + (this.params.getUseMT() ? "Yes" : "No") + "\nKey: " + (Util.isEmpty(this.params.getKey()) ? "None" : this.params.getKey()) + "\nEmail: " + (Util.isEmpty(this.params.getEmail()) ? "None" : this.params.getEmail());
    }

    @Override
    public void close() {
    }

    @Override
    public boolean hasNext() {
        if (this.current >= this.results.size()) {
            this.current = -1;
        }
        return this.current > -1;
    }

    @Override
    public QueryResult next() {
        if (this.current > -1 && this.current < this.results.size()) {
            ++this.current;
            return this.results.get(this.current - 1);
        }
        this.current = -1;
        return null;
    }

    @Override
    public void open() {
    }

    @Override
    public int query(TextFragment frag) {
        this.results.clear();
        this.current = -1;
        if (!frag.hasText(false)) {
            return 0;
        }
        try {
            JSONObject objResponse;
            StringBuilder urlBuilder = new StringBuilder(BASE_URL);
            String text = this.qutil.separateCodesFromText(frag);
            urlBuilder.append(String.format(BASE_QUERY, URLEncoder.encode(text, StandardCharsets.UTF_8.name()), this.srcCode, this.trgCode));
            urlBuilder.append("&numres=").append(this.maxHits);
            if (!this.params.getUseMT()) {
                urlBuilder.append("&mt=0");
            }
            if (!Util.isEmpty(this.params.getKey())) {
                urlBuilder.append("&key=").append(URLEncoder.encode(this.params.getKey(), StandardCharsets.UTF_8.name()));
            }
            if (!Util.isEmpty(this.params.getEmail())) {
                urlBuilder.append("&de=").append(URLEncoder.encode(this.params.getEmail(), StandardCharsets.UTF_8.name()));
            }
            URL url = new URL(urlBuilder.toString());
            try (InputStreamReader reader = new InputStreamReader(url.openConnection().getInputStream(), StandardCharsets.UTF_8);){
                objResponse = (JSONObject)this.parser.parse((Reader)reader);
            }
            if (!objResponse.get((Object)"responseStatus").equals(200L)) {
                throw new OkapiException(objResponse.get((Object)"responseDetails").toString());
            }
            if (!(objResponse.get((Object)"matches") instanceof JSONArray)) {
                throw new OkapiException("Unexpected response (no results array)");
            }
            JSONArray matches = (JSONArray)objResponse.get((Object)"matches");
            for (Object m : matches) {
                JSONObject match = (JSONObject)m;
                QueryResult res = new QueryResult();
                int score = (int)(((Number)match.get((Object)"match")).doubleValue() * 100.0);
                if (this.qutil.hasCode()) {
                    --score;
                }
                if (score < this.getThreshold()) break;
                String from = (String)match.get((Object)"last-updated-by");
                if (from == null && (from = (String)match.get((Object)"created-by")) == null) {
                    from = "";
                }
                res.matchType = from.equals("MT!") ? MatchType.MT : MatchType.FUZZY;
                String dateString = match.get((Object)"create-date").toString();
                try {
                    res.creationDate = sdfLong.parse(dateString);
                }
                catch (ParseException e1) {
                    try {
                        res.creationDate = sdfShort.parse(dateString);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                res.weight = this.getWeight();
                res.origin = this.getName();
                res.setFuzzyScore(score);
                if (this.qutil.hasCode()) {
                    res.source = this.qutil.createNewFragmentWithCodes((String)match.get((Object)"segment"));
                    res.target = this.qutil.createNewFragmentWithCodes((String)match.get((Object)"translation"));
                } else {
                    res.source = new TextFragment((String)match.get((Object)"segment"));
                    res.target = new TextFragment((String)match.get((Object)"translation"));
                }
                this.results.add(res);
            }
            this.current = 0;
        }
        catch (Throwable e) {
            if (!(e instanceof OkapiException)) {
                throw new OkapiException("Error querying the server: " + e.getMessage(), e);
            }
            throw (OkapiException)e;
        }
        if (this.results.size() > 0) {
            this.current = 0;
        }
        return this.results.size();
    }

    @Override
    public int query(String plainText) {
        return this.query(new TextFragment(plainText));
    }

    @Override
    public List<List<QueryResult>> batchQuery(List<TextFragment> fragments) {
        throw new OkapiNotImplementedException();
    }

    @Override
    protected String toInternalCode(LocaleId locale) {
        String lang = locale.getLanguage();
        String reg = locale.getRegion();
        if (reg == null || reg.isEmpty()) {
            ULocale fullLocale = ULocale.addLikelySubtags((ULocale)locale.toIcuLocale());
            reg = fullLocale.getCountry().toLowerCase(Locale.US);
        }
        return lang + "-" + reg;
    }

    @Override
    public void setMaximumHits(int max) {
        this.maxHits = max < 1 ? 1 : max;
    }

    @Override
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public int getMaximumHits() {
        return this.maxHits;
    }

    @Override
    public int getThreshold() {
        return this.threshold;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setRootDirectory(String rootDir) {
    }
}

