/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;

public class XLIFFContextGroup
implements IAnnotation,
Iterable<Context> {
    public static final String ELEMENT_NAME = "context-group";
    public static final String NAME = "name";
    public static final String PURPOSE = "purpose";
    public static final String CRC = "crc";
    private final EncoderManager encoderManager;
    private final String name;
    private final String purpose;
    private final String crc;
    private final List<Context> contexts;
    private String endElementPrependingText;

    public XLIFFContextGroup(EncoderManager encoderManager, String name, String purpose, String crc, List<Context> contexts) {
        this.encoderManager = encoderManager;
        this.name = name;
        this.purpose = purpose;
        this.crc = crc;
        this.contexts = contexts;
    }

    public String name() {
        return this.name;
    }

    public String purpose() {
        return this.purpose;
    }

    public String crc() {
        return this.crc;
    }

    @Override
    public Iterator<Context> iterator() {
        return this.contexts.iterator();
    }

    public void addContext(Context context) {
        this.contexts.add(context);
    }

    public void readWith(XMLStreamReader streamReader) throws XMLStreamException {
        StringBuilder prependingText = new StringBuilder();
        while (streamReader.hasNext()) {
            int eventType = streamReader.next();
            switch (eventType) {
                case 1: {
                    if ("context".equals(streamReader.getLocalName())) {
                        Context context = new Context(this.encoderManager, streamReader.getAttributeValue(null, "context-type"), streamReader.getAttributeValue(null, "match-mandatory"), streamReader.getAttributeValue(null, CRC));
                        context.readWith(streamReader);
                        context.prependingText(prependingText.toString());
                        prependingText = new StringBuilder();
                        this.addContext(context);
                        break;
                    }
                    throw new OkapiIOException("Unexpected element: ".concat(streamReader.getLocalName()));
                }
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    prependingText.append(streamReader.getText());
                    break;
                }
                case 2: {
                    if (ELEMENT_NAME.equals(streamReader.getLocalName())) {
                        this.endElementPrependingText = prependingText.toString();
                        return;
                    }
                    throw new OkapiIOException("Unexpected element: ".concat(streamReader.getLocalName()));
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(ELEMENT_NAME);
        if (null != this.name || null != this.purpose || null != this.crc) {
            this.appendAttributes(sb);
        }
        sb.append(">");
        for (Context context : this.contexts) {
            sb.append(context.toString());
        }
        if (null != this.endElementPrependingText) {
            sb.append(this.endElementPrependingText);
        }
        sb.append("</");
        sb.append(ELEMENT_NAME);
        sb.append(">");
        return sb.toString();
    }

    private void appendAttributes(StringBuilder sb) {
        if (null != this.name) {
            sb.append(" ");
            this.appendAttribute(sb, NAME, this.name);
        }
        if (null != this.purpose) {
            sb.append(" ");
            this.appendAttribute(sb, PURPOSE, this.purpose);
        }
        if (null != this.crc) {
            sb.append(" ");
            this.appendAttribute(sb, CRC, this.crc);
        }
    }

    private void appendAttribute(StringBuilder sb, String name, String value) {
        sb.append(name);
        sb.append("=");
        sb.append("\"");
        sb.append(XLIFFContextGroup.encode(this.encoderManager, value, EncoderContext.INLINE));
        sb.append("\"");
    }

    private static String encode(EncoderManager encoder, String value, EncoderContext context) {
        return encoder != null ? encoder.encode(value, context) : value;
    }

    public static class Context {
        public static final String ELEMENT_NAME = "context";
        public static final String TYPE = "context-type";
        public static final String MATCH_MANDATORY = "match-mandatory";
        public static final String CRC = "crc";
        private final EncoderManager encoderManager;
        private final String type;
        private final String matchMandatory;
        private final String crc;
        private String value;
        private String prependingText;

        public Context(EncoderManager encoderManager, String type, String matchMandatory, String crc) {
            this.encoderManager = encoderManager;
            this.type = type;
            this.matchMandatory = matchMandatory;
            this.crc = crc;
        }

        public String type() {
            return this.type;
        }

        public String matchMandatory() {
            return this.matchMandatory;
        }

        public String crc() {
            return this.crc;
        }

        public String value() {
            return this.value;
        }

        public void value(String value) {
            this.value = value;
        }

        public void prependingText(String prependingText) {
            this.prependingText = prependingText;
        }

        public void readWith(XMLStreamReader streamReader) throws XMLStreamException {
            StringBuilder sb = new StringBuilder();
            while (streamReader.hasNext()) {
                int eventType = streamReader.next();
                switch (eventType) {
                    case 4: 
                    case 6: 
                    case 12: {
                        sb.append(streamReader.getText());
                        break;
                    }
                    case 1: {
                        throw new OkapiIOException("Unexpected element: ".concat(streamReader.getLocalName()));
                    }
                    case 2: {
                        if (ELEMENT_NAME.equals(streamReader.getLocalName())) {
                            this.value(sb.toString());
                            return;
                        }
                        throw new OkapiIOException("Unexpected element: ".concat(streamReader.getLocalName()));
                    }
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (null != this.prependingText) {
                sb.append(this.prependingText);
            }
            sb.append("<");
            sb.append(ELEMENT_NAME);
            this.appendAttributes(sb);
            sb.append(">");
            if (null != this.value) {
                sb.append(XLIFFContextGroup.encode(this.encoderManager, this.value, EncoderContext.TEXT));
            }
            sb.append("</");
            sb.append(ELEMENT_NAME);
            sb.append(">");
            return sb.toString();
        }

        private void appendAttributes(StringBuilder sb) {
            Object type;
            block4: {
                sb.append(" ");
                type = this.type;
                try {
                    StandardContextTypes.valueOf(this.type);
                }
                catch (IllegalArgumentException e) {
                    if (this.type.startsWith("x-")) break block4;
                    type = "x-" + this.type;
                }
            }
            this.appendAttribute(sb, TYPE, (String)type);
            if (null != this.matchMandatory) {
                sb.append(" ");
                this.appendAttribute(sb, MATCH_MANDATORY, this.matchMandatory);
            }
            if (null != this.crc) {
                sb.append(" ");
                this.appendAttribute(sb, "crc", this.crc);
            }
        }

        private void appendAttribute(StringBuilder sb, String name, String value) {
            sb.append(name);
            sb.append("=");
            sb.append("\"");
            sb.append(XLIFFContextGroup.encode(this.encoderManager, value, EncoderContext.INLINE));
            sb.append("\"");
        }

        public static enum StandardContextTypes {
            database,
            element,
            elementtitle,
            linenumber,
            numparams,
            paramnotes,
            record,
            recordtitle,
            sourcefile;

        }
    }
}

