/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.LinkedHashMap;
import net.sf.okapi.common.Base64;
import net.sf.okapi.common.exceptions.OkapiException;

public class ParametersString {
    private LinkedHashMap<String, Object> list = new LinkedHashMap();

    public ParametersString() {
    }

    public ParametersString(String data) {
        this.buildList(null, data);
    }

    public String toString() {
        return this.buildString(null);
    }

    public void fromString(String data) {
        this.fromString(data, true);
    }

    public void fromString(String data, boolean clearBuffer) {
        if (clearBuffer) {
            this.list.clear();
        }
        this.buildList(null, data);
    }

    public void fromParametersString(ParametersString parametersString) {
        this.fromParametersString(parametersString, true);
    }

    public void fromParametersString(ParametersString parametersString, boolean clearBuffer) {
        if (clearBuffer) {
            this.list.clear();
        }
        this.list.putAll(parametersString.list);
    }

    public void reset() {
        this.list.clear();
    }

    public void remove(String name) {
        if (this.list.containsKey(name)) {
            this.list.remove(name);
        }
    }

    public void removeGroup(String groupName) {
        groupName = (String)groupName + ".";
        for (String key : this.list.keySet()) {
            if (!key.startsWith((String)groupName)) continue;
            this.list.remove(key);
        }
    }

    private String escape(String value) {
        if (value == null) {
            return value;
        }
        value = value.replace("\r", "$0d$");
        return value.replace("\n", "$0a$");
    }

    private String unescape(String value) {
        if (value == null) {
            return value;
        }
        value = value.replace("$0d$", "\r");
        return value.replace("$0a$", "\n");
    }

    private String buildString(String prefix) {
        StringBuilder tmp = new StringBuilder("#v1");
        if (prefix != null) {
            prefix = (String)prefix + ".";
        }
        for (String key : this.list.keySet()) {
            if (prefix != null) {
                if (!key.startsWith((String)prefix)) continue;
                tmp.append("\n" + key.substring(((String)prefix).length()));
            } else {
                tmp.append("\n" + key);
            }
            Object value = this.list.get(key);
            if (value instanceof String) {
                tmp.append("=" + this.escape((String)value));
                continue;
            }
            if (value instanceof Integer) {
                tmp.append(".i=" + value);
                continue;
            }
            if (value instanceof Boolean) {
                tmp.append(".b=" + ((Boolean)value != false ? "true" : "false"));
                continue;
            }
            throw new OkapiException("Invalide type: " + key);
        }
        if (tmp.length() == 3) {
            tmp.setLength(0);
        }
        return tmp.toString();
    }

    private void buildList(String prefix, String data) {
        String[] lines;
        prefix = prefix == null ? "" : (String)prefix + ".";
        if (data == null) {
            data = "";
        }
        for (String line : lines = data.split("\n", 0)) {
            String key;
            int n;
            if (line.trim().length() == 0 || line.charAt(0) == '#' || (n = line.indexOf(61)) == -1) continue;
            String qualifiedName = line.substring(0, n).trim();
            String trimmedValue = line.substring(n + 1).trim();
            if (qualifiedName.endsWith(".b")) {
                key = (String)prefix + qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
                this.list.put(key, "true".equals(trimmedValue));
                continue;
            }
            if (qualifiedName.endsWith(".i")) {
                key = (String)prefix + qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
                this.list.put(key, Integer.valueOf(trimmedValue));
                continue;
            }
            key = (String)prefix + qualifiedName;
            this.list.put(key, this.unescape(line.substring(n + 1)));
        }
    }

    public String getGroup(String name, String defaultValue) {
        String tmp = this.buildString(name);
        if (tmp.length() > 0) {
            return tmp;
        }
        return defaultValue;
    }

    public String getGroup(String name) {
        return this.buildString(name);
    }

    public void setGroup(String name, String data) {
        this.buildList(name, data);
    }

    public void setGroup(String name, ParametersString params) {
        name = name == null ? "" : (String)name + ".";
        for (String key : params.list.keySet()) {
            this.list.put((String)name + key, params.list.get(key));
        }
    }

    public String getString(String name, String defaultValue) {
        return (String)this.getOrDefault(name, defaultValue);
    }

    public String getString(String name) {
        return this.getString(name, "");
    }

    public void setString(String name, String value) {
        if (value == null) {
            this.list.remove(name);
        } else {
            this.list.put(name, value);
        }
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return (Boolean)this.getOrDefault(name, defaultValue);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public void setBoolean(String name, boolean value) {
        this.list.put(name, value);
    }

    public int getInteger(String name, int defaultValue) {
        return (Integer)this.getOrDefault(name, defaultValue);
    }

    public int getInteger(String name) {
        return this.getInteger(name, 0);
    }

    public void setInteger(String name, int value) {
        this.list.put(name, value);
    }

    public void setParameter(String name, String value) {
        this.setString(name, value);
    }

    public void setParameter(String name, boolean value) {
        this.setBoolean(name, value);
    }

    public void setParameter(String name, int value) {
        this.setInteger(name, value);
    }

    private Object getOrDefault(String name, Object defaultValue) {
        Object o = this.list.get(name);
        if (o != null) {
            return o;
        }
        return defaultValue;
    }

    public String getEncodedString(String name, String defaultValue) {
        return Base64.decodePassword(this.getString(name, defaultValue));
    }

    public void setEncodedString(String name, String value) {
        if (value == null) {
            this.list.remove(name);
        } else {
            this.list.put(name, Base64.encodePassword(value));
        }
    }
}

