/*===========================================================================
  Copyright (C) 2008-2013 by the Okapi Framework contributors
-----------------------------------------------------------------------------
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
===========================================================================*/

package net.sf.okapi.lib.preprocessing.filters.simplification;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(Parameters.class)
public class Parameters extends StringParameters implements IEditorDescriptionProvider {
	private static final String FILTERCONFIGID = "filterConfigId";
	private static final String SIMPLIFYRESOURCES = "simplifyResources";
	private static final String SIMPLIFYCODES = "simplifyCodes";
	
	public Parameters() {
		super();
	}
	
	@Override
	public void reset() {
		super.reset();
		setFilterConfigId("okf_xmlstream");
		setSimplifyResources(true);
		setSimplifyCodes(false);
	}

	public String getFilterConfigId() {
		return getString(FILTERCONFIGID);
	}

	public void setFilterConfigId(String filterConfigId) {
		setString(FILTERCONFIGID, filterConfigId);
	}

	public boolean isSimplifyResources() {
		return getBoolean(SIMPLIFYRESOURCES);
	}

	public void setSimplifyResources(boolean simplifyResources) {
		setBoolean(SIMPLIFYRESOURCES, simplifyResources);
	}

	public boolean isSimplifyCodes() {
		return getBoolean(SIMPLIFYCODES);
	}

	public void setSimplifyCodes(boolean simplifyCodes) {
		setBoolean(SIMPLIFYCODES, simplifyCodes);
	}
	
	@Override
	public ParametersDescription getParametersDescription() {
		ParametersDescription desc = new ParametersDescription(this);
		desc.add("filterConfigId", "Filter configuration ID", null);
		desc.add("simplifyResources", "Simplify resources", "Simplify resources generated by the filter removing references in resources (resource flattening)");
		desc.add("simplifyCodes", "Simplify codes", "Merge adjacent inline codes in the source part of a text unit, moves leading and trailing codes to the skeleton");
		return desc;
	}
	
	@Override
	public EditorDescription createEditorDescription(
			ParametersDescription parametersDescription) {
		EditorDescription desc = new EditorDescription("Simplification Filter Parameters", true, false);
		
		desc.addTextInputPart(parametersDescription.get("filterConfigId"));
		desc.addCheckboxPart(parametersDescription.get("simplifyResources"));
		desc.addCheckboxPart(parametersDescription.get("simplifyCodes"));
		
		return desc;
	}

}
