/* YamlParserTokenManager.java */
/* Generated By:JavaCC: Do not edit this line. YamlParserTokenManager.java */
package net.sf.okapi.filters.yaml.parser;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Util;

/** Token Manager. */
public class YamlParserTokenManager implements YamlParserConstants {
   // should be enough even for very large files
        static final int MAX_INDENTS = 1000;
        // make first column 0 so that DASH and keys at column 1 produce an "indentation"
        static final int FIRST_COLUMN = 0;

        /** The stack of indent levels (column numbers) */
        int[] indentStack = new int[MAX_INDENTS];
        int[] indentTokenTypes = new int[MAX_INDENTS];
        // current indent pointer
        int sp = 0;
        int pendingDedents = 0;
        Token lastToken;
    int flowSequenceNesting = 0;
        int flowMappingeNesting = 0;
        boolean linestart = false;
        IYamlHandler handler = null;

        // special tokens collected at the end of an indented block
        List<Token> endIndentedSpecial;

        void reset() {
                indentStack = new int[MAX_INDENTS];
                indentTokenTypes = new int[MAX_INDENTS];
                // current indent pointer
                sp = 0;
                pendingDedents = 0;
                lastToken = null;
            flowSequenceNesting = 0;
                flowMappingeNesting = 0;
                linestart = false;

                // special tokens collected at the end of an indented block
                endIndentedSpecial = null;

                indentStack[sp] = FIRST_COLUMN;
                indentTokenTypes[sp] = -1;
                curLexState = DEFAULT;
        }

        void CommonTokenAction(Token currentToken) {
                int tokenSize = currentToken.image.length();
                int currentColumn = currentToken.beginColumn;

            // turn off indent logic for these tokens
                if (ignoreIndent(currentToken.kind)) {
                        return;
                }

                // handle pending dedents on each pass until done
                if (pendingDedents > 0) {
                        handlePendingDedent(currentToken);
                        return;
                }

                // if this is the resent token then just return it
                if (currentToken.kind != EOF && lastToken != null
                                && lastToken.beginColumn == currentToken.beginColumn
                                && lastToken.beginLine == currentToken.beginLine) {
                        return;
                }

                int lastLine = (lastToken == null) ? 0 : lastToken.endLine;
                int currentLine = currentToken.beginLine;
                // We are on the same line, so no indent/dedent here, so just return.
                // except for KEY or DASH tokens as they can be on the same line as a DASH but require
                // an "indent" sent to the parser
                if (currentToken.kind != EOF && currentLine == lastLine &&
                        !isBlockKey(currentToken.kind) && currentToken.kind != DASH) {
                        lastToken = currentToken;
                        return;
                }

        if (currentToken.kind == EOF && currentToken.specialToken != null) {
            endIndentedSpecial = getSpecialTokensBefore(currentToken);
        }

                // check for dedents
                if (unwindIndent(currentToken)) {
                        lastToken = currentToken;
                        return;
                }

                // handle block indentation tokens
                if (currentToken.kind == DASH || isBlockKey(currentToken.kind)) {
                        if (peekIndent() < currentColumn) {
                                // adjust indent of key was labled with tag - use the tag indent
                                if (lastTokenWasTag(lastToken) && lastToken.beginLine == currentToken.beginLine) {
                                        push(lastToken.beginColumn, currentToken.kind);
                                } else {
                                        push(currentColumn, currentToken.kind);
                                }
                                if (currentToken.kind == DASH && !isIndentlessBlock(currentToken)) {
                                        backup(tokenSize);
                                        currentToken.kind = BLOCK_SEQUENCE_START;
                                        currentToken.image = "BLOCK_SEQUENCE_START";
                                } else if (isBlockKey(currentToken.kind)) {
                                        backup(tokenSize);
                                        currentToken.kind = BLOCK_MAPPING_START;
                                        currentToken.image = "BLOCK_MAPPING_START";
                                }
                        }
                } else if (peekType() == DASH && isBlockKey(currentToken.kind) &&
                        currentLine == lastLine) {
                        // special case where a key follows a DASH on the same line
                        push(currentColumn, currentToken.kind);
                        backup(tokenSize);
                        currentToken.kind = BLOCK_MAPPING_START;
                        currentToken.image = "BLOCK_MAPPING_START";

                } else if (peekType() == DASH && currentToken.kind == DASH &&
                        currentLine == lastLine) {
                        // special case where a DASH follows a DASH on the same line
                        backup(tokenSize);
                        currentToken.kind = BLOCK_SEQUENCE_START;
                        currentToken.image = "BLOCK_SEQUENCE_START";
                }
                lastToken = currentToken;
        }

        public void initialize(IYamlHandler h) {
                reset();
                handler = h;
        }

        public boolean lastTokenWasTag(Token t) {
                if (t == null) return false;
                if (t.kind == TAG) return true;
                return false;
        }

        private boolean isIndentlessBlock(Token indentCandidate)
        {
                if (indentCandidate.kind == DASH)
                {
                        if(peekIndent() == FIRST_COLUMN ||
                                (isBlockKey(peekType()) && peekIndent() == indentCandidate.beginColumn))
                        {
                                return true;
                        }
                }
                return false;
        }

        public boolean isBlockKey(int kind) {
          switch(curLexState) {
            case FLOW:
                return false;
          }

      switch(kind) {
        case PLAIN_KEY:
        case SINGLE_QUOTED_KEY:
        case DOUBLE_QUOTED_KEY:
            return true;
      }
      return false;
        }

    public boolean ignoreIndent(int kind) {
        switch(curLexState) {
                case FLOW:
                                return true;
                }

      switch(kind) {
        case PLAIN_SCALAR_INDENTED:
        case LITERAL_FOLDED_INDENTED:
        case NULL_SCALAR:
        case SINGLE_QUOTED_EMPTY:
        case DOUBLE_QUOTED_EMPTY:
        case SINGLE_QUOTED_FIRST:
        case DOUBLE_QUOTED_FIRST:
        case STRING_DOUBLE_BODY_SECOND:
        case STRING_SINGLE_BODY_SECOND:
        case QUOTE_SINGLE_END:
        case QUOTE_DOUBLE_END:
        case CONTINUATION_START:
        case CONTINUATION_END:
            return true;
      }
      return false;
    }

        public boolean canUnindent(Token t)
        {
          switch(curLexState) {
            case FLOW:
                return false;
          }

          switch(t.kind) {
            case FLOW_SEQUENCE_END:
            case FLOW_MAPPING_END:
                return false;
          }
          return true;
        }

        private void backup(int n) { input_stream.backup(n); }

        private boolean unwindIndent(Token t)
        {
                if (!canUnindent(t)) {
                        return false;
                }

                int beginColumn = t.beginColumn;
                // unwind indent all the way when we see these
                if (t.kind == EOF || t.kind == DOCUMENT_START || t.kind == DOCUMENT_END) {
                        beginColumn = FIRST_COLUMN;
                }

                if (peekIndent() > beginColumn) {
                        // how far back did we dedent?
                        int prevIndex = findPreviousIndent(beginColumn);
                        // generate DEDENTs for each indent level we backed up over
                        for (int d = sp - 1; d >= prevIndex; d--) {
                                pendingDedents++;
                        }
                        // take care of one unindent now, the remaining on the next token
                        handlePendingDedent(t);
                        return true;
                }
                return false;
        }

        private boolean isIndentedScalarFinished(Token t) {
                // not a match as the indent is > than parent, put the token back
            if (peekIndent() >= t.beginColumn) {
                // make sure we handle comments or whitespace after this indented block
                // but have to save until the other tokens are processed
                endIndentedSpecial = getSpecialTokensBefore(t);
                backup(t.image.length());
                t.kind = NULL_SCALAR;
                        t.image = "";
                        return true;
            }
            return false;
        }

        public void processIndentedBlockEnd() {
        // make sure we handled any preceding comments or whitespace
        if (endIndentedSpecial != null) {
                boolean first = true;
                for(Token s : endIndentedSpecial) {
                        if (s.kind == COMMENT_TEXT) {
                                // handle case were the lexer eats an extra whitespace after plain scalar and before comment
                                // re-add the missing whitespace as we strip it from the scalar
                                handler.handleComment(first ? " "+s.image : s.image, true);
                        } else {
                                handler.handleWhitespace(s.image, true);
                        }
                        first = false;
                }
                endIndentedSpecial = null;
        }
        }

        private void handlePendingDedent(Token t) {
                if (t.kind != FALSE_START) {
                        backup(t.image.length());
                }
                t.kind = BLOCK_END;
                t.image = "BLOCK_END";
                // never go below zero in case this is a EOF
                if (pendingDedents > 0) --pendingDedents;
                pop();
        }

        private void push(int indent, int type) {
                if (sp >= MAX_INDENTS) {
                        throw new IllegalStateException("Indent Error");
                }
                sp++;
                indentStack[sp] = indent;
                indentTokenTypes[sp] = type;
        }

        private int pop() {
                if (sp < 0) {
                        throw new IllegalStateException("Unindent error");
                }
                int top = indentStack[sp];
                sp--;
                return top;
        }

        public int peekIndent() {
                return indentStack[sp];
        }

        public int peekType() {
                return indentTokenTypes[sp];
        }

        public boolean insideFlow() {
                if (flowSequenceNesting==0 && flowMappingeNesting==0)
                        return false;
                else
                        return true;
        }

        /** Return the index on stack of previous indent level == i else -1 */
        private int findPreviousIndent(int i) {
                for (int j = sp - 1; j >= 0; j--) {
                        if (indentStack[j] == i) {
                                return j;
                        }
                }
                return -1;
        }

        private void ignorableWhiteSpace(Token t) {
                if (curLexState == DEFAULT || curLexState == FLOW) {
                        handler.handleWhitespace(t.image, false);
                }
                // else we are inside some scalar with newlines let the scalar code
                // handle it
        }

        private void ignorableComment(Token t) {
                if (curLexState == DEFAULT || curLexState == FLOW) {
                        handler.handleComment(t.image, false);
                }
                // else we are inside some scalar with newlines let the scalar code
                // handle it
        }

        public List<Token> getSpecialTokensBefore(Token t)
        {
            if (t.specialToken == null) return null;
            List < Token > specialTokensList = new ArrayList <Token> ();
            // The above statement determines that there are no special tokens
            // and returns control to the caller.
            Token tmp_t = t.specialToken;
            while (tmp_t.specialToken != null) tmp_t = tmp_t.specialToken;
            // The above line walks back the special token chain until it
            // reaches the first special token after the previous regular
            // token.
            while (tmp_t != null)
            {
              specialTokensList.add(tmp_t);
              tmp_t = tmp_t.next;
            }
            // The above loop now walks the special token chain in the forward
            // direction
            return specialTokensList;
        }

  /** Debug output. */
  public  java.io.PrintStream debugStream = System.out;
  /** Set debug output. */
  public  void setDebugStream(java.io.PrintStream ds) { debugStream = ds; }
private final int jjStopStringLiteralDfa_7(int pos, long active0){
   switch (pos)
   {
      case 0:
         if ((active0 & 0x10000000L) != 0L)
            return 133;
         if ((active0 & 0x8000000L) != 0L)
            return 134;
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_7(int pos, long active0){
   return jjMoveNfa_7(jjStopStringLiteralDfa_7(pos, active0), pos + 1);
}
private int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private int jjMoveStringLiteralDfa0_7(){
   switch(curChar)
   {
      case 34:
         return jjMoveStringLiteralDfa1_7(0x10000000L);
      case 39:
         return jjMoveStringLiteralDfa1_7(0x8000000L);
      case 91:
         return jjStopAtPos(0, 14);
      case 123:
         return jjStopAtPos(0, 15);
      default :
         return jjMoveNfa_7(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_7(long active0){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_7(0, active0);
      return 1;
   }
   switch(curChar)
   {
      case 34:
         if ((active0 & 0x10000000L) != 0L)
            return jjStopAtPos(1, 28);
         break;
      case 39:
         if ((active0 & 0x8000000L) != 0L)
            return jjStartNfaWithStates_7(1, 27, 79);
         break;
      default :
         break;
   }
   return jjStartNfa_7(0, active0);
}
private int jjStartNfaWithStates_7(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_7(state, pos + 1);
}
static final long[] jjbitVec0 = {
   0xfffffffffffffffeL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec2 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec3 = {
   0x0L, 0x0L, 0x20L, 0x0L
};
static final long[] jjbitVec4 = {
   0x30000000000L, 0x0L, 0x0L, 0x0L
};
static final long[] jjbitVec5 = {
   0x0L, 0x0L, 0x100000000L, 0x0L
};
static final long[] jjbitVec6 = {
   0x0L, 0x0L, 0x1L, 0x0L
};
static final long[] jjbitVec7 = {
   0x4000L, 0x0L, 0x0L, 0x0L
};
static final long[] jjbitVec8 = {
   0x800000000fffL, 0x80000000L, 0x0L, 0x0L
};
static final long[] jjbitVec9 = {
   0x1L, 0x0L, 0x0L, 0x0L
};
static final long[] jjbitVec10 = {
   0x0L, 0x0L, 0x0L, 0x8000000000000000L
};
static final long[] jjbitVec11 = {
   0x0L, 0x0L, 0x100000020L, 0x0L
};
static final long[] jjbitVec12 = {
   0x830000000fffL, 0x80000000L, 0x0L, 0x0L
};
private int jjMoveNfa_7(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 133;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x3bffcb10ffffdbffL & l) != 0L)
                  {
                     if (kind > 45)
                        kind = 45;
                     { jjCheckNAddStates(0, 6); }
                  }
                  else if ((0x8400200000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(116, 131); }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  else if (curChar == 34)
                     { jjCheckNAddStates(7, 10); }
                  else if (curChar == 39)
                     { jjCheckNAddStates(11, 14); }
                  else if (curChar == 37)
                     { jjAddStates(15, 16); }
                  else if (curChar == 62)
                  {
                     if (kind > 39)
                        kind = 39;
                     { jjCheckNAddTwoStates(46, 47); }
                  }
                  else if (curChar == 42)
                     { jjCheckNAddTwoStates(23, 24); }
                  else if (curChar == 38)
                     { jjCheckNAdd(18); }
                  else if (curChar == 33)
                     jjstateSet[jjnewStateCnt++] = 15;
                  else if (curChar == 35)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddStates(17, 19); }
                  }
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(20, 22); }
                  else if (curChar == 45)
                     { jjCheckNAddStates(23, 25); }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 40;
                  else if (curChar == 33)
                     { jjCheckNAddStates(26, 31); }
                  if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  else if (curChar == 13)
                     { jjCheckNAddTwoStates(20, 76); }
                  else if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 134:
                  if ((0xffffff7fffffdbffL & l) != 0L)
                     { jjCheckNAddStates(32, 34); }
                  else if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 82;
                  if ((0xffffff7fffffdbffL & l) != 0L)
                  {
                     if (kind > 29)
                        kind = 29;
                     { jjCheckNAddTwoStates(78, 80); }
                  }
                  else if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 133:
                  if ((0xfffffffbffffc9ffL & l) != 0L)
                     { jjCheckNAddStates(35, 37); }
                  if ((0xfffffffbffffc9ffL & l) != 0L)
                  {
                     if (kind > 30)
                        kind = 30;
                     { jjCheckNAddTwoStates(94, 95); }
                  }
                  break;
               case 79:
                  if (curChar == 39)
                     { jjCheckNAddStates(32, 34); }
                  if (curChar == 39)
                  {
                     if (kind > 29)
                        kind = 29;
                     { jjCheckNAddTwoStates(78, 80); }
                  }
                  break;
               case 1:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddStates(17, 19); }
                  break;
               case 2:
                  if (curChar == 10 && kind > 1)
                     kind = 1;
                  break;
               case 3:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 4:
                  if ((0x2400L & l) != 0L && kind > 1)
                     kind = 1;
                  break;
               case 5:
               case 15:
                  if (curChar == 33)
                     { jjCheckNAddStates(26, 31); }
                  break;
               case 6:
                  if (curChar == 60)
                     { jjCheckNAddStates(38, 42); }
                  break;
               case 7:
                  if ((0xaffffffa00000000L & l) != 0L)
                     { jjCheckNAddStates(38, 42); }
                  break;
               case 8:
                  if (curChar == 62)
                     { jjCheckNAddStates(43, 45); }
                  break;
               case 9:
                  if (curChar == 10 && kind > 9)
                     kind = 9;
                  break;
               case 10:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 11:
                  if ((0x2400L & l) != 0L && kind > 9)
                     kind = 9;
                  break;
               case 12:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 9)
                     kind = 9;
                  { jjCheckNAddStates(46, 49); }
                  break;
               case 13:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 9)
                     kind = 9;
                  { jjCheckNAdd(13); }
                  break;
               case 14:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(50, 52); }
                  break;
               case 16:
                  if (curChar == 33)
                     jjstateSet[jjnewStateCnt++] = 15;
                  break;
               case 17:
                  if (curChar == 38)
                     { jjCheckNAdd(18); }
                  break;
               case 18:
                  if ((0x3ff200000000000L & l) == 0L)
                     break;
                  if (kind > 12)
                     kind = 12;
                  { jjCheckNAdd(18); }
                  break;
               case 19:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(20, 22); }
                  break;
               case 20:
                  if (curChar == 10)
                     { jjCheckNAddStates(20, 22); }
                  break;
               case 21:
                  if (curChar == 13)
                     { jjCheckNAdd(20); }
                  break;
               case 22:
                  if (curChar == 42)
                     { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 23:
                  if ((0x3bffcb10ffffdbffL & l) == 0L)
                     break;
                  if (kind > 13)
                     kind = 13;
                  { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 24:
                  if ((0x8400200000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 25;
                  break;
               case 25:
                  if ((0xfffffffeffffdbffL & l) == 0L)
                     break;
                  if (kind > 13)
                     kind = 13;
                  { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 26:
                  if (curChar == 45)
                     { jjCheckNAddStates(53, 55); }
                  break;
               case 27:
                  if (curChar == 10 && kind > 19)
                     kind = 19;
                  break;
               case 28:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 29:
                  if ((0x2400L & l) != 0L && kind > 19)
                     kind = 19;
                  break;
               case 30:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 19)
                     kind = 19;
                  { jjCheckNAddStates(56, 59); }
                  break;
               case 31:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 19)
                     kind = 19;
                  { jjCheckNAdd(31); }
                  break;
               case 32:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(60, 62); }
                  break;
               case 33:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 26;
                  break;
               case 34:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 33;
                  break;
               case 35:
                  if (curChar != 46)
                     break;
                  if (kind > 20)
                     kind = 20;
                  { jjCheckNAddStates(63, 65); }
                  break;
               case 36:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 20)
                     kind = 20;
                  { jjCheckNAddStates(63, 65); }
                  break;
               case 37:
                  if (curChar == 10 && kind > 20)
                     kind = 20;
                  break;
               case 38:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 37;
                  break;
               case 39:
                  if ((0x2400L & l) != 0L && kind > 20)
                     kind = 20;
                  break;
               case 40:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 35;
                  break;
               case 41:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 40;
                  break;
               case 43:
                  if ((0x280000000000L & l) == 0L)
                     break;
                  if (kind > 38)
                     kind = 38;
                  { jjCheckNAdd(44); }
                  break;
               case 44:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 38)
                     kind = 38;
                  { jjCheckNAdd(44); }
                  break;
               case 45:
                  if (curChar != 62)
                     break;
                  if (kind > 39)
                     kind = 39;
                  { jjCheckNAddTwoStates(46, 47); }
                  break;
               case 46:
                  if ((0x280000000000L & l) == 0L)
                     break;
                  if (kind > 39)
                     kind = 39;
                  { jjCheckNAdd(47); }
                  break;
               case 47:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 39)
                     kind = 39;
                  { jjCheckNAdd(47); }
                  break;
               case 48:
                  if (curChar == 45)
                     { jjCheckNAddStates(23, 25); }
                  break;
               case 49:
                  if (curChar == 10 && kind > 40)
                     kind = 40;
                  break;
               case 50:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 49;
                  break;
               case 51:
                  if ((0x2400L & l) != 0L && kind > 40)
                     kind = 40;
                  break;
               case 52:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 40)
                     kind = 40;
                  { jjCheckNAddStates(66, 69); }
                  break;
               case 53:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 40)
                     kind = 40;
                  { jjCheckNAdd(53); }
                  break;
               case 54:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(70, 72); }
                  break;
               case 55:
                  if ((0x2400L & l) != 0L && kind > 51)
                     kind = 51;
                  break;
               case 56:
                  if ((0x100000200L & l) != 0L && kind > 52)
                     kind = 52;
                  break;
               case 57:
                  if (curChar == 37)
                     { jjAddStates(15, 16); }
                  break;
               case 59:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(73, 76); }
                  break;
               case 60:
                  if ((0xffffffffffffdbffL & l) != 0L)
                     { jjCheckNAddStates(77, 79); }
                  break;
               case 61:
                  if (curChar == 10 && kind > 10)
                     kind = 10;
                  break;
               case 62:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 61;
                  break;
               case 63:
                  if ((0x2400L & l) != 0L && kind > 10)
                     kind = 10;
                  break;
               case 67:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddTwoStates(67, 68); }
                  break;
               case 68:
                  if ((0x3ff400000000000L & l) != 0L)
                     { jjCheckNAddStates(80, 82); }
                  break;
               case 69:
                  if (curChar == 10 && kind > 11)
                     kind = 11;
                  break;
               case 70:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 69;
                  break;
               case 71:
                  if ((0x2400L & l) != 0L && kind > 11)
                     kind = 11;
                  break;
               case 75:
                  if (curChar == 13)
                     { jjCheckNAddTwoStates(20, 76); }
                  break;
               case 76:
                  if (curChar == 10 && kind > 51)
                     kind = 51;
                  break;
               case 77:
                  if (curChar == 39)
                     { jjCheckNAddStates(11, 14); }
                  break;
               case 78:
                  if ((0xffffff7fffffdbffL & l) == 0L)
                     break;
                  if (kind > 29)
                     kind = 29;
                  { jjCheckNAddTwoStates(78, 80); }
                  break;
               case 80:
                  if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 79;
                  break;
               case 81:
                  if ((0xffffff7fffffdbffL & l) != 0L)
                     { jjCheckNAddStates(32, 34); }
                  break;
               case 82:
                  if (curChar == 39)
                     { jjCheckNAddStates(32, 34); }
                  break;
               case 83:
                  if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 82;
                  break;
               case 84:
                  if (curChar == 39)
                     { jjCheckNAddTwoStates(85, 86); }
                  break;
               case 85:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddTwoStates(85, 86); }
                  break;
               case 86:
                  if (curChar == 58)
                     { jjCheckNAddStates(83, 85); }
                  break;
               case 87:
                  if (curChar == 10 && kind > 42)
                     kind = 42;
                  break;
               case 88:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 87;
                  break;
               case 89:
                  if ((0x2400L & l) != 0L && kind > 42)
                     kind = 42;
                  break;
               case 90:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 42)
                     kind = 42;
                  { jjCheckNAddStates(86, 89); }
                  break;
               case 91:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 42)
                     kind = 42;
                  { jjCheckNAdd(91); }
                  break;
               case 92:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(90, 92); }
                  break;
               case 93:
                  if (curChar == 34)
                     { jjCheckNAddStates(7, 10); }
                  break;
               case 94:
                  if ((0xfffffffbffffc9ffL & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddTwoStates(94, 95); }
                  break;
               case 97:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddStates(93, 95); }
                  break;
               case 98:
                  if ((0x1800400000000L & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddTwoStates(94, 95); }
                  break;
               case 99:
                  if ((0xfffffffbffffc9ffL & l) != 0L)
                     { jjCheckNAddStates(35, 37); }
                  break;
               case 102:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddStates(96, 99); }
                  break;
               case 103:
                  if (curChar == 34)
                     { jjCheckNAddTwoStates(104, 105); }
                  break;
               case 104:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddTwoStates(104, 105); }
                  break;
               case 105:
                  if (curChar == 58)
                     { jjCheckNAddStates(100, 102); }
                  break;
               case 106:
                  if (curChar == 10 && kind > 43)
                     kind = 43;
                  break;
               case 107:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 106;
                  break;
               case 108:
                  if ((0x2400L & l) != 0L && kind > 43)
                     kind = 43;
                  break;
               case 109:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 43)
                     kind = 43;
                  { jjCheckNAddStates(103, 106); }
                  break;
               case 110:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 43)
                     kind = 43;
                  { jjCheckNAdd(110); }
                  break;
               case 111:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(107, 109); }
                  break;
               case 112:
                  if ((0x1800400000000L & l) != 0L)
                     { jjCheckNAddStates(35, 37); }
                  break;
               case 113:
                  if ((0x3bffcb10ffffdbffL & l) == 0L)
                     break;
                  if (kind > 45)
                     kind = 45;
                  { jjCheckNAddStates(0, 6); }
                  break;
               case 114:
                  if ((0xfbfffff7ffffdbffL & l) == 0L)
                     break;
                  if (kind > 45)
                     kind = 45;
                  { jjCheckNAddStates(110, 112); }
                  break;
               case 115:
                  if (curChar == 58)
                     { jjCheckNAdd(116); }
                  break;
               case 116:
                  if ((0xfffffffeffffdbffL & l) == 0L)
                     break;
                  if (kind > 45)
                     kind = 45;
                  { jjCheckNAddStates(110, 112); }
                  break;
               case 117:
                  if ((0xfffffffeffffdbffL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 118;
                  break;
               case 118:
                  if (curChar != 35)
                     break;
                  if (kind > 45)
                     kind = 45;
                  { jjCheckNAddStates(110, 112); }
                  break;
               case 119:
                  if ((0xfbfffff7ffffdbffL & l) != 0L)
                     { jjCheckNAddStates(113, 116); }
                  break;
               case 120:
                  if ((0xfffffffeffffdbffL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 121;
                  break;
               case 121:
                  if (curChar == 35)
                     { jjCheckNAddStates(113, 116); }
                  break;
               case 122:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddTwoStates(122, 123); }
                  break;
               case 123:
                  if (curChar == 58)
                     { jjCheckNAddStates(117, 119); }
                  break;
               case 124:
                  if (curChar == 10 && kind > 46)
                     kind = 46;
                  break;
               case 125:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 124;
                  break;
               case 126:
                  if ((0x2400L & l) != 0L && kind > 46)
                     kind = 46;
                  break;
               case 127:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 46)
                     kind = 46;
                  { jjCheckNAddStates(120, 123); }
                  break;
               case 128:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 46)
                     kind = 46;
                  { jjCheckNAdd(128); }
                  break;
               case 129:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(124, 126); }
                  break;
               case 130:
                  if (curChar == 58)
                     { jjCheckNAddStates(127, 130); }
                  break;
               case 131:
                  if ((0xfffffffeffffdbffL & l) != 0L)
                     { jjCheckNAddStates(113, 116); }
                  break;
               case 132:
                  if ((0x8400200000000000L & l) != 0L)
                     { jjCheckNAddTwoStates(116, 131); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xc7fffffed7fffffeL & l) != 0L)
                  {
                     if (kind > 45)
                        kind = 45;
                     { jjCheckNAddStates(0, 6); }
                  }
                  else if (curChar == 124)
                  {
                     if (kind > 38)
                        kind = 38;
                     { jjAddStates(131, 132); }
                  }
                  break;
               case 134:
                  { jjCheckNAddStates(32, 34); }
                  if (kind > 29)
                     kind = 29;
                  { jjCheckNAddTwoStates(78, 80); }
                  break;
               case 133:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(35, 37); }
                  else if (curChar == 92)
                     { jjAddStates(133, 134); }
                  if ((0xffffffffefffffffL & l) != 0L)
                  {
                     if (kind > 30)
                        kind = 30;
                     { jjCheckNAddTwoStates(94, 95); }
                  }
                  else if (curChar == 92)
                     { jjAddStates(135, 136); }
                  break;
               case 1:
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 7:
                  if ((0x47fffffeafffffffL & l) != 0L)
                     { jjAddStates(38, 42); }
                  break;
               case 18:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 12)
                     kind = 12;
                  jjstateSet[jjnewStateCnt++] = 18;
                  break;
               case 23:
                  if ((0xc7fffffed7fffffeL & l) == 0L)
                     break;
                  if (kind > 13)
                     kind = 13;
                  { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 25:
                  if (kind > 13)
                     kind = 13;
                  { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 42:
                  if (curChar != 124)
                     break;
                  if (kind > 38)
                     kind = 38;
                  { jjAddStates(131, 132); }
                  break;
               case 58:
                  if (curChar == 71)
                     jjstateSet[jjnewStateCnt++] = 59;
                  break;
               case 60:
                  { jjAddStates(77, 79); }
                  break;
               case 64:
                  if (curChar == 65)
                     jjstateSet[jjnewStateCnt++] = 58;
                  break;
               case 65:
                  if (curChar == 84)
                     jjstateSet[jjnewStateCnt++] = 64;
                  break;
               case 66:
                  if (curChar == 76)
                     jjstateSet[jjnewStateCnt++] = 67;
                  break;
               case 72:
                  if (curChar == 77)
                     jjstateSet[jjnewStateCnt++] = 66;
                  break;
               case 73:
                  if (curChar == 65)
                     jjstateSet[jjnewStateCnt++] = 72;
                  break;
               case 74:
                  if (curChar == 89)
                     jjstateSet[jjnewStateCnt++] = 73;
                  break;
               case 78:
                  if (kind > 29)
                     kind = 29;
                  { jjCheckNAddTwoStates(78, 80); }
                  break;
               case 81:
                  { jjCheckNAddStates(32, 34); }
                  break;
               case 94:
                  if ((0xffffffffefffffffL & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddTwoStates(94, 95); }
                  break;
               case 95:
                  if (curChar == 92)
                     { jjAddStates(135, 136); }
                  break;
               case 96:
                  if (curChar == 120)
                     { jjCheckNAdd(97); }
                  break;
               case 97:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddStates(93, 95); }
                  break;
               case 98:
                  if ((0x55406490004000L & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddTwoStates(94, 95); }
                  break;
               case 99:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(35, 37); }
                  break;
               case 100:
                  if (curChar == 92)
                     { jjAddStates(133, 134); }
                  break;
               case 101:
                  if (curChar == 120)
                     { jjCheckNAdd(102); }
                  break;
               case 102:
                  if ((0x7e0000007eL & l) != 0L)
                     { jjCheckNAddStates(96, 99); }
                  break;
               case 112:
                  if ((0x55406490004000L & l) != 0L)
                     { jjCheckNAddStates(35, 37); }
                  break;
               case 113:
                  if ((0xc7fffffed7fffffeL & l) == 0L)
                     break;
                  if (kind > 45)
                     kind = 45;
                  { jjCheckNAddStates(0, 6); }
                  break;
               case 114:
               case 116:
                  if (kind > 45)
                     kind = 45;
                  { jjCheckNAddStates(110, 112); }
                  break;
               case 117:
                  jjstateSet[jjnewStateCnt++] = 118;
                  break;
               case 119:
               case 131:
                  { jjCheckNAddStates(113, 116); }
                  break;
               case 120:
                  jjstateSet[jjnewStateCnt++] = 121;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_3(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(20, 22); }
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 45)
                        kind = 45;
                     { jjCheckNAddStates(0, 6); }
                  }
                  break;
               case 134:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 29)
                        kind = 29;
                     { jjCheckNAddTwoStates(78, 80); }
                  }
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(32, 34); }
                  break;
               case 133:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 30)
                        kind = 30;
                     { jjCheckNAddTwoStates(94, 95); }
                  }
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(35, 37); }
                  break;
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 4:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 1)
                     kind = 1;
                  break;
               case 11:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 9)
                     kind = 9;
                  break;
               case 12:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 9)
                     kind = 9;
                  { jjCheckNAddStates(46, 49); }
                  break;
               case 13:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 9)
                     kind = 9;
                  { jjCheckNAdd(13); }
                  break;
               case 14:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(50, 52); }
                  break;
               case 19:
                  if (jjCanMove_3(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(20, 22); }
                  break;
               case 23:
               case 25:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 13)
                     kind = 13;
                  { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 29:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 19)
                     kind = 19;
                  break;
               case 30:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 19)
                     kind = 19;
                  { jjCheckNAddStates(56, 59); }
                  break;
               case 31:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 19)
                     kind = 19;
                  { jjCheckNAdd(31); }
                  break;
               case 32:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(60, 62); }
                  break;
               case 36:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 20)
                     kind = 20;
                  { jjAddStates(63, 65); }
                  break;
               case 39:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 20)
                     kind = 20;
                  break;
               case 44:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 38)
                     kind = 38;
                  jjstateSet[jjnewStateCnt++] = 44;
                  break;
               case 47:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 39)
                     kind = 39;
                  jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 51:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 40)
                     kind = 40;
                  break;
               case 52:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 40)
                     kind = 40;
                  { jjCheckNAddStates(66, 69); }
                  break;
               case 53:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 40)
                     kind = 40;
                  { jjCheckNAdd(53); }
                  break;
               case 54:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(70, 72); }
                  break;
               case 55:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51)
                     kind = 51;
                  break;
               case 56:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2) && kind > 52)
                     kind = 52;
                  break;
               case 59:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(73, 76); }
                  break;
               case 60:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(77, 79); }
                  break;
               case 63:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 10)
                     kind = 10;
                  break;
               case 67:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjAddStates(137, 138); }
                  break;
               case 71:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 11)
                     kind = 11;
                  break;
               case 78:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 29)
                     kind = 29;
                  { jjCheckNAddTwoStates(78, 80); }
                  break;
               case 81:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(32, 34); }
                  break;
               case 85:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjAddStates(139, 140); }
                  break;
               case 89:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 42)
                     kind = 42;
                  break;
               case 90:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 42)
                     kind = 42;
                  { jjCheckNAddStates(86, 89); }
                  break;
               case 91:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 42)
                     kind = 42;
                  { jjCheckNAdd(91); }
                  break;
               case 92:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(90, 92); }
                  break;
               case 94:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddTwoStates(94, 95); }
                  break;
               case 99:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(35, 37); }
                  break;
               case 104:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjAddStates(141, 142); }
                  break;
               case 108:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 43)
                     kind = 43;
                  break;
               case 109:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 43)
                     kind = 43;
                  { jjCheckNAddStates(103, 106); }
                  break;
               case 110:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 43)
                     kind = 43;
                  { jjCheckNAdd(110); }
                  break;
               case 111:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(107, 109); }
                  break;
               case 113:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 45)
                     kind = 45;
                  { jjCheckNAddStates(0, 6); }
                  break;
               case 114:
               case 116:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 45)
                     kind = 45;
                  { jjCheckNAddStates(110, 112); }
                  break;
               case 117:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjstateSet[jjnewStateCnt++] = 118;
                  break;
               case 119:
               case 131:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(113, 116); }
                  break;
               case 120:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjstateSet[jjnewStateCnt++] = 121;
                  break;
               case 122:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddTwoStates(122, 123); }
                  break;
               case 126:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 46)
                     kind = 46;
                  break;
               case 127:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 46)
                     kind = 46;
                  { jjCheckNAddStates(120, 123); }
                  break;
               case 128:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 46)
                     kind = 46;
                  { jjCheckNAdd(128); }
                  break;
               case 129:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(124, 126); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 133 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_4()
{
   return jjMoveNfa_4(0, 0);
}
private int jjMoveNfa_4(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 25;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  else if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 19;
                  else if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 12;
                  else if (curChar == 35)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddStates(17, 19); }
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 21;
                  break;
               case 1:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddStates(17, 19); }
                  break;
               case 2:
                  if (curChar == 10 && kind > 1)
                     kind = 1;
                  break;
               case 3:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 4:
                  if ((0x2400L & l) != 0L && kind > 1)
                     kind = 1;
                  break;
               case 5:
                  if (curChar == 45)
                     { jjCheckNAddStates(143, 145); }
                  break;
               case 6:
                  if (curChar == 10 && kind > 19)
                     kind = 19;
                  break;
               case 7:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               case 8:
                  if ((0x2400L & l) != 0L && kind > 19)
                     kind = 19;
                  break;
               case 9:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 19)
                     kind = 19;
                  { jjCheckNAddStates(146, 149); }
                  break;
               case 10:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 19)
                     kind = 19;
                  { jjCheckNAdd(10); }
                  break;
               case 11:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(150, 152); }
                  break;
               case 12:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 13:
                  if (curChar == 45)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 14:
                  if (curChar != 46)
                     break;
                  if (kind > 20)
                     kind = 20;
                  { jjCheckNAddStates(153, 155); }
                  break;
               case 15:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 20)
                     kind = 20;
                  { jjCheckNAddStates(153, 155); }
                  break;
               case 16:
                  if (curChar == 10 && kind > 20)
                     kind = 20;
                  break;
               case 17:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 18:
                  if ((0x2400L & l) != 0L && kind > 20)
                     kind = 20;
                  break;
               case 19:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 20:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 19;
                  break;
               case 21:
                  if (curChar == 10 && kind > 51)
                     kind = 51;
                  break;
               case 22:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 21;
                  break;
               case 23:
                  if ((0x2400L & l) != 0L && kind > 51)
                     kind = 51;
                  break;
               case 24:
                  if ((0x100000200L & l) != 0L && kind > 52)
                     kind = 52;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
                  kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  break;
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 4:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 1)
                     kind = 1;
                  break;
               case 8:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 19)
                     kind = 19;
                  break;
               case 9:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 19)
                     kind = 19;
                  { jjCheckNAddStates(146, 149); }
                  break;
               case 10:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 19)
                     kind = 19;
                  { jjCheckNAdd(10); }
                  break;
               case 11:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(150, 152); }
                  break;
               case 15:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 20)
                     kind = 20;
                  { jjAddStates(153, 155); }
                  break;
               case 18:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 20)
                     kind = 20;
                  break;
               case 23:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51)
                     kind = 51;
                  break;
               case 24:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2) && kind > 52)
                     kind = 52;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 25 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_3(int pos, long active0){
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_3(int pos, long active0){
   return jjMoveNfa_3(jjStopStringLiteralDfa_3(pos, active0), pos + 1);
}
private int jjMoveStringLiteralDfa0_3(){
   switch(curChar)
   {
      case 34:
         return jjStopAtPos(0, 34);
      default :
         return jjMoveNfa_3(0, 0);
   }
}
private int jjMoveNfa_3(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 21;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xfffffffbffffc9ffL & l) != 0L)
                  {
                     if (kind > 33)
                        kind = 33;
                     { jjCheckNAddTwoStates(5, 6); }
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 52)
                        kind = 52;
                     { jjCheckNAddTwoStates(19, 20); }
                  }
                  else if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 10;
                  else if (curChar == 35)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddStates(17, 19); }
                  }
                  break;
               case 1:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddStates(17, 19); }
                  break;
               case 2:
                  if (curChar == 10 && kind > 1)
                     kind = 1;
                  break;
               case 3:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 4:
                  if ((0x2400L & l) != 0L && kind > 1)
                     kind = 1;
                  break;
               case 5:
                  if ((0xfffffffbffffc9ffL & l) == 0L)
                     break;
                  if (kind > 33)
                     kind = 33;
                  { jjCheckNAddTwoStates(5, 6); }
                  break;
               case 8:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 33)
                     kind = 33;
                  { jjCheckNAddStates(156, 158); }
                  break;
               case 9:
                  if ((0x1800400000000L & l) == 0L)
                     break;
                  if (kind > 33)
                     kind = 33;
                  { jjCheckNAddTwoStates(5, 6); }
                  break;
               case 10:
                  if (curChar == 10 && kind > 51)
                     kind = 51;
                  break;
               case 11:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 12:
                  if ((0x2400L & l) != 0L && kind > 51)
                     kind = 51;
                  break;
               case 14:
                  if ((0x100000200L & l) != 0L)
                     { jjAddStates(159, 161); }
                  break;
               case 15:
                  if (curChar == 10 && kind > 31)
                     kind = 31;
                  break;
               case 16:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 15;
                  break;
               case 17:
                  if ((0x2400L & l) != 0L && kind > 31)
                     kind = 31;
                  break;
               case 18:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 52)
                     kind = 52;
                  { jjCheckNAddTwoStates(19, 20); }
                  break;
               case 19:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddTwoStates(19, 20); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xffffffffefffffffL & l) != 0L)
                  {
                     if (kind > 33)
                        kind = 33;
                     { jjCheckNAddTwoStates(5, 6); }
                  }
                  else if (curChar == 92)
                  {
                     if (kind > 32)
                        kind = 32;
                     { jjCheckNAddStates(162, 166); }
                  }
                  break;
               case 1:
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 5:
                  if ((0xffffffffefffffffL & l) == 0L)
                     break;
                  if (kind > 33)
                     kind = 33;
                  { jjCheckNAddTwoStates(5, 6); }
                  break;
               case 6:
                  if (curChar == 92)
                     { jjCheckNAddTwoStates(7, 9); }
                  break;
               case 7:
                  if (curChar == 120)
                     { jjCheckNAdd(8); }
                  break;
               case 8:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 33)
                     kind = 33;
                  { jjCheckNAddStates(156, 158); }
                  break;
               case 9:
                  if ((0x55406490004000L & l) == 0L)
                     break;
                  if (kind > 33)
                     kind = 33;
                  { jjCheckNAddTwoStates(5, 6); }
                  break;
               case 13:
                  if (curChar != 92)
                     break;
                  if (kind > 32)
                     kind = 32;
                  { jjCheckNAddStates(162, 166); }
                  break;
               case 20:
                  if (curChar == 92 && kind > 32)
                     kind = 32;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 33)
                        kind = 33;
                     { jjCheckNAddTwoStates(5, 6); }
                  }
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 52)
                        kind = 52;
                     { jjCheckNAddTwoStates(19, 20); }
                  }
                  break;
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 4:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 1)
                     kind = 1;
                  break;
               case 5:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 33)
                     kind = 33;
                  { jjCheckNAddTwoStates(5, 6); }
                  break;
               case 12:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51)
                     kind = 51;
                  break;
               case 14:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjAddStates(159, 161); }
                  break;
               case 17:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 31)
                     kind = 31;
                  break;
               case 18:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 52)
                     kind = 52;
                  { jjCheckNAddTwoStates(19, 20); }
                  break;
               case 19:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddTwoStates(19, 20); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 21 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_1()
{
   return jjMoveNfa_1(0, 0);
}
private int jjMoveNfa_1(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 15;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xfffffff6ffffdbffL & l) != 0L)
                  {
                     if (kind > 47)
                        kind = 47;
                     { jjCheckNAddStates(167, 169); }
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  else if (curChar == 35)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddStates(17, 19); }
                  }
                  if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  else if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 1:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddStates(17, 19); }
                  break;
               case 2:
                  if (curChar == 10 && kind > 1)
                     kind = 1;
                  break;
               case 3:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 4:
                  if ((0x2400L & l) != 0L && kind > 1)
                     kind = 1;
                  break;
               case 5:
                  if ((0xfffffff6ffffdbffL & l) == 0L)
                     break;
                  if (kind > 47)
                     kind = 47;
                  { jjCheckNAddStates(167, 169); }
                  break;
               case 6:
                  if ((0xfbfffff7ffffdbffL & l) == 0L)
                     break;
                  if (kind > 47)
                     kind = 47;
                  { jjCheckNAddStates(167, 169); }
                  break;
               case 7:
                  if (curChar == 58)
                     jjstateSet[jjnewStateCnt++] = 8;
                  break;
               case 8:
                  if ((0xfffffffeffffdbffL & l) == 0L)
                     break;
                  if (kind > 47)
                     kind = 47;
                  { jjCheckNAddStates(167, 169); }
                  break;
               case 9:
                  if ((0xfffffffeffffdbffL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 10:
                  if (curChar != 35)
                     break;
                  if (kind > 47)
                     kind = 47;
                  { jjCheckNAddStates(167, 169); }
                  break;
               case 11:
                  if (curChar == 10 && kind > 51)
                     kind = 51;
                  break;
               case 12:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 11;
                  break;
               case 13:
                  if ((0x2400L & l) != 0L && kind > 51)
                     kind = 51;
                  break;
               case 14:
                  if ((0x100000200L & l) != 0L && kind > 52)
                     kind = 52;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 6:
               case 8:
                  if (kind > 47)
                     kind = 47;
                  { jjCheckNAddStates(167, 169); }
                  break;
               case 1:
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 9:
                  jjstateSet[jjnewStateCnt++] = 10;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 47)
                        kind = 47;
                     { jjCheckNAddStates(167, 169); }
                  }
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  break;
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 4:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 1)
                     kind = 1;
                  break;
               case 5:
               case 6:
               case 8:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 47)
                     kind = 47;
                  { jjCheckNAddStates(167, 169); }
                  break;
               case 9:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 13:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51)
                     kind = 51;
                  break;
               case 14:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2) && kind > 52)
                     kind = 52;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 15 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_5(int pos, long active0){
   switch (pos)
   {
      case 0:
         if ((active0 & 0x10000000L) != 0L)
            return 109;
         if ((active0 & 0x8000000L) != 0L)
            return 110;
         return -1;
      default :
         return -1;
   }
}
private final int jjStartNfa_5(int pos, long active0){
   return jjMoveNfa_5(jjStopStringLiteralDfa_5(pos, active0), pos + 1);
}
private int jjMoveStringLiteralDfa0_5(){
   switch(curChar)
   {
      case 34:
         return jjMoveStringLiteralDfa1_5(0x10000000L);
      case 39:
         return jjMoveStringLiteralDfa1_5(0x8000000L);
      case 91:
         return jjStopAtPos(0, 14);
      case 93:
         return jjStopAtPos(0, 16);
      case 123:
         return jjStopAtPos(0, 15);
      case 125:
         return jjStopAtPos(0, 17);
      default :
         return jjMoveNfa_5(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_5(long active0){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_5(0, active0);
      return 1;
   }
   switch(curChar)
   {
      case 34:
         if ((active0 & 0x10000000L) != 0L)
            return jjStopAtPos(1, 28);
         break;
      case 39:
         if ((active0 & 0x8000000L) != 0L)
            return jjStartNfaWithStates_5(1, 27, 57);
         break;
      default :
         break;
   }
   return jjStartNfa_5(0, active0);
}
private int jjStartNfaWithStates_5(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_5(state, pos + 1);
}
private int jjMoveNfa_5(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 109;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 57:
                  if (curChar == 39)
                     { jjCheckNAddStates(170, 172); }
                  if (curChar == 39)
                  {
                     if (kind > 29)
                        kind = 29;
                     { jjCheckNAddTwoStates(56, 58); }
                  }
                  break;
               case 0:
                  if ((0x3bffcb10ffffdbffL & l) != 0L)
                  {
                     if (kind > 49)
                        kind = 49;
                     { jjCheckNAddStates(173, 178); }
                  }
                  else if ((0x8400200000000000L & l) != 0L)
                     { jjAddStates(179, 180); }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  else if (curChar == 34)
                     { jjCheckNAddStates(181, 184); }
                  else if (curChar == 39)
                     { jjCheckNAddStates(185, 188); }
                  else if (curChar == 37)
                     { jjAddStates(189, 190); }
                  else if (curChar == 44)
                  {
                     if (kind > 18)
                        kind = 18;
                     { jjCheckNAddStates(53, 55); }
                  }
                  else if (curChar == 42)
                     { jjCheckNAddTwoStates(23, 24); }
                  else if (curChar == 38)
                     { jjCheckNAdd(18); }
                  else if (curChar == 33)
                     jjstateSet[jjnewStateCnt++] = 15;
                  else if (curChar == 35)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddStates(17, 19); }
                  }
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(20, 22); }
                  else if (curChar == 33)
                     { jjCheckNAddStates(26, 31); }
                  if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  else if (curChar == 13)
                     { jjCheckNAddTwoStates(20, 54); }
                  break;
               case 109:
                  if ((0xfffffffbffffc9ffL & l) != 0L)
                     { jjCheckNAddStates(191, 193); }
                  if ((0xfffffffbffffc9ffL & l) != 0L)
                  {
                     if (kind > 30)
                        kind = 30;
                     { jjCheckNAddTwoStates(72, 73); }
                  }
                  break;
               case 110:
                  if ((0xffffff7fffffdbffL & l) != 0L)
                     { jjCheckNAddStates(170, 172); }
                  else if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 60;
                  if ((0xffffff7fffffdbffL & l) != 0L)
                  {
                     if (kind > 29)
                        kind = 29;
                     { jjCheckNAddTwoStates(56, 58); }
                  }
                  else if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 1:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddStates(17, 19); }
                  break;
               case 2:
                  if (curChar == 10 && kind > 1)
                     kind = 1;
                  break;
               case 3:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 4:
                  if ((0x2400L & l) != 0L && kind > 1)
                     kind = 1;
                  break;
               case 5:
               case 15:
                  if (curChar == 33)
                     { jjCheckNAddStates(26, 31); }
                  break;
               case 6:
                  if (curChar == 60)
                     { jjCheckNAddStates(38, 42); }
                  break;
               case 7:
                  if ((0xaffffffa00000000L & l) != 0L)
                     { jjCheckNAddStates(38, 42); }
                  break;
               case 8:
                  if (curChar == 62)
                     { jjCheckNAddStates(43, 45); }
                  break;
               case 9:
                  if (curChar == 10 && kind > 9)
                     kind = 9;
                  break;
               case 10:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 11:
                  if ((0x2400L & l) != 0L && kind > 9)
                     kind = 9;
                  break;
               case 12:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 9)
                     kind = 9;
                  { jjCheckNAddStates(46, 49); }
                  break;
               case 13:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 9)
                     kind = 9;
                  { jjCheckNAdd(13); }
                  break;
               case 14:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(50, 52); }
                  break;
               case 16:
                  if (curChar == 33)
                     jjstateSet[jjnewStateCnt++] = 15;
                  break;
               case 17:
                  if (curChar == 38)
                     { jjCheckNAdd(18); }
                  break;
               case 18:
                  if ((0x3ff200000000000L & l) == 0L)
                     break;
                  if (kind > 12)
                     kind = 12;
                  { jjCheckNAdd(18); }
                  break;
               case 19:
                  if ((0x100002600L & l) != 0L)
                     { jjCheckNAddStates(20, 22); }
                  break;
               case 20:
                  if (curChar == 10)
                     { jjCheckNAddStates(20, 22); }
                  break;
               case 21:
                  if (curChar == 13)
                     { jjCheckNAdd(20); }
                  break;
               case 22:
                  if (curChar == 42)
                     { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 23:
                  if ((0x3bffcb10ffffdbffL & l) == 0L)
                     break;
                  if (kind > 13)
                     kind = 13;
                  { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 24:
                  if ((0x8400200000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 25;
                  break;
               case 25:
                  if ((0xfffffffeffffdbffL & l) == 0L)
                     break;
                  if (kind > 13)
                     kind = 13;
                  { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 26:
                  if (curChar != 44)
                     break;
                  if (kind > 18)
                     kind = 18;
                  { jjCheckNAddStates(53, 55); }
                  break;
               case 27:
                  if (curChar == 10 && kind > 18)
                     kind = 18;
                  break;
               case 28:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 27;
                  break;
               case 29:
                  if ((0x2400L & l) != 0L && kind > 18)
                     kind = 18;
                  break;
               case 30:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 18)
                     kind = 18;
                  { jjCheckNAddStates(56, 59); }
                  break;
               case 31:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 18)
                     kind = 18;
                  { jjCheckNAdd(31); }
                  break;
               case 32:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(60, 62); }
                  break;
               case 33:
                  if ((0x2400L & l) != 0L && kind > 51)
                     kind = 51;
                  break;
               case 34:
                  if ((0x100000200L & l) != 0L && kind > 52)
                     kind = 52;
                  break;
               case 35:
                  if (curChar == 37)
                     { jjAddStates(189, 190); }
                  break;
               case 37:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(194, 197); }
                  break;
               case 38:
                  if ((0xffffffffffffdbffL & l) != 0L)
                     { jjCheckNAddStates(198, 200); }
                  break;
               case 39:
                  if (curChar == 10 && kind > 10)
                     kind = 10;
                  break;
               case 40:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 39;
                  break;
               case 41:
                  if ((0x2400L & l) != 0L && kind > 10)
                     kind = 10;
                  break;
               case 45:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddTwoStates(45, 46); }
                  break;
               case 46:
                  if ((0x3ff400000000000L & l) != 0L)
                     { jjCheckNAddStates(201, 203); }
                  break;
               case 47:
                  if (curChar == 10 && kind > 11)
                     kind = 11;
                  break;
               case 48:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 47;
                  break;
               case 49:
                  if ((0x2400L & l) != 0L && kind > 11)
                     kind = 11;
                  break;
               case 53:
                  if (curChar == 13)
                     { jjCheckNAddTwoStates(20, 54); }
                  break;
               case 54:
                  if (curChar == 10 && kind > 51)
                     kind = 51;
                  break;
               case 55:
                  if (curChar == 39)
                     { jjCheckNAddStates(185, 188); }
                  break;
               case 56:
                  if ((0xffffff7fffffdbffL & l) == 0L)
                     break;
                  if (kind > 29)
                     kind = 29;
                  { jjCheckNAddTwoStates(56, 58); }
                  break;
               case 58:
                  if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 57;
                  break;
               case 59:
                  if ((0xffffff7fffffdbffL & l) != 0L)
                     { jjCheckNAddStates(170, 172); }
                  break;
               case 60:
                  if (curChar == 39)
                     { jjCheckNAddStates(170, 172); }
                  break;
               case 61:
                  if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 60;
                  break;
               case 62:
                  if (curChar == 39)
                     { jjCheckNAddTwoStates(63, 64); }
                  break;
               case 63:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddTwoStates(63, 64); }
                  break;
               case 64:
                  if (curChar == 58)
                     { jjCheckNAddStates(204, 206); }
                  break;
               case 65:
                  if (curChar == 10 && kind > 42)
                     kind = 42;
                  break;
               case 66:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 65;
                  break;
               case 67:
                  if ((0x2400L & l) != 0L && kind > 42)
                     kind = 42;
                  break;
               case 68:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 42)
                     kind = 42;
                  { jjCheckNAddStates(207, 210); }
                  break;
               case 69:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 42)
                     kind = 42;
                  { jjCheckNAdd(69); }
                  break;
               case 70:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(211, 213); }
                  break;
               case 71:
                  if (curChar == 34)
                     { jjCheckNAddStates(181, 184); }
                  break;
               case 72:
                  if ((0xfffffffbffffc9ffL & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddTwoStates(72, 73); }
                  break;
               case 75:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddStates(214, 216); }
                  break;
               case 76:
                  if ((0x1800400000000L & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddTwoStates(72, 73); }
                  break;
               case 77:
                  if ((0xfffffffbffffc9ffL & l) != 0L)
                     { jjCheckNAddStates(191, 193); }
                  break;
               case 80:
                  if ((0x3ff000000000000L & l) != 0L)
                     { jjCheckNAddStates(217, 220); }
                  break;
               case 81:
                  if (curChar == 34)
                     { jjCheckNAddTwoStates(82, 83); }
                  break;
               case 82:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddTwoStates(82, 83); }
                  break;
               case 83:
                  if (curChar == 58)
                     { jjCheckNAddStates(221, 223); }
                  break;
               case 84:
                  if (curChar == 10 && kind > 43)
                     kind = 43;
                  break;
               case 85:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 84;
                  break;
               case 86:
                  if ((0x2400L & l) != 0L && kind > 43)
                     kind = 43;
                  break;
               case 87:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 43)
                     kind = 43;
                  { jjCheckNAddStates(224, 227); }
                  break;
               case 88:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 43)
                     kind = 43;
                  { jjCheckNAdd(88); }
                  break;
               case 89:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(228, 230); }
                  break;
               case 90:
                  if ((0x1800400000000L & l) != 0L)
                     { jjCheckNAddStates(191, 193); }
                  break;
               case 91:
                  if ((0x3bffcb10ffffdbffL & l) == 0L)
                     break;
                  if (kind > 49)
                     kind = 49;
                  { jjCheckNAddStates(173, 178); }
                  break;
               case 92:
                  if ((0x7bffeff7ffffdbffL & l) == 0L)
                     break;
                  if (kind > 49)
                     kind = 49;
                  { jjCheckNAddTwoStates(92, 93); }
                  break;
               case 93:
                  if ((0xfffffffeffffffffL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 94;
                  break;
               case 94:
                  if (curChar != 35)
                     break;
                  if (kind > 49)
                     kind = 49;
                  { jjCheckNAddTwoStates(92, 93); }
                  break;
               case 95:
                  if ((0x7bffeff7ffffdbffL & l) != 0L)
                     { jjCheckNAddStates(231, 234); }
                  break;
               case 96:
                  if ((0xfffffffeffffffffL & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 97;
                  break;
               case 97:
                  if (curChar == 35)
                     { jjCheckNAddStates(231, 234); }
                  break;
               case 98:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddTwoStates(98, 99); }
                  break;
               case 99:
                  if (curChar == 58)
                     { jjCheckNAddStates(235, 237); }
                  break;
               case 100:
                  if (curChar == 10 && kind > 50)
                     kind = 50;
                  break;
               case 101:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 100;
                  break;
               case 102:
                  if ((0x2400L & l) != 0L && kind > 50)
                     kind = 50;
                  break;
               case 103:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 50)
                     kind = 50;
                  { jjCheckNAddStates(238, 241); }
                  break;
               case 104:
                  if ((0x100000200L & l) == 0L)
                     break;
                  if (kind > 50)
                     kind = 50;
                  { jjCheckNAdd(104); }
                  break;
               case 105:
                  if ((0x100000200L & l) != 0L)
                     { jjCheckNAddStates(242, 244); }
                  break;
               case 106:
                  if ((0x8400200000000000L & l) != 0L)
                     { jjAddStates(179, 180); }
                  break;
               case 107:
                  if ((0xfffffffeffffdbffL & l) == 0L)
                     break;
                  if (kind > 49)
                     kind = 49;
                  { jjCheckNAddTwoStates(92, 93); }
                  break;
               case 108:
                  if ((0xfffffffeffffdbffL & l) != 0L)
                     { jjCheckNAddStates(231, 234); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xc7fffffed7fffffeL & l) == 0L)
                     break;
                  if (kind > 49)
                     kind = 49;
                  { jjCheckNAddStates(173, 178); }
                  break;
               case 109:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(191, 193); }
                  else if (curChar == 92)
                     { jjAddStates(245, 246); }
                  if ((0xffffffffefffffffL & l) != 0L)
                  {
                     if (kind > 30)
                        kind = 30;
                     { jjCheckNAddTwoStates(72, 73); }
                  }
                  else if (curChar == 92)
                     { jjAddStates(247, 248); }
                  break;
               case 110:
                  { jjCheckNAddStates(170, 172); }
                  if (kind > 29)
                     kind = 29;
                  { jjCheckNAddTwoStates(56, 58); }
                  break;
               case 1:
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 7:
                  if ((0x47fffffeafffffffL & l) != 0L)
                     { jjAddStates(38, 42); }
                  break;
               case 18:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 12)
                     kind = 12;
                  jjstateSet[jjnewStateCnt++] = 18;
                  break;
               case 23:
                  if ((0xc7fffffed7fffffeL & l) == 0L)
                     break;
                  if (kind > 13)
                     kind = 13;
                  { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 25:
                  if (kind > 13)
                     kind = 13;
                  { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 36:
                  if (curChar == 71)
                     jjstateSet[jjnewStateCnt++] = 37;
                  break;
               case 38:
                  { jjAddStates(198, 200); }
                  break;
               case 42:
                  if (curChar == 65)
                     jjstateSet[jjnewStateCnt++] = 36;
                  break;
               case 43:
                  if (curChar == 84)
                     jjstateSet[jjnewStateCnt++] = 42;
                  break;
               case 44:
                  if (curChar == 76)
                     jjstateSet[jjnewStateCnt++] = 45;
                  break;
               case 50:
                  if (curChar == 77)
                     jjstateSet[jjnewStateCnt++] = 44;
                  break;
               case 51:
                  if (curChar == 65)
                     jjstateSet[jjnewStateCnt++] = 50;
                  break;
               case 52:
                  if (curChar == 89)
                     jjstateSet[jjnewStateCnt++] = 51;
                  break;
               case 56:
                  if (kind > 29)
                     kind = 29;
                  { jjCheckNAddTwoStates(56, 58); }
                  break;
               case 59:
                  { jjCheckNAddStates(170, 172); }
                  break;
               case 72:
                  if ((0xffffffffefffffffL & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddTwoStates(72, 73); }
                  break;
               case 73:
                  if (curChar == 92)
                     { jjAddStates(247, 248); }
                  break;
               case 74:
                  if (curChar == 120)
                     { jjCheckNAdd(75); }
                  break;
               case 75:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddStates(214, 216); }
                  break;
               case 76:
                  if ((0x55406490004000L & l) == 0L)
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddTwoStates(72, 73); }
                  break;
               case 77:
                  if ((0xffffffffefffffffL & l) != 0L)
                     { jjCheckNAddStates(191, 193); }
                  break;
               case 78:
                  if (curChar == 92)
                     { jjAddStates(245, 246); }
                  break;
               case 79:
                  if (curChar == 120)
                     { jjCheckNAdd(80); }
                  break;
               case 80:
                  if ((0x7e0000007eL & l) != 0L)
                     { jjCheckNAddStates(217, 220); }
                  break;
               case 90:
                  if ((0x55406490004000L & l) != 0L)
                     { jjCheckNAddStates(191, 193); }
                  break;
               case 92:
                  if ((0xd7ffffffd7ffffffL & l) == 0L)
                     break;
                  if (kind > 49)
                     kind = 49;
                  { jjCheckNAddTwoStates(92, 93); }
                  break;
               case 93:
                  jjstateSet[jjnewStateCnt++] = 94;
                  break;
               case 95:
                  if ((0xd7ffffffd7ffffffL & l) != 0L)
                     { jjCheckNAddStates(231, 234); }
                  break;
               case 96:
                  jjstateSet[jjnewStateCnt++] = 97;
                  break;
               case 107:
                  if (kind > 49)
                     kind = 49;
                  { jjCheckNAddTwoStates(92, 93); }
                  break;
               case 108:
                  { jjCheckNAddStates(231, 234); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_3(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(20, 22); }
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 49)
                        kind = 49;
                     { jjCheckNAddStates(173, 178); }
                  }
                  break;
               case 109:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 30)
                        kind = 30;
                     { jjCheckNAddTwoStates(72, 73); }
                  }
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(191, 193); }
                  break;
               case 110:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 29)
                        kind = 29;
                     { jjCheckNAddTwoStates(56, 58); }
                  }
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(170, 172); }
                  break;
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 4:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 1)
                     kind = 1;
                  break;
               case 11:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 9)
                     kind = 9;
                  break;
               case 12:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 9)
                     kind = 9;
                  { jjCheckNAddStates(46, 49); }
                  break;
               case 13:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 9)
                     kind = 9;
                  { jjCheckNAdd(13); }
                  break;
               case 14:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(50, 52); }
                  break;
               case 19:
                  if (jjCanMove_3(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(20, 22); }
                  break;
               case 23:
               case 25:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 13)
                     kind = 13;
                  { jjCheckNAddTwoStates(23, 24); }
                  break;
               case 29:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 18)
                     kind = 18;
                  break;
               case 30:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 18)
                     kind = 18;
                  { jjCheckNAddStates(56, 59); }
                  break;
               case 31:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 18)
                     kind = 18;
                  { jjCheckNAdd(31); }
                  break;
               case 32:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(60, 62); }
                  break;
               case 33:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51)
                     kind = 51;
                  break;
               case 34:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2) && kind > 52)
                     kind = 52;
                  break;
               case 37:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(194, 197); }
                  break;
               case 38:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(198, 200); }
                  break;
               case 41:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 10)
                     kind = 10;
                  break;
               case 45:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjAddStates(249, 250); }
                  break;
               case 49:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 11)
                     kind = 11;
                  break;
               case 56:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 29)
                     kind = 29;
                  { jjCheckNAddTwoStates(56, 58); }
                  break;
               case 59:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(170, 172); }
                  break;
               case 63:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjAddStates(251, 252); }
                  break;
               case 67:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 42)
                     kind = 42;
                  break;
               case 68:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 42)
                     kind = 42;
                  { jjCheckNAddStates(207, 210); }
                  break;
               case 69:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 42)
                     kind = 42;
                  { jjCheckNAdd(69); }
                  break;
               case 70:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(211, 213); }
                  break;
               case 72:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 30)
                     kind = 30;
                  { jjCheckNAddTwoStates(72, 73); }
                  break;
               case 77:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(191, 193); }
                  break;
               case 82:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjAddStates(253, 254); }
                  break;
               case 86:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 43)
                     kind = 43;
                  break;
               case 87:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 43)
                     kind = 43;
                  { jjCheckNAddStates(224, 227); }
                  break;
               case 88:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 43)
                     kind = 43;
                  { jjCheckNAdd(88); }
                  break;
               case 89:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(228, 230); }
                  break;
               case 91:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 49)
                     kind = 49;
                  { jjCheckNAddStates(173, 178); }
                  break;
               case 92:
               case 107:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 49)
                     kind = 49;
                  { jjCheckNAddTwoStates(92, 93); }
                  break;
               case 93:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjstateSet[jjnewStateCnt++] = 94;
                  break;
               case 95:
               case 108:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(231, 234); }
                  break;
               case 96:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                     jjstateSet[jjnewStateCnt++] = 97;
                  break;
               case 98:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddTwoStates(98, 99); }
                  break;
               case 102:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 50)
                     kind = 50;
                  break;
               case 103:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 50)
                     kind = 50;
                  { jjCheckNAddStates(238, 241); }
                  break;
               case 104:
                  if (!jjCanMove_2(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 50)
                     kind = 50;
                  { jjCheckNAdd(104); }
                  break;
               case 105:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                     { jjCheckNAddStates(242, 244); }
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 109 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_6(int pos, long active0){
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_6(int pos, long active0){
   return jjMoveNfa_6(jjStopStringLiteralDfa_6(pos, active0), pos + 1);
}
private int jjMoveStringLiteralDfa0_6(){
   switch(curChar)
   {
      case 66:
         return jjMoveStringLiteralDfa1_6(0x1cL);
      case 70:
         return jjMoveStringLiteralDfa1_6(0x40L);
      case 78:
         return jjMoveStringLiteralDfa1_6(0x20L);
      default :
         return jjMoveNfa_6(0, 0);
   }
}
private int jjMoveStringLiteralDfa1_6(long active0){
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(0, active0);
      return 1;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa2_6(active0, 0x40L);
      case 76:
         return jjMoveStringLiteralDfa2_6(active0, 0x1cL);
      case 85:
         return jjMoveStringLiteralDfa2_6(active0, 0x20L);
      default :
         break;
   }
   return jjStartNfa_6(0, active0);
}
private int jjMoveStringLiteralDfa2_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(0, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(1, active0);
      return 2;
   }
   switch(curChar)
   {
      case 76:
         return jjMoveStringLiteralDfa3_6(active0, 0x60L);
      case 79:
         return jjMoveStringLiteralDfa3_6(active0, 0x1cL);
      default :
         break;
   }
   return jjStartNfa_6(1, active0);
}
private int jjMoveStringLiteralDfa3_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(1, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(2, active0);
      return 3;
   }
   switch(curChar)
   {
      case 67:
         return jjMoveStringLiteralDfa4_6(active0, 0x1cL);
      case 76:
         return jjMoveStringLiteralDfa4_6(active0, 0x20L);
      case 83:
         return jjMoveStringLiteralDfa4_6(active0, 0x40L);
      default :
         break;
   }
   return jjStartNfa_6(2, active0);
}
private int jjMoveStringLiteralDfa4_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(2, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(3, active0);
      return 4;
   }
   switch(curChar)
   {
      case 69:
         return jjMoveStringLiteralDfa5_6(active0, 0x40L);
      case 75:
         return jjMoveStringLiteralDfa5_6(active0, 0x1cL);
      case 95:
         return jjMoveStringLiteralDfa5_6(active0, 0x20L);
      default :
         break;
   }
   return jjStartNfa_6(3, active0);
}
private int jjMoveStringLiteralDfa5_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(3, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(4, active0);
      return 5;
   }
   switch(curChar)
   {
      case 83:
         return jjMoveStringLiteralDfa6_6(active0, 0x20L);
      case 95:
         return jjMoveStringLiteralDfa6_6(active0, 0x5cL);
      default :
         break;
   }
   return jjStartNfa_6(4, active0);
}
private int jjMoveStringLiteralDfa6_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(4, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(5, active0);
      return 6;
   }
   switch(curChar)
   {
      case 67:
         return jjMoveStringLiteralDfa7_6(active0, 0x20L);
      case 69:
         return jjMoveStringLiteralDfa7_6(active0, 0x10L);
      case 77:
         return jjMoveStringLiteralDfa7_6(active0, 0x8L);
      case 83:
         return jjMoveStringLiteralDfa7_6(active0, 0x44L);
      default :
         break;
   }
   return jjStartNfa_6(5, active0);
}
private int jjMoveStringLiteralDfa7_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(5, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(6, active0);
      return 7;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa8_6(active0, 0x28L);
      case 69:
         return jjMoveStringLiteralDfa8_6(active0, 0x4L);
      case 78:
         return jjMoveStringLiteralDfa8_6(active0, 0x10L);
      case 84:
         return jjMoveStringLiteralDfa8_6(active0, 0x40L);
      default :
         break;
   }
   return jjStartNfa_6(6, active0);
}
private int jjMoveStringLiteralDfa8_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(6, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(7, active0);
      return 8;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa9_6(active0, 0x40L);
      case 68:
         if ((active0 & 0x10L) != 0L)
            return jjStopAtPos(8, 4);
         break;
      case 76:
         return jjMoveStringLiteralDfa9_6(active0, 0x20L);
      case 80:
         return jjMoveStringLiteralDfa9_6(active0, 0x8L);
      case 81:
         return jjMoveStringLiteralDfa9_6(active0, 0x4L);
      default :
         break;
   }
   return jjStartNfa_6(7, active0);
}
private int jjMoveStringLiteralDfa9_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(7, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(8, active0);
      return 9;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa10_6(active0, 0x20L);
      case 80:
         return jjMoveStringLiteralDfa10_6(active0, 0x8L);
      case 82:
         return jjMoveStringLiteralDfa10_6(active0, 0x40L);
      case 85:
         return jjMoveStringLiteralDfa10_6(active0, 0x4L);
      default :
         break;
   }
   return jjStartNfa_6(8, active0);
}
private int jjMoveStringLiteralDfa10_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(8, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(9, active0);
      return 10;
   }
   switch(curChar)
   {
      case 69:
         return jjMoveStringLiteralDfa11_6(active0, 0x4L);
      case 73:
         return jjMoveStringLiteralDfa11_6(active0, 0x8L);
      case 82:
         if ((active0 & 0x20L) != 0L)
            return jjStopAtPos(10, 5);
         break;
      case 84:
         if ((active0 & 0x40L) != 0L)
            return jjStopAtPos(10, 6);
         break;
      default :
         break;
   }
   return jjStartNfa_6(9, active0);
}
private int jjMoveStringLiteralDfa11_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(9, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(10, active0);
      return 11;
   }
   switch(curChar)
   {
      case 78:
         return jjMoveStringLiteralDfa12_6(active0, 0xcL);
      default :
         break;
   }
   return jjStartNfa_6(10, active0);
}
private int jjMoveStringLiteralDfa12_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(10, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(11, active0);
      return 12;
   }
   switch(curChar)
   {
      case 67:
         return jjMoveStringLiteralDfa13_6(active0, 0x4L);
      case 71:
         return jjMoveStringLiteralDfa13_6(active0, 0x8L);
      default :
         break;
   }
   return jjStartNfa_6(11, active0);
}
private int jjMoveStringLiteralDfa13_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(11, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(12, active0);
      return 13;
   }
   switch(curChar)
   {
      case 69:
         return jjMoveStringLiteralDfa14_6(active0, 0x4L);
      case 95:
         return jjMoveStringLiteralDfa14_6(active0, 0x8L);
      default :
         break;
   }
   return jjStartNfa_6(12, active0);
}
private int jjMoveStringLiteralDfa14_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(12, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(13, active0);
      return 14;
   }
   switch(curChar)
   {
      case 83:
         return jjMoveStringLiteralDfa15_6(active0, 0x8L);
      case 95:
         return jjMoveStringLiteralDfa15_6(active0, 0x4L);
      default :
         break;
   }
   return jjStartNfa_6(13, active0);
}
private int jjMoveStringLiteralDfa15_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(13, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(14, active0);
      return 15;
   }
   switch(curChar)
   {
      case 83:
         return jjMoveStringLiteralDfa16_6(active0, 0x4L);
      case 84:
         return jjMoveStringLiteralDfa16_6(active0, 0x8L);
      default :
         break;
   }
   return jjStartNfa_6(14, active0);
}
private int jjMoveStringLiteralDfa16_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(14, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(15, active0);
      return 16;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa17_6(active0, 0x8L);
      case 84:
         return jjMoveStringLiteralDfa17_6(active0, 0x4L);
      default :
         break;
   }
   return jjStartNfa_6(15, active0);
}
private int jjMoveStringLiteralDfa17_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(15, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(16, active0);
      return 17;
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa18_6(active0, 0x4L);
      case 82:
         return jjMoveStringLiteralDfa18_6(active0, 0x8L);
      default :
         break;
   }
   return jjStartNfa_6(16, active0);
}
private int jjMoveStringLiteralDfa18_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(16, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(17, active0);
      return 18;
   }
   switch(curChar)
   {
      case 82:
         return jjMoveStringLiteralDfa19_6(active0, 0x4L);
      case 84:
         if ((active0 & 0x8L) != 0L)
            return jjStopAtPos(18, 3);
         break;
      default :
         break;
   }
   return jjStartNfa_6(17, active0);
}
private int jjMoveStringLiteralDfa19_6(long old0, long active0){
   if (((active0 &= old0)) == 0L)
      return jjStartNfa_6(17, old0);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
      jjStopStringLiteralDfa_6(18, active0);
      return 19;
   }
   switch(curChar)
   {
      case 84:
         if ((active0 & 0x4L) != 0L)
            return jjStopAtPos(19, 2);
         break;
      default :
         break;
   }
   return jjStartNfa_6(18, active0);
}
private int jjMoveNfa_6(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 9;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  else if (curChar == 35)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddStates(17, 19); }
                  }
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 1:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddStates(17, 19); }
                  break;
               case 2:
                  if (curChar == 10 && kind > 1)
                     kind = 1;
                  break;
               case 3:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 4:
                  if ((0x2400L & l) != 0L && kind > 1)
                     kind = 1;
                  break;
               case 5:
                  if (curChar == 10 && kind > 51)
                     kind = 51;
                  break;
               case 6:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 7:
                  if ((0x2400L & l) != 0L && kind > 51)
                     kind = 51;
                  break;
               case 8:
                  if ((0x100000200L & l) != 0L && kind > 52)
                     kind = 52;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 1:
                  kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  break;
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 4:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 1)
                     kind = 1;
                  break;
               case 7:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51)
                     kind = 51;
                  break;
               case 8:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2) && kind > 52)
                     kind = 52;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 9 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private int jjMoveStringLiteralDfa0_0()
{
   return jjMoveNfa_0(0, 0);
}
private int jjMoveNfa_0(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 11;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xfffffffeffffdbffL & l) != 0L)
                  {
                     if (kind > 48)
                        kind = 48;
                     { jjCheckNAdd(6); }
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  else if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 7;
                  else if (curChar == 35)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddStates(17, 19); }
                  }
                  break;
               case 1:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddStates(17, 19); }
                  break;
               case 2:
                  if (curChar == 10 && kind > 1)
                     kind = 1;
                  break;
               case 3:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 4:
                  if ((0x2400L & l) != 0L && kind > 1)
                     kind = 1;
                  break;
               case 5:
                  if ((0xfffffffeffffdbffL & l) == 0L)
                     break;
                  if (kind > 48)
                     kind = 48;
                  { jjCheckNAdd(6); }
                  break;
               case 6:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 48)
                     kind = 48;
                  { jjCheckNAdd(6); }
                  break;
               case 7:
                  if (curChar == 10 && kind > 51)
                     kind = 51;
                  break;
               case 8:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 7;
                  break;
               case 9:
                  if ((0x2400L & l) != 0L && kind > 51)
                     kind = 51;
                  break;
               case 10:
                  if ((0x100000200L & l) != 0L && kind > 52)
                     kind = 52;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 6:
                  if (kind > 48)
                     kind = 48;
                  { jjCheckNAdd(6); }
                  break;
               case 1:
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 48)
                        kind = 48;
                     { jjCheckNAdd(6); }
                  }
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  break;
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 4:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 1)
                     kind = 1;
                  break;
               case 5:
               case 6:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 48)
                     kind = 48;
                  { jjCheckNAdd(6); }
                  break;
               case 9:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51)
                     kind = 51;
                  break;
               case 10:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2) && kind > 52)
                     kind = 52;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 11 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_2(int pos, long active0){
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_2(int pos, long active0){
   return jjMoveNfa_2(jjStopStringLiteralDfa_2(pos, active0), pos + 1);
}
private int jjMoveStringLiteralDfa0_2(){
   switch(curChar)
   {
      case 39:
         return jjStartNfaWithStates_2(0, 36, 6);
      default :
         return jjMoveNfa_2(0, 0);
   }
}
private int jjStartNfaWithStates_2(int pos, int kind, int state)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { return pos + 1; }
   return jjMoveNfa_2(state, pos + 1);
}
private int jjMoveNfa_2(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 12;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xffffff7fffffdbffL & l) != 0L)
                  {
                     if (kind > 35)
                        kind = 35;
                     { jjCheckNAddTwoStates(5, 7); }
                  }
                  else if ((0x2400L & l) != 0L)
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  else if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 6;
                  if ((0x100000200L & l) != 0L)
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  else if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 8;
                  else if (curChar == 35)
                  {
                     if (kind > 1)
                        kind = 1;
                     { jjCheckNAddStates(17, 19); }
                  }
                  break;
               case 1:
                  if ((0xffffffffffffdbffL & l) == 0L)
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjCheckNAddStates(17, 19); }
                  break;
               case 2:
                  if (curChar == 10 && kind > 1)
                     kind = 1;
                  break;
               case 3:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 4:
                  if ((0x2400L & l) != 0L && kind > 1)
                     kind = 1;
                  break;
               case 5:
                  if ((0xffffff7fffffdbffL & l) == 0L)
                     break;
                  if (kind > 35)
                     kind = 35;
                  { jjCheckNAddTwoStates(5, 7); }
                  break;
               case 6:
                  if (curChar != 39)
                     break;
                  if (kind > 35)
                     kind = 35;
                  { jjCheckNAddTwoStates(5, 7); }
                  break;
               case 7:
                  if (curChar == 39)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               case 8:
                  if (curChar == 10 && kind > 51)
                     kind = 51;
                  break;
               case 9:
                  if (curChar == 13)
                     jjstateSet[jjnewStateCnt++] = 8;
                  break;
               case 10:
                  if ((0x2400L & l) != 0L && kind > 51)
                     kind = 51;
                  break;
               case 11:
                  if ((0x100000200L & l) != 0L && kind > 52)
                     kind = 52;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
               case 5:
                  if (kind > 35)
                     kind = 35;
                  { jjCheckNAddTwoStates(5, 7); }
                  break;
               case 1:
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 35)
                        kind = 35;
                     { jjCheckNAddTwoStates(5, 7); }
                  }
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 51)
                        kind = 51;
                  }
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2))
                  {
                     if (kind > 52)
                        kind = 52;
                  }
                  break;
               case 1:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 1)
                     kind = 1;
                  { jjAddStates(17, 19); }
                  break;
               case 4:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 1)
                     kind = 1;
                  break;
               case 5:
                  if (!jjCanMove_0(hiByte, i1, i2, l1, l2))
                     break;
                  if (kind > 35)
                     kind = 35;
                  { jjCheckNAddTwoStates(5, 7); }
                  break;
               case 10:
                  if (jjCanMove_1(hiByte, i1, i2, l1, l2) && kind > 51)
                     kind = 51;
                  break;
               case 11:
                  if (jjCanMove_2(hiByte, i1, i2, l1, l2) && kind > 52)
                     kind = 52;
                  break;
               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 12 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}

/** Token literal values. */
public static final String[] jjstrLiteralImages = {
"", null, 
"\102\114\117\103\113\137\123\105\121\125\105\116\103\105\137\123\124\101\122\124", 
"\102\114\117\103\113\137\115\101\120\120\111\116\107\137\123\124\101\122\124", "\102\114\117\103\113\137\105\116\104", 
"\116\125\114\114\137\123\103\101\114\101\122", "\106\101\114\123\105\137\123\124\101\122\124", null, null, null, null, null, 
null, null, "\133", "\173", "\135", "\175", null, null, null, null, null, null, null, 
null, null, "\47\47", "\42\42", null, null, null, null, null, "\42", null, "\47", 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, };
protected Token jjFillToken()
{
   final Token t;
   final String curTokenImage;
   final int beginLine;
   final int endLine;
   final int beginColumn;
   final int endColumn;
   String im = jjstrLiteralImages[jjmatchedKind];
   curTokenImage = (im == null) ? input_stream.GetImage() : im;
   beginLine = input_stream.getBeginLine();
   beginColumn = input_stream.getBeginColumn();
   endLine = input_stream.getEndLine();
   endColumn = input_stream.getEndColumn();
   t = Token.newToken(jjmatchedKind);
   t.kind = jjmatchedKind;
   t.image = curTokenImage;

   t.beginLine = beginLine;
   t.endLine = endLine;
   t.beginColumn = beginColumn;
   t.endColumn = endColumn;

   return t;
}
static final int[] jjnextStates = {
   114, 115, 117, 119, 120, 122, 130, 94, 95, 99, 100, 78, 80, 81, 83, 65, 
   74, 1, 3, 4, 19, 21, 22, 50, 51, 52, 6, 7, 8, 10, 11, 12, 
   81, 83, 84, 99, 100, 103, 7, 8, 10, 11, 12, 10, 11, 12, 13, 14, 
   10, 11, 14, 10, 11, 28, 29, 30, 31, 32, 28, 29, 32, 28, 29, 36, 
   38, 39, 53, 54, 50, 51, 54, 50, 51, 59, 60, 62, 63, 60, 62, 63, 
   68, 70, 71, 88, 89, 90, 91, 92, 88, 89, 92, 88, 89, 94, 95, 97, 
   99, 100, 102, 103, 107, 108, 109, 110, 111, 107, 108, 111, 107, 108, 114, 115, 
   117, 119, 120, 122, 130, 125, 126, 127, 128, 129, 125, 126, 129, 125, 126, 131, 
   125, 126, 127, 43, 44, 101, 112, 96, 98, 67, 68, 85, 86, 104, 105, 7, 
   8, 9, 10, 11, 7, 8, 11, 7, 8, 15, 17, 18, 5, 6, 8, 14, 
   16, 17, 14, 16, 17, 7, 9, 6, 7, 9, 59, 61, 62, 92, 93, 95, 
   96, 98, 99, 107, 108, 72, 73, 77, 78, 56, 58, 59, 61, 43, 52, 77, 
   78, 81, 37, 38, 40, 41, 38, 40, 41, 46, 48, 49, 66, 67, 68, 69, 
   70, 66, 67, 70, 66, 67, 72, 73, 75, 77, 78, 80, 81, 85, 86, 87, 
   88, 89, 85, 86, 89, 85, 86, 95, 96, 98, 99, 101, 102, 103, 104, 105, 
   101, 102, 105, 101, 102, 79, 90, 74, 76, 45, 46, 63, 64, 82, 83, 
};
private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec2[i2] & l2) != 0L);
      default :
         if ((jjbitVec0[i1] & l1) != 0L)
            return true;
         return false;
   }
}
private static final boolean jjCanMove_1(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec3[i2] & l2) != 0L);
      case 32:
         return ((jjbitVec4[i2] & l2) != 0L);
      default :
         return false;
   }
}
private static final boolean jjCanMove_2(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec5[i2] & l2) != 0L);
      case 22:
         return ((jjbitVec6[i2] & l2) != 0L);
      case 24:
         return ((jjbitVec7[i2] & l2) != 0L);
      case 32:
         return ((jjbitVec8[i2] & l2) != 0L);
      case 48:
         return ((jjbitVec9[i2] & l2) != 0L);
      case 254:
         return ((jjbitVec10[i2] & l2) != 0L);
      default :
         return false;
   }
}
private static final boolean jjCanMove_3(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec11[i2] & l2) != 0L);
      case 22:
         return ((jjbitVec6[i2] & l2) != 0L);
      case 24:
         return ((jjbitVec7[i2] & l2) != 0L);
      case 32:
         return ((jjbitVec12[i2] & l2) != 0L);
      case 48:
         return ((jjbitVec9[i2] & l2) != 0L);
      case 254:
         return ((jjbitVec10[i2] & l2) != 0L);
      default :
         return false;
   }
}

int curLexState = 7;
int defaultLexState = 7;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

/** Get the next Token. */
public Token getNextToken() 
{
  Token specialToken = null;
  Token matchedToken;
  int curPos = 0;

  EOFLoop :
  for (;;)
  {
   try
   {
      curChar = input_stream.BeginToken();
   }
   catch(Exception e)
   {
      jjmatchedKind = 0;
      jjmatchedPos = -1;
      matchedToken = jjFillToken();
      matchedToken.specialToken = specialToken;
      CommonTokenAction(matchedToken);
      return matchedToken;
   }
   image = jjimage;
   image.setLength(0);
   jjimageLen = 0;

   switch(curLexState)
   {
     case 0:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_0();
       break;
     case 1:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_1();
       break;
     case 2:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_2();
       break;
     case 3:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_3();
       break;
     case 4:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_4();
       break;
     case 5:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_5();
       break;
     case 6:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_6();
       break;
     case 7:
       jjmatchedKind = 0x7fffffff;
       jjmatchedPos = 0;
       curPos = jjMoveStringLiteralDfa0_7();
       break;
   }
     if (jjmatchedKind != 0x7fffffff)
     {
        if (jjmatchedPos + 1 < curPos)
           input_stream.backup(curPos - jjmatchedPos - 1);
        if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           matchedToken = jjFillToken();
           matchedToken.specialToken = specialToken;
           TokenLexicalActions(matchedToken);
       if (jjnewLexState[jjmatchedKind] != -1)
         curLexState = jjnewLexState[jjmatchedKind];
           CommonTokenAction(matchedToken);
           return matchedToken;
        }
        else
        {
           if ((jjtoSpecial[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
           {
              matchedToken = jjFillToken();
              if (specialToken == null)
                 specialToken = matchedToken;
              else
              {
                 matchedToken.specialToken = specialToken;
                 specialToken = (specialToken.next = matchedToken);
              }
              SkipLexicalActions(matchedToken);
           }
           else
              SkipLexicalActions(null);
         if (jjnewLexState[jjmatchedKind] != -1)
           curLexState = jjnewLexState[jjmatchedKind];
           continue EOFLoop;
        }
     }
     int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrException(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrException.LEXICAL_ERROR);
  }
}

void SkipLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 1 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
        ignorableComment(matchedToken);
         break;
      case 51 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                                ignorableWhiteSpace(matchedToken);
         break;
      case 52 :
         image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                                                                                                                  ignorableWhiteSpace(matchedToken);
         break;
      default :
         break;
   }
}
void MoreLexicalActions()
{
   jjimageLen += (lengthOfMatch = jjmatchedPos + 1);
   switch(jjmatchedKind)
   {
      default :
         break;
   }
}
void TokenLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 14 :
        image.append(jjstrLiteralImages[14]);
        lengthOfMatch = jjstrLiteralImages[14].length();
                               flowSequenceNesting++;
         break;
      case 15 :
        image.append(jjstrLiteralImages[15]);
        lengthOfMatch = jjstrLiteralImages[15].length();
                              flowMappingeNesting++;
         break;
      case 16 :
        image.append(jjstrLiteralImages[16]);
        lengthOfMatch = jjstrLiteralImages[16].length();
                             flowSequenceNesting--; if (!insideFlow()) SwitchTo(DEFAULT);
         break;
      case 17 :
        image.append(jjstrLiteralImages[17]);
        lengthOfMatch = jjstrLiteralImages[17].length();
                            flowMappingeNesting--;  if (!insideFlow()) SwitchTo(DEFAULT);
         break;
      case 34 :
        image.append(jjstrLiteralImages[34]);
        lengthOfMatch = jjstrLiteralImages[34].length();
        if (insideFlow()) SwitchTo(FLOW);
        else SwitchTo(DEFAULT);
         break;
      case 36 :
        image.append(jjstrLiteralImages[36]);
        lengthOfMatch = jjstrLiteralImages[36].length();
        if (insideFlow()) SwitchTo(FLOW);
        else SwitchTo(DEFAULT);
         break;
      case 45 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
                if (matchedToken.image.startsWith("--- ") || matchedToken.image.startsWith("... ")) {
                        backup(matchedToken.image.length());
                        matchedToken.kind = FALSE_START;
                        matchedToken.image = "FALSE_START";
                        // we will need to unwind *all* indents
                        // for Document start and end indicators
                        // so force the column to 0
                        // tokenizer code with switch back to DEFAULT state
                        matchedToken.beginColumn = FIRST_COLUMN;
                        SwitchTo(DOCUMENT_START_END);
                } else {
                        SwitchTo(INDENTED);
                }
         break;
      case 47 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    // not a match if the indent is > than parent, put the token back
    if (isIndentedScalarFinished(matchedToken)) {
        SwitchTo(DEFAULT);
        }
         break;
      case 48 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
    // not a match if the indent is > than parent, put the token back
    if (isIndentedScalarFinished(matchedToken)) {
        SwitchTo(DEFAULT);
        }
         break;
      default :
         break;
   }
}
private void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}

private void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}

    /** Constructor. */
    public YamlParserTokenManager(JavaCharStream stream){

      if (JavaCharStream.staticFlag)
            throw new RuntimeException("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");

    input_stream = stream;
  }

  /** Constructor. */
  public YamlParserTokenManager (JavaCharStream stream, int lexState){
    ReInit(stream);
    SwitchTo(lexState);
  }

  /** Reinitialise parser. */
  
  public void ReInit(JavaCharStream stream)
  {


    jjmatchedPos =
    jjnewStateCnt =
    0;
    curLexState = defaultLexState;
    input_stream = stream;
    ReInitRounds();
  }

  private void ReInitRounds()
  {
    int i;
    jjround = 0x80000001;
    for (i = 133; i-- > 0;)
      jjrounds[i] = 0x80000000;
  }

  /** Reinitialise parser. */
  public void ReInit(JavaCharStream stream, int lexState)
  
  {
    ReInit(stream);
    SwitchTo(lexState);
  }

  /** Switch to specified lex state. */
  public void SwitchTo(int lexState)
  {
    if (lexState >= 8 || lexState < 0)
      throw new TokenMgrException("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrException.INVALID_LEXICAL_STATE);
    else
      curLexState = lexState;
  }


/** Lexer state names. */
public static final String[] lexStateNames = {
   "BLOCK_INDENTED",
   "INDENTED",
   "SINGLEQUOTE",
   "DOUBLEQUOTE",
   "DOCUMENT_START_END",
   "FLOW",
   "UNREACHABLE",
   "DEFAULT",
};

/** Lex State array. */
public static final int[] jjnewLexState = {
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 5, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, 2, 3, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, 
};
static final long[] jjtoToken = {
   0x7eddff81ffe7dL, 
};
static final long[] jjtoSkip = {
   0x18000000000002L, 
};
static final long[] jjtoSpecial = {
   0x18000000000002L, 
};
static final long[] jjtoMore = {
   0x0L, 
};
    protected JavaCharStream  input_stream;

    private final int[] jjrounds = new int[133];
    private final int[] jjstateSet = new int[2 * 133];
    private final StringBuilder jjimage = new StringBuilder();
    private StringBuilder image = jjimage;
    private int jjimageLen;
    private int lengthOfMatch;
    protected int curChar;
}
