/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.xsltransform;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.okapi.common.ConfigurationString;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.xsltransform.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@UsingParameters(value=Parameters.class)
public class XSLTransformStep
extends BasePipelineStep {
    private static final String FACTORY_PROP = "javax.xml.transform.TransformerFactory";
    private static final String XPATH_PROP = "javax.xml.xpath.XPathFactory";
    private static final String VAR_SRCLANG = "${srcLang}";
    private static final String VAR_TRGLANG = "${trgLang}";
    private static final String VAR_INPUTPATH = "${inputPath}";
    private static final String VAR_INPUTURI = "${inputURI}";
    private static final String VAR_OUTPUTPATH = "${outputPath}";
    private static final String VAR_INPUTPATH1 = "${inputPath1}";
    private static final String VAR_INPUTURI1 = "${inputURI1}";
    private static final String VAR_OUTPUTPATH1 = "${outputPath1}";
    private static final String VAR_INPUTPATH2 = "${inputPath2}";
    private static final String VAR_INPUTURI2 = "${inputURI2}";
    private static final String VAR_INPUTPATH3 = "${inputPath3}";
    private static final String VAR_INPUTURI3 = "${inputURI3}";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private Source xsltInput;
    private Map<String, String> paramList;
    private Transformer trans = null;
    private TransformerFactory fact;
    private boolean isDone;
    private URI outputURI;
    private RawDocument input1;
    private RawDocument input2;
    private RawDocument input3;
    private String originalProcessor = System.getProperty("javax.xml.transform.TransformerFactory");
    private String originalXpathProcessor = System.getProperty("javax.xml.xpath.XPathFactory");
    private ErrorListener errorListener;
    private String systemId;
    private EntityResolver entityResolver;
    private URIResolver uriResolver;

    @Override
    public void destroy() {
        this.trans = null;
        this.xsltInput = null;
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_URI)
    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_RAWDOC)
    public void setInput(RawDocument input) {
        this.input1 = input;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.input2 = secondInput;
    }

    @StepParameterMapping(parameterType=StepParameterType.THIRD_INPUT_RAWDOC)
    public void setThirdInput(RawDocument thridInput) {
        this.input3 = thridInput;
    }

    @Override
    public String getDescription() {
        return "Apply an XSLT template to an XML document. Expects: raw XML document. Sends back: raw document.";
    }

    @Override
    public String getName() {
        return "XSL Transformation";
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleStartBatch(Event event) {
        try {
            ConfigurationString cfgString = new ConfigurationString(this.params.getParamList());
            this.paramList = cfgString.toMap();
            this.xsltInput = new StreamSource(new File(this.params.getXsltPath()));
            if (this.params.getUseCustomTransformer()) {
                System.setProperty(FACTORY_PROP, this.params.getFactoryClass());
                if (!Util.isEmpty(this.params.getXpathClass())) {
                    System.setProperty(XPATH_PROP, this.params.getXpathClass());
                }
            }
            this.fact = TransformerFactory.newInstance();
            if (this.errorListener != null) {
                this.fact.setErrorListener(this.errorListener);
            }
            this.trans = this.fact.newTransformer(this.xsltInput);
            this.logger.info("Factory used: {}", (Object)this.fact.getClass().getCanonicalName());
            this.logger.info("Transformer used: {}", (Object)this.trans.getClass().getCanonicalName());
            this.isDone = true;
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error in XSLT input.\n" + e.getMessage(), e);
        }
        return event;
    }

    @Override
    protected Event handleStartBatchItem(Event event) {
        this.isDone = false;
        return event;
    }

    @Override
    protected Event handleRawDocument(Event event) {
        block13: {
            try {
                RawDocument rawDoc = (RawDocument)event.getResource();
                File outFile = null;
                this.trans.reset();
                this.fillParameters();
                Properties props = this.trans.getOutputProperties();
                for (Object obj : props.keySet()) {
                    String key = (String)obj;
                    String value = props.getProperty(key);
                    value = value + "";
                }
                XMLReader reader = XMLReaderFactory.createXMLReader();
                SAXSource xmlInput = new SAXSource(reader, new InputSource(rawDoc.getStream()));
                if (this.systemId != null) {
                    xmlInput.setSystemId(this.systemId);
                }
                if (this.entityResolver != null) {
                    reader.setEntityResolver(this.entityResolver);
                }
                if (this.errorListener != null) {
                    this.fact.setErrorListener(this.errorListener);
                }
                if (this.uriResolver != null) {
                    this.trans.setURIResolver(this.uriResolver);
                }
                if ((outFile = new File(this.outputURI)).isDirectory()) {
                    outFile = new File(outFile, Util.getFilename(rawDoc.getInputURI().getPath(), true));
                }
                StreamResult result = new StreamResult(outFile);
                this.trans.transform(xmlInput, result);
                if (this.params.getPassOnOutput()) {
                    event.setResource(new RawDocument(outFile.toURI(), "UTF-8", rawDoc.getSourceLocale(), rawDoc.getTargetLocale()));
                    break block13;
                }
                outFile.delete();
                Event event2 = Event.createNoopEvent();
                return event2;
            }
            catch (TransformerException e) {
                throw new OkapiIOException("Transformation error.\n" + e.getMessage(), e);
            }
            catch (SAXException e) {
                throw new OkapiIOException("Parser error.\n" + e.getMessage(), e);
            }
            finally {
                this.isDone = true;
            }
        }
        return event;
    }

    @Override
    protected Event handleEndBatch(Event event) {
        if (this.params.getUseCustomTransformer()) {
            if (this.originalProcessor == null) {
                System.clearProperty(FACTORY_PROP);
            } else {
                System.setProperty(FACTORY_PROP, this.originalProcessor);
            }
            if (this.originalXpathProcessor == null) {
                System.clearProperty(XPATH_PROP);
            } else {
                System.setProperty(XPATH_PROP, this.originalXpathProcessor);
            }
        }
        return event;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    private void fillParameters() {
        this.trans.clearParameters();
        String value = null;
        try {
            for (String key : this.paramList.keySet()) {
                value = this.paramList.get(key).replace(VAR_SRCLANG, this.input1.getSourceLocale().getLanguage());
                if (value.contains(VAR_TRGLANG)) {
                    value = value.replace(VAR_TRGLANG, this.input1.getTargetLocale().getLanguage());
                }
                if (value.contains(VAR_INPUTPATH)) {
                    value = value.replace(VAR_INPUTPATH, this.input1.getInputURI().getPath());
                }
                if (value.contains(VAR_INPUTURI)) {
                    value = value.replace(VAR_INPUTURI, this.input1.getInputURI().toString());
                }
                if (value.contains(VAR_OUTPUTPATH)) {
                    value = value.replace(VAR_OUTPUTPATH, this.outputURI.getPath());
                }
                if (value.contains(VAR_INPUTPATH1)) {
                    value = value.replace(VAR_INPUTPATH1, this.input1.getInputURI().getPath());
                }
                if (value.contains(VAR_INPUTURI1)) {
                    value = value.replace(VAR_INPUTURI1, this.input1.getInputURI().toString());
                }
                if (value.contains(VAR_OUTPUTPATH1)) {
                    value = value.replace(VAR_OUTPUTPATH1, this.outputURI.getPath());
                }
                if (value.contains(VAR_INPUTPATH2)) {
                    value = this.input2 == null ? value.replace(VAR_INPUTPATH2, "null") : value.replace(VAR_INPUTPATH2, this.input2.getInputURI().getPath());
                }
                if (value.contains(VAR_INPUTURI2)) {
                    value = this.input2 == null ? value.replace(VAR_INPUTURI2, "null") : value.replace(VAR_INPUTURI2, this.input2.getInputURI().toString());
                }
                if (value.contains(VAR_INPUTPATH3)) {
                    value = this.input3 == null ? value.replace(VAR_INPUTPATH3, "null") : value.replace(VAR_INPUTPATH3, this.input3.getInputURI().getPath());
                }
                if (value.contains(VAR_INPUTURI3)) {
                    value = this.input3 == null ? value.replace(VAR_INPUTURI3, "null") : value.replace(VAR_INPUTURI3, this.input3.getInputURI().toString());
                }
                this.trans.setParameter(key, value);
            }
        }
        catch (Throwable e) {
            this.logger.error("Error when trying to substitute variables in the parameter value '{}'", value);
        }
    }
}

