/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff2;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterUtil;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xliff2.MetadataSkeleton;
import net.sf.okapi.filters.xliff2.Parameters;
import net.sf.okapi.filters.xliff2.X2ToOkpConverter;
import net.sf.okapi.filters.xliff2.XLIFF2FilterWriter;
import net.sf.okapi.filters.xliff2.Xliff2Skeleton;
import net.sf.okapi.filters.xliff2.util.NotesMapper;
import net.sf.okapi.filters.xliff2.util.PropertiesMapper;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Skeleton;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.metadata.Metadata;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.XLIFFReader;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class XLIFF2Filter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Parameters params = new Parameters();
    private X2ToOkpConverter cvt;
    private boolean canceled;
    private XLIFFReader reader;
    private LocaleId srcLoc;
    private LocaleId trgLoc;
    private EncoderManager encoderManager;
    private Stack<String> idStack;
    private StartDocument startDoc;
    private LinkedList<net.sf.okapi.common.Event> queue;
    private XLIFFWriter writer;
    private StringWriter writerBuffer;

    @Override
    public String getName() {
        return "okf_xliff2";
    }

    @Override
    public String getDisplayName() {
        return "XLIFF-2 Filter";
    }

    @Override
    public void open(RawDocument input) {
        this.canceled = false;
        input.setEncoding("UTF-8");
        BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
        detector.detectBom();
        boolean hasUTF8BOM = detector.hasUtf8Bom();
        String lb = detector.getNewlineType().toString();
        String encoding = "UTF-8";
        if (detector.isAutodetected()) {
            encoding = detector.getEncoding();
        }
        this.srcLoc = input.getSourceLocale();
        this.trgLoc = input.getTargetLocale();
        String docName = null;
        if (input.getInputURI() != null) {
            docName = input.getInputURI().getPath();
        }
        int validation = this.params.getMaxValidation() ? 255 : 0;
        this.reader = new XLIFFReader(validation);
        this.reader.open(input.getStream());
        this.idStack = new Stack();
        this.queue = new LinkedList();
        this.startDoc = new StartDocument(this.idStack.push("docid"));
        this.startDoc.setName(docName);
        this.startDoc.setEncoding(encoding, hasUTF8BOM);
        this.startDoc.setFilterId(this.getName());
        this.startDoc.setFilterParameters(this.getParameters());
        this.startDoc.setFilterWriter(this.createFilterWriter());
        this.startDoc.setType("application/xliff+xml");
        this.startDoc.setMimeType("application/xliff+xml");
        this.startDoc.setMultilingual(true);
        this.startDoc.setLineBreak(lb);
        this.writer = new XLIFFWriter();
        this.writer.setLineBreak(lb);
        this.writer.setUseIndentation(true);
        this.writerBuffer = new StringWriter();
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().compile();
        }
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.open(input);
    }

    @Override
    public void close() {
        if (this.reader != null) {
            this.reader.close();
        }
        this.reader = null;
    }

    @Override
    public boolean hasNext() {
        if (!this.queue.isEmpty()) {
            return true;
        }
        if (this.canceled) {
            return false;
        }
        return this.reader.hasNext();
    }

    @Override
    public net.sf.okapi.common.Event next() {
        if (this.queue.isEmpty()) {
            while (!this.readNext()) {
            }
        }
        return this.queue.poll();
    }

    private boolean readNext() {
        Event x2Event = this.reader.next();
        switch (x2Event.getType()) {
            case START_DOCUMENT: {
                return false;
            }
            case START_XLIFF: {
                StartXliffData sxd = x2Event.getStartXliffData();
                this.processLocales(sxd);
                net.sf.okapi.common.Event event = new net.sf.okapi.common.Event(EventType.START_DOCUMENT, this.startDoc);
                this.queue.add(event);
                if (this.params.getNeedsSegmentation()) {
                    this.queue.add(FilterUtil.createDeepenSegmentationEvent());
                }
                PropertiesMapper.setStartXliffProperties(sxd, this.startDoc);
                return true;
            }
            case START_FILE: {
                StartFileData sfd = x2Event.getStartFileData();
                StartSubDocument startSubDoc = new StartSubDocument(this.idStack.peek(), sfd.getId());
                startSubDoc.setId(sfd.getId());
                startSubDoc.setIsTranslatable(sfd.getTranslate());
                startSubDoc.setName(sfd.getOriginal());
                PropertiesMapper.setStartFileProperties(sfd, startSubDoc);
                this.queue.add(new net.sf.okapi.common.Event(EventType.START_SUBDOCUMENT, startSubDoc));
                this.idStack.push(sfd.getId());
                startSubDoc.setName(sfd.getOriginal());
                return true;
            }
            case MID_FILE: {
                MidFileData midFileData = x2Event.getMidFileData();
                DocumentPart documentPart = this.cvt.convert(midFileData);
                documentPart.setIsTranslatable(false);
                documentPart.setPreserveWhitespaces(true);
                net.sf.okapi.common.Event event = new net.sf.okapi.common.Event(EventType.DOCUMENT_PART, documentPart);
                if (midFileData.hasMetadata()) {
                    documentPart.setSkeleton(new MetadataSkeleton(midFileData.getMetadata()));
                }
                NotesMapper.setAnnotations(midFileData, documentPart);
                this.queue.add(event);
                return true;
            }
            case SKELETON: {
                Skeleton skeletonData = x2Event.getSkeletonData();
                DocumentPart dp = new DocumentPart();
                dp.setIsTranslatable(false);
                dp.setPreserveWhitespaces(true);
                dp.setSkeleton(new Xliff2Skeleton(skeletonData));
                net.sf.okapi.common.Event event = new net.sf.okapi.common.Event(EventType.DOCUMENT_PART, dp);
                this.queue.add(event);
                return true;
            }
            case START_GROUP: {
                StartGroupData sgd = x2Event.getStartGroupData();
                StartGroup sg = this.cvt.convert(sgd, this.idStack.peek());
                if (sgd.hasMetadata()) {
                    Metadata metadata = sgd.getMetadata();
                    sg.setSkeleton(new MetadataSkeleton(metadata));
                }
                PropertiesMapper.setGroupProperties(sgd, sg);
                this.idStack.push(sgd.getId());
                NotesMapper.setAnnotations(sgd, sg);
                this.queue.add(new net.sf.okapi.common.Event(EventType.START_GROUP, sg));
                return true;
            }
            case TEXT_UNIT: {
                Unit unit = x2Event.getUnit();
                ITextUnit tu = this.cvt.convert(unit);
                if (unit.hasMetadata()) {
                    Metadata metadata = unit.getMetadata();
                    tu.setSkeleton(new MetadataSkeleton(metadata));
                }
                NotesMapper.setAnnotations(unit, tu);
                if (this.params.getUseCodeFinder()) {
                    for (Segment s : tu.getAlignedSegments()) {
                        this.params.getCodeFinder().process(s.text);
                        this.params.getCodeFinder().process(tu.getTargetSegment((LocaleId)this.trgLoc, (String)s.id, (boolean)false).text);
                    }
                }
                PropertiesMapper.setTextUnitProperties(unit, tu);
                tu.setMimeType(this.getMimeType());
                this.queue.add(new net.sf.okapi.common.Event(EventType.TEXT_UNIT, tu));
                return true;
            }
            case END_GROUP: {
                Ending eg = new Ending("end" + this.idStack.pop());
                this.queue.add(new net.sf.okapi.common.Event(EventType.END_GROUP, eg));
                return true;
            }
            case END_FILE: {
                Ending esd = new Ending("end" + this.idStack.pop());
                this.queue.add(new net.sf.okapi.common.Event(EventType.END_SUBDOCUMENT, esd));
                return true;
            }
            case END_XLIFF: {
                return false;
            }
            case END_DOCUMENT: {
                Ending ed = new Ending("end" + this.idStack.pop());
                this.queue.add(new net.sf.okapi.common.Event(EventType.END_DOCUMENT, ed));
                return true;
            }
            case INSIGNIFICANT_PART: {
                return false;
            }
        }
        return false;
    }

    private void processLocales(StartXliffData sxd) {
        String src = sxd.getSourceLanguage();
        if (this.srcLoc != null && !this.srcLoc.equals(LocaleId.EMPTY)) {
            if (!this.srcLoc.sameLanguageAs(src)) {
                this.logger.warn("Discrepancy between expected source ({}) and source in document ({}), Using '{}'", new Object[]{this.srcLoc, src, src});
                this.srcLoc = LocaleId.fromBCP47(src);
            }
        } else {
            this.srcLoc = LocaleId.fromBCP47(src);
        }
        this.startDoc.setLocale(this.srcLoc);
        this.writer.create(this.writerBuffer, this.srcLoc.toBCP47());
        String trg = sxd.getTargetLanguage();
        if (trg != null) {
            if (this.trgLoc != null && !this.trgLoc.equals(LocaleId.EMPTY)) {
                if (!this.trgLoc.sameLanguageAs(trg)) {
                    this.logger.warn("Discrepancy between expected target ({}) and target in document ({}), Using '{}'", new Object[]{this.trgLoc, trg, trg});
                    this.trgLoc = LocaleId.fromBCP47(trg);
                }
            } else {
                this.trgLoc = LocaleId.fromBCP47(trg);
            }
        } else if (this.trgLoc == null) {
            throw new NullPointerException("Target language not set and cannot be guessed.");
        }
        this.cvt = new X2ToOkpConverter(this.trgLoc);
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.queue.clear();
        this.queue.add(new net.sf.okapi.common.Event(EventType.CANCELED));
        this.close();
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new XLIFF2FilterWriter();
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/xliff+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public String getMimeType() {
        return "application/xliff+xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/xliff+xml", this.getClass().getName(), "XLIFF-2", "Configuration for XLIFF-2 documents.", null, ".xlf;.xliff;.xlf2;.xliff2"));
        return list;
    }
}

