/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.CellReferencesRange;
import net.sf.okapi.filters.openxml.XMLEventHelpers;

interface WorksheetFragments {
    public List<XMLEvent> events();

    public Set<Integer> hiddenRows();

    public Set<String> hiddenColumns();

    public List<CellReferencesRange> cellReferencesRanges();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public static class Default
    implements WorksheetFragments {
        private static final String ROW = "row";
        private static final String COL = "col";
        private static final String MERGE_CELL = "mergeCell";
        private static final QName HIDDEN = new QName("hidden");
        private static final QName MIN = new QName("min");
        private static final QName MAX = new QName("max");
        private static final QName REF = new QName("ref");
        private static final QName ROW_INDEX = new QName("r");
        private final boolean translateHidden;
        private final boolean hidden;
        private final List<XMLEvent> events;
        private final Set<Integer> hiddenRows;
        private final Set<String> hiddenColumns;
        private final List<CellReferencesRange> cellReferencesRanges;

        Default(boolean translateHidden, boolean hidden) {
            this(translateHidden, hidden, new LinkedList<XMLEvent>(), new LinkedHashSet<Integer>(), new LinkedHashSet<String>(), new LinkedList<CellReferencesRange>());
        }

        Default(boolean translateHidden, boolean hidden, List<XMLEvent> events, Set<Integer> hiddenRows, Set<String> hiddenColumns, List<CellReferencesRange> cellReferencesRanges) {
            this.translateHidden = translateHidden;
            this.hidden = hidden;
            this.events = events;
            this.hiddenRows = hiddenRows;
            this.hiddenColumns = hiddenColumns;
            this.cellReferencesRanges = cellReferencesRanges;
        }

        @Override
        public List<XMLEvent> events() {
            return this.events;
        }

        @Override
        public Set<Integer> hiddenRows() {
            return this.hiddenRows;
        }

        @Override
        public Set<String> hiddenColumns() {
            return this.hiddenColumns;
        }

        @Override
        public List<CellReferencesRange> cellReferencesRanges() {
            return this.cellReferencesRanges;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                this.events.add(e);
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if (ROW.equals(se.getName().getLocalPart())) {
                    if (!this.hidden(se)) continue;
                    this.hiddenRows.add(Integer.parseUnsignedInt(se.getAttributeByName(ROW_INDEX).getValue()));
                    continue;
                }
                if (COL.equals(se.getName().getLocalPart())) {
                    if (!this.hidden(se)) continue;
                    this.hiddenColumns.addAll(this.columnNames(se));
                    continue;
                }
                if (!MERGE_CELL.equals(se.getName().getLocalPart())) continue;
                this.cellReferencesRanges.add(new CellReferencesRange(se.getAttributeByName(REF).getValue()));
            }
        }

        private boolean hidden(StartElement startElement) {
            return !this.translateHidden && (this.hidden || XMLEventHelpers.getBooleanAttributeValue(startElement, HIDDEN, XMLEventHelpers.DEFAULT_BOOLEAN_ATTRIBUTE_FALSE_VALUE));
        }

        private List<String> columnNames(StartElement startElement) {
            try {
                ArrayList<String> names = new ArrayList<String>();
                int min = Integer.parseUnsignedInt(startElement.getAttributeByName(MIN).getValue());
                int max = Integer.parseUnsignedInt(startElement.getAttributeByName(MAX).getValue());
                for (int i = min; i <= max; ++i) {
                    names.add(Default.indexToColumnName(i));
                }
                return names;
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new OkapiBadFilterInputException("Invalid <col> element", e);
            }
        }

        private static String indexToColumnName(int index) {
            StringBuilder sb = new StringBuilder();
            while (index > 0) {
                int modulo = (index - 1) % 26;
                sb.insert(0, (char)(65 + modulo));
                index = (index - modulo) / 26;
            }
            return sb.toString();
        }
    }
}

