/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.annotation.XLIFFContextGroup;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.SubFilter;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.filters.openxml.Cell;
import net.sf.okapi.filters.openxml.CellReferencesRange;
import net.sf.okapi.filters.openxml.CellType;
import net.sf.okapi.filters.openxml.Cells;
import net.sf.okapi.filters.openxml.CrossSheetCellReference;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Metadata;
import net.sf.okapi.filters.openxml.MetadataContext;
import net.sf.okapi.filters.openxml.SharedStrings;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StringItemTextUnitMapper;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;

class SharedStringsPart
extends StyledTextPart {
    private static final String EMPTY = "";
    private static final String ROW_METADATA = "row-metadata";
    private static final String WORKSHEETS = "worksheets";
    private static final String ROWS = "rows";
    private final EncoderManager encoderManager;
    private final IFilter subfilter;
    private final Map<Metadata, Set<String>> dispersedTranslationRawSourcesByMetadata;
    private final Cells cells;
    private IdGenerator worksheetGroupIds;
    private IdGenerator rowGroupIds;
    private StartGroup worksheetStartGroup;
    private StartGroup rowStartGroup;
    private ContextTypes contextTypes;
    private List<XLIFFContextGroup.Context> groupContexts;

    SharedStringsPart(Document.General generalDocument, ZipEntry entry, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation, EncoderManager encoderManager, IFilter subfilter, Map<Metadata, Set<String>> dispersedTranslationRawSourcesByMetadata, Cells cells) {
        super(generalDocument, entry, styleDefinitions, styleOptimisation);
        this.encoderManager = encoderManager;
        this.subfilter = subfilter;
        this.dispersedTranslationRawSourcesByMetadata = dispersedTranslationRawSourcesByMetadata;
        this.cells = cells;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.documentId = this.generalDocument.documentId();
        this.subDocumentId = this.generalDocument.nextSubDocumentId();
        this.sourceLocale = this.generalDocument.sourceLocale();
        this.worksheetGroupIds = new IdGenerator(WORKSHEETS, "sg");
        SharedStrings.Default sharedStrings = new SharedStrings.Default(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), this.nestedBlockId, this.styleDefinitions, this.styleOptimisation);
        try (Reader reader = this.generalDocument.getPartReader(this.entry.getName());){
            sharedStrings.readWith(this.generalDocument.inputFactory().createXMLEventReader(reader));
        }
        sharedStrings.addFrom(this.cells.of(CellType.INLINE_STRING));
        this.formEventsFor(sharedStrings);
        return this.createStartSubDocumentEvent(this.documentId, this.subDocumentId);
    }

    private void formEventsFor(SharedStrings sharedStrings) {
        this.addEventToDocumentPart(sharedStrings.startDocument());
        this.addEventToDocumentPart(sharedStrings.startElement());
        this.flushDocumentPart();
        ListIterator<Cell> iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            Cell cell = iterator.next();
            if (this.cells.worksheetStartsAt(iterator)) {
                this.endRowGroup();
                this.endWorksheetGroup();
                this.initRowGroupIdsFrom(cell.worksheetName());
                this.startWorksheetGroupWith(cell.worksheetName());
                this.startRowGroupWith(String.valueOf(cell.cellReferencesRange().first().row()));
            } else if (this.cells.rowStartsAt(iterator)) {
                this.endRowGroup();
                if (!this.rowGroupIdsInitialised()) {
                    this.initRowGroupIdsFrom(cell.worksheetName());
                }
                this.startRowGroupWith(String.valueOf(cell.cellReferencesRange().first().row()));
            }
            if (CellType.INLINE_STRING != cell.type() && CellType.SHARED_STRING != cell.type()) {
                if (!cell.valuePresent()) continue;
                if (MetadataContext.ROW_AND_COLUMN == cell.metadataContext()) {
                    this.addContextType(cell.cellReferencesRange(), cell.value().asFormattedString());
                    continue;
                }
                if (MetadataContext.COLUMN != cell.metadataContext()) continue;
                this.addGroupContext(cell.cellReferencesRange(), cell.value().asFormattedString());
                continue;
            }
            StringItem stringItem = sharedStrings.stringItemFor(cell.value().asFormerInteger());
            if (MetadataContext.ROW_AND_COLUMN == cell.metadataContext()) {
                this.addContextType(cell.cellReferencesRange(), stringItem);
            } else if (MetadataContext.COLUMN == cell.metadataContext()) {
                this.addGroupContext(cell.cellReferencesRange(), stringItem);
            }
            if (cell.excluded()) {
                this.addBlockChunksToDocumentPart(stringItem.getChunks());
                this.flushDocumentPart();
                continue;
            }
            CrossSheetCellReference crossSheetCellReference = new CrossSheetCellReference(cell.worksheetName(), cell.cellReferencesRange().first());
            List<ITextUnit> textUnits = new StringItemTextUnitMapper(this.textUnitIds, this.generalDocument.eventFactory(), stringItem, crossSheetCellReference).map();
            if (textUnits.isEmpty()) {
                this.addBlockChunksToDocumentPart(stringItem.getChunks());
                this.flushDocumentPart();
                continue;
            }
            if (this.subfilter != null && !stringItem.isStyled()) {
                this.addSubfilteredEvents(textUnits);
            } else {
                this.addTextUnitEvents(textUnits);
            }
            String rawSource = stringItem.text();
            this.dispersedTranslationRawSourcesByMetadata.entrySet().stream().filter(e -> ((Metadata)e.getKey()).worksheetLocalisedName().equals(cell.worksheetName()) && ((Metadata)e.getKey()).cellReferencesRange().anyMatch(cell.cellReferencesRange()) && ((Set)e.getValue()).contains(rawSource)).forEach(e -> this.generalDocument.dispersedTranslations().add(crossSheetCellReference, ((Metadata)e.getKey()).name(), rawSource));
        }
        this.endRowGroup();
        this.endWorksheetGroup();
        this.addEventToDocumentPart(sharedStrings.endElement());
        this.addEventToDocumentPart(sharedStrings.endDocument());
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private boolean rowGroupIdsInitialised() {
        return null != this.rowGroupIds;
    }

    private void initRowGroupIdsFrom(String worksheetName) {
        this.rowGroupIds = new IdGenerator(worksheetName.concat(ROWS), "sg");
    }

    private boolean worksheetGroupInitialised() {
        return null != this.worksheetStartGroup;
    }

    private void startWorksheetGroupWith(String name) {
        this.contextTypes = new ContextTypes((Set)this.generalDocument.conditionalParameters().worksheetConfigurations().metadataColumnsFor(name));
        this.worksheetStartGroup = new StartGroup(EMPTY, this.worksheetGroupIds.createId());
        this.worksheetStartGroup.setName(name);
        this.filterEvents.add(new Event(EventType.START_GROUP, this.worksheetStartGroup));
    }

    private void endWorksheetGroup() {
        if (this.worksheetGroupInitialised()) {
            if (((Event)this.filterEvents.get(this.filterEvents.size() - 1)).isStartGroup()) {
                this.filterEvents.remove(this.filterEvents.size() - 1);
            } else {
                this.filterEvents.add(new Event(EventType.END_GROUP, new Ending(this.worksheetStartGroup.getId())));
            }
            this.worksheetStartGroup = null;
        }
    }

    boolean rowGroupInitialised() {
        return null != this.rowStartGroup;
    }

    private void startRowGroupWith(String name) {
        this.groupContexts = new LinkedList<XLIFFContextGroup.Context>();
        this.rowStartGroup = new StartGroup(EMPTY, this.rowGroupIds.createId());
        this.rowStartGroup.setName(String.valueOf(name));
        this.filterEvents.add(new Event(EventType.START_GROUP, this.rowStartGroup));
    }

    private void endRowGroup() {
        if (this.rowGroupInitialised()) {
            if (((Event)this.filterEvents.get(this.filterEvents.size() - 1)).isStartGroup()) {
                this.filterEvents.remove(this.filterEvents.size() - 1);
            } else {
                if (!this.groupContexts.isEmpty()) {
                    this.rowStartGroup.setAnnotation(new XLIFFContextGroup(this.encoderManager, ROW_METADATA, null, null, this.groupContexts));
                }
                this.filterEvents.add(new Event(EventType.END_GROUP, new Ending(this.rowStartGroup.getId())));
            }
            this.rowStartGroup = null;
        }
    }

    private void addContextType(CellReferencesRange cellReferencesRange, StringItem stringItem) {
        this.addContextType(cellReferencesRange, stringItem.text());
    }

    private void addContextType(CellReferencesRange cellReferencesRange, String string) {
        this.contextTypes.add(cellReferencesRange, string);
    }

    private void addGroupContext(CellReferencesRange cellReferencesRange, StringItem stringItem) {
        this.addGroupContext(cellReferencesRange, stringItem.text());
    }

    private void addGroupContext(CellReferencesRange cellReferencesRange, String string) {
        XLIFFContextGroup.Context context = new XLIFFContextGroup.Context(this.encoderManager, this.contextTypes.valueFor(cellReferencesRange), null, null);
        context.value(string);
        this.groupContexts.add(context);
    }

    private void addTextUnitEvents(List<ITextUnit> textUnits) {
        for (ITextUnit tu : textUnits) {
            this.filterEvents.add(new Event(EventType.TEXT_UNIT, tu));
        }
    }

    private void addSubfilteredEvents(List<ITextUnit> textUnits) {
        int subfilterIndex = 0;
        for (ITextUnit tu : textUnits) {
            SubFilter sf = new SubFilter(this.subfilter, this.encoderManager.getEncoder(), ++subfilterIndex, tu.getId(), tu.getName());
            Throwable throwable = null;
            try {
                this.filterEvents.addAll(sf.getEvents(new RawDocument(tu.getSource().getFirstContent().getText(), this.sourceLocale)));
                this.filterEvents.add(sf.createRefEvent(tu));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sf == null) continue;
                if (throwable != null) {
                    try {
                        sf.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                sf.close();
            }
        }
    }

    private static class ContextTypes {
        private static final String DELIMITER = ";";
        private final Set<String> metadataColumns;
        private final Map<CellReferencesRange, String> values;

        private ContextTypes(Set<String> metadataColumns) {
            this(metadataColumns, new LinkedHashMap<CellReferencesRange, String>());
        }

        private ContextTypes(Set<String> metadataColumns, Map<CellReferencesRange, String> values) {
            this.metadataColumns = metadataColumns;
            this.values = values;
        }

        void add(CellReferencesRange cellReferencesRange, String value) {
            this.values.put(cellReferencesRange, value);
        }

        String valueFor(CellReferencesRange cellReferencesRange) {
            String value = this.values.entrySet().stream().filter(e -> ((CellReferencesRange)e.getKey()).anyMatch(Collections.emptySet(), cellReferencesRange.columns())).map(e -> (String)e.getValue()).collect(Collectors.joining(DELIMITER));
            return value.isEmpty() ? cellReferencesRange.columnMatches(this.metadataColumns).stream().collect(Collectors.joining(DELIMITER)) : value;
        }
    }
}

