/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;

final class MarkupBuilder {
    private final Markup markup;
    private List<XMLEvent> events;

    MarkupBuilder(Markup markup) {
        this.markup = markup;
        this.events = new ArrayList<XMLEvent>();
    }

    void add(XMLEvent event) {
        this.events.add(event);
    }

    void addAll(List<XMLEvent> events) {
        this.events.addAll(events);
    }

    void add(MarkupComponent markupComponent) {
        this.flushEvents();
        this.markup.addComponent(markupComponent);
    }

    void add(Markup markup) {
        this.flushEvents();
        this.markup.addMarkup(markup);
    }

    XMLEvent peekCurrentMarkupComponentEvent() {
        if (this.events.isEmpty()) {
            return null;
        }
        return this.events.get(this.events.size() - 1);
    }

    private void flushEvents() {
        if (!this.events.isEmpty()) {
            this.markup.addComponent(new MarkupComponent.General(this.events));
            this.events = new ArrayList<XMLEvent>();
        }
    }

    Markup build() {
        this.flushEvents();
        return this.markup;
    }
}

