/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.sf.okapi.filters.openxml.CellReference;

final class CellReferencesRange {
    private static final char COLUMN_INDEX_PART_MINIMUM = 'A';
    private static final char COLUMN_INDEX_PART_MAXIMUM = 'Z';
    private static final String DELIMITER = ":";
    private final String string;
    private CellReference first;
    private CellReference last;
    private boolean split;
    private Set<Integer> rows;
    private Set<String> columns;

    CellReferencesRange(CellReference cellReference) {
        this(cellReference, cellReference);
    }

    CellReferencesRange(CellReference first, CellReference last) {
        this(first.toString().concat(DELIMITER).concat(last.toString()));
    }

    CellReferencesRange(String string) {
        this.string = string;
    }

    CellReference first() {
        if (!this.split) {
            this.split();
        }
        return this.first;
    }

    CellReference last() {
        if (!this.split) {
            this.split();
        }
        return this.last;
    }

    private void split() {
        String[] references = this.string.split(DELIMITER);
        if (references.length != 2) {
            throw new IllegalStateException("Unexpected merged cell range: ".concat(this.string));
        }
        this.first = new CellReference(references[0]);
        this.last = new CellReference(references[1]);
        this.split = true;
    }

    Set<Integer> rows() {
        if (null == this.rows) {
            this.rows = IntStream.rangeClosed(this.first().row(), this.last().row()).boxed().collect(Collectors.toSet());
        }
        return this.rows;
    }

    Set<String> columns() {
        if (null == this.columns) {
            this.columns = new LinkedHashSet<String>();
            String columnIndex = this.first().column();
            this.columns.add(columnIndex);
            while (!columnIndex.equals(this.last().column())) {
                columnIndex = CellReferencesRange.incrementColumnIndex(columnIndex);
                this.columns.add(columnIndex);
            }
        }
        return this.columns;
    }

    private static String incrementColumnIndex(String columnIndex) {
        return CellReferencesRange.incrementColumnIndexPart(columnIndex.toCharArray(), columnIndex.length() - 1);
    }

    private static String incrementColumnIndexPart(char[] columnIndexParts, int partPosition) {
        if (0 > partPosition) {
            return 'A' + new String(columnIndexParts);
        }
        char part = columnIndexParts[partPosition];
        if ('Z' == part) {
            columnIndexParts[partPosition] = 65;
            return CellReferencesRange.incrementColumnIndexPart(columnIndexParts, --partPosition);
        }
        columnIndexParts[partPosition] = part = (char)(part + '\u0001');
        return new String(columnIndexParts);
    }

    boolean partialMatch(Set<Integer> rows, Set<String> columns) {
        Set<Integer> rowMatches = this.rowMatches(rows);
        Set<String> columnMatches = this.columnMatches(columns);
        if (this.rows().size() == rowMatches.size() || this.columns().size() == columnMatches.size()) {
            return false;
        }
        return this.rows().size() > rowMatches.size() || this.columns().size() > columnMatches.size();
    }

    boolean anyMatch(Set<Integer> rows, Set<String> columns) {
        boolean rowsMatched = this.rows().stream().anyMatch((? super T r) -> rows.contains(r));
        boolean columnsMatched = this.columns().stream().anyMatch((? super T c) -> columns.contains(c));
        return rowsMatched || columnsMatched;
    }

    boolean anyMatch(CellReferencesRange cellReferencesRange) {
        return this.anyMatch(cellReferencesRange.rows(), cellReferencesRange.columns());
    }

    Set<Integer> rowMatches(Set<Integer> rows) {
        return this.rows().stream().filter(c -> rows.contains(c)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    Set<String> columnMatches(Set<String> columns) {
        return this.columns().stream().filter(c -> columns.contains(c)).collect(Collectors.toCollection(() -> new LinkedHashSet()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellReferencesRange that = (CellReferencesRange)o;
        return this.string.equals(that.string);
    }

    public int hashCode() {
        return Objects.hash(this.string);
    }

    public String toString() {
        return this.string;
    }
}

